/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class BinaryProjectFilter
extends ViewerFilter {
    private static final QualifiedName IMPORTED_KEY = new QualifiedName("org.eclipse.pde.core", "imported");
    private static final QualifiedName TEAM_KEY = new QualifiedName("org.eclipse.team.core", "repository");

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IProject project = null;
        if (element instanceof IJavaProject) {
            project = ((IJavaProject)element).getProject();
        } else if (element instanceof IProject) {
            project = (IProject)element;
        }
        if (project != null && (this.isPluginProject(project) || this.isFeatureProject(project))) {
            return !this.isBinary(project);
        }
        return true;
    }

    private boolean isPluginProject(IProject project) {
        if (!project.isOpen()) {
            return false;
        }
        return project.exists((IPath)new Path("plugin.xml")) || project.exists((IPath)new Path("fragment.xml"));
    }

    private boolean isFeatureProject(IProject project) {
        if (!project.isOpen()) {
            return false;
        }
        return project.exists((IPath)new Path("feature.xml"));
    }

    private boolean isBinary(IProject project) {
        try {
            String value = project.getPersistentProperty(IMPORTED_KEY);
            if (value == null) {
                return false;
            }
            if (value.equals("external")) {
                return true;
            }
            return value.equals("binary") && project.getSessionProperty(TEAM_KEY) == null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

