/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class BaseImportWizardSecondPage
extends WizardPage {
    protected static final String SETTINGS_ADD_FRAGMENTS = "addFragments";
    protected PluginImportWizardFirstPage page1;
    protected IPluginModelBase[] models = new IPluginModelBase[0];
    private String location;
    protected Button addFragmentsButton;
    protected TableViewer importListViewer;

    public BaseImportWizardSecondPage(String pageName, PluginImportWizardFirstPage page) {
        super(pageName);
        this.page1 = page;
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    protected Composite createImportList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.importList"));
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 180;
        gd.heightHint = 250;
        table.setLayoutData((Object)gd);
        this.importListViewer = new TableViewer(table);
        this.importListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.importListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.importListViewer.setInput((Object)PDECore.getDefault().getExternalModelManager());
        this.importListViewer.setSorter(ListUtil.PLUGIN_SORTER);
        return container;
    }

    protected Composite createComputationsOption(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.addFragmentsButton = new Button(composite, 32);
        this.addFragmentsButton.setText(PDEPlugin.getResourceString("ImportWizard.SecondPage.addFragments"));
        this.addFragmentsButton.setLayoutData((Object)new GridData(768));
        if (this.getDialogSettings().get(SETTINGS_ADD_FRAGMENTS) != null) {
            this.addFragmentsButton.setSelection(this.getDialogSettings().getBoolean(SETTINGS_ADD_FRAGMENTS));
        } else {
            this.addFragmentsButton.setSelection(true);
        }
        return composite;
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.isRefreshNeeded()) {
            this.models = this.page1.getModels();
            this.refreshPage();
        }
    }

    protected abstract void refreshPage();

    protected boolean isRefreshNeeded() {
        String currLocation = this.page1.getDropLocation();
        if (this.location == null || !this.location.equals(currLocation)) {
            this.location = this.page1.getDropLocation();
            return true;
        }
        return false;
    }

    private IPluginModelBase findModel(String id) {
        int i = 0;
        while (i < this.models.length) {
            if (this.models[i].getPluginBase().getId().equals(id)) {
                return this.models[i];
            }
            ++i;
        }
        return null;
    }

    private IFragmentModel[] findFragments(IPlugin plugin) {
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < this.models.length) {
            if (this.models[i] instanceof IFragmentModel) {
                IFragment fragment = ((IFragmentModel)this.models[i]).getFragment();
                if (plugin.getId().equalsIgnoreCase(fragment.getPluginId())) {
                    result.add(this.models[i]);
                }
            }
            ++i;
        }
        return result.toArray(new IFragmentModel[result.size()]);
    }

    protected void addPluginAndDependencies(IPluginModelBase model, ArrayList selected, boolean addFragments) {
        if (!selected.contains(model)) {
            selected.add(model);
            IPluginExtension[] extensions = model.getPluginBase().getExtensions();
            int i = 0;
            while (i < extensions.length) {
                if (extensions[i].getPoint().equals("org.eclipse.ant.core.extraClasspathEntries")) {
                    IPluginModelBase antModel = this.findModel("org.apache.ant");
                    if (antModel == null || selected.contains(antModel)) break;
                    selected.add(antModel);
                    break;
                }
                ++i;
            }
            this.addDependencies(model, selected, addFragments);
        }
    }

    protected void addDependencies(IPluginModelBase model, ArrayList selected, boolean addFragments) {
        IFragment fragment;
        IPluginModelBase found;
        if (model instanceof IPluginModel) {
            IPlugin plugin = ((IPluginModel)model).getPlugin();
            IPluginImport[] required = plugin.getImports();
            if (required.length > 0) {
                int i = 0;
                while (i < required.length) {
                    IPluginModelBase found2 = this.findModel(required[i].getId());
                    if (found2 != null) {
                        this.addPluginAndDependencies(found2, selected, addFragments);
                    }
                    ++i;
                }
            }
            if (addFragments) {
                IFragmentModel[] fragments = this.findFragments(plugin);
                int i = 0;
                while (i < fragments.length) {
                    this.addPluginAndDependencies((IPluginModelBase)fragments[i], selected, addFragments);
                    ++i;
                }
            }
        }
        if (addFragments && model instanceof IFragmentModel && (found = this.findModel((fragment = ((IFragmentModel)model).getFragment()).getPluginId())) != null) {
            this.addPluginAndDependencies(found, selected, addFragments);
        }
    }

    public IPluginModelBase[] getModelsToImport() {
        TableItem[] items = this.importListViewer.getTable().getItems();
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < items.length) {
            result.add(items[i].getData());
            ++i;
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SETTINGS_ADD_FRAGMENTS, this.addFragmentsButton.getSelection());
    }

    class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object element) {
            return new Object[0];
        }
    }
}

