/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class PointSelectionPage
extends WizardPage
implements ISelectionChangedListener {
    private TableViewer fPointListViewer;
    private IPluginBase fPluginBase;
    private Text fPointIdText;
    private Text fPointNameText;
    private Label fDescription;
    private Button fDescriptionButton;
    private Button fFilterCheck;
    private IPluginExtensionPoint fCurrentPoint;
    private IPluginExtension fNewExtension;
    private ShowDescriptionAction fShowDescriptionAction;
    private HashSet fAvailableImports = new HashSet();

    public PointSelectionPage(IPluginBase model) {
        super("pointSelectionPage");
        this.fPluginBase = model;
        this.setAvailableImports();
        this.setTitle(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.title"));
        this.setDescription(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.desc"));
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    private void setAvailableImports() {
        IPlugin parent;
        this.fAvailableImports.clear();
        this.fAvailableImports.add("org.eclipse.core.boot");
        this.fAvailableImports.add("org.eclipse.core.runtime");
        this.addSelfAndDirectImports(this.fPluginBase);
        if (this.fPluginBase instanceof IFragment && (parent = this.getParentPlugin((IFragment)this.fPluginBase)) != null) {
            this.addSelfAndDirectImports((IPluginBase)parent);
        }
    }

    private IPlugin getParentPlugin(IFragment fragment) {
        String targetId = fragment.getPluginId();
        String targetVersion = fragment.getPluginVersion();
        int match = fragment.getRule();
        return PDECore.getDefault().findPlugin(targetId, targetVersion, match);
    }

    private void addSelfAndDirectImports(IPluginBase pluginBase) {
        this.fAvailableImports.add(pluginBase.getId());
        IPluginImport[] imports = this.fPluginBase.getImports();
        int i = 0;
        while (i < imports.length) {
            String id = imports[i].getId();
            if (this.fAvailableImports.add(id)) {
                this.addReexportedImport(id);
            }
            ++i;
        }
    }

    private void addReexportedImport(String id) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        ModelEntry entry = manager.findEntry(id);
        if (entry != null) {
            IPluginModelBase model = entry.getActiveModel();
            IPluginImport[] imports = model.getPluginBase().getImports();
            int i = 0;
            while (i < imports.length) {
                if (imports[i].isReexported() && this.fAvailableImports.add(imports[i].getId())) {
                    this.addReexportedImport(imports[i].getId());
                }
                ++i;
            }
        }
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(272));
        this.fFilterCheck = new Button(outerContainer, 32);
        this.fFilterCheck.setText(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.filterCheck"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fFilterCheck.setLayoutData((Object)gd);
        this.fFilterCheck.setSelection(true);
        this.fFilterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointSelectionPage.this.fPointListViewer.refresh();
            }
        });
        this.fPointListViewer = new TableViewer(outerContainer, 2816);
        this.fPointListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fPointListViewer.setLabelProvider((IBaseLabelProvider)new PointLabelProvider());
        this.fPointListViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fPointListViewer.setSorter(ListUtil.NAME_SORTER);
        gd = new GridData(1808);
        gd.heightHint = 300;
        gd.horizontalSpan = 2;
        this.fPointListViewer.getTable().setLayoutData((Object)gd);
        this.fDescriptionButton = new Button(outerContainer, 8);
        this.fDescriptionButton.setText(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.descButton"));
        gd = new GridData(2);
        this.fDescriptionButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.fDescriptionButton);
        this.fDescriptionButton.setEnabled(false);
        this.fDescriptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointSelectionPage.this.doShowDescription();
            }
        });
        Label label = new Label(outerContainer, 0);
        label.setText(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.pointId"));
        this.fPointIdText = new Text(outerContainer, 2052);
        gd = new GridData(768);
        this.fPointIdText.setLayoutData((Object)gd);
        new Label(outerContainer, 0);
        label = new Label(outerContainer, 0);
        label.setText(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.pointName"));
        this.fPointNameText = new Text(outerContainer, 2052);
        gd = new GridData(768);
        this.fPointNameText.setLayoutData((Object)gd);
        new Label(outerContainer, 0);
        this.createDescriptionIn(outerContainer);
        this.initialize();
        this.setControl((Control)outerContainer);
        Dialog.applyDialogFont((Control)outerContainer);
        WorkbenchHelp.setHelp((Control)outerContainer, (String)"org.eclipse.pde.doc.user.add_extensions_schema_based");
    }

    public boolean canFinish() {
        IStructuredSelection ssel;
        ISelection selection;
        return this.fPointListViewer != null && (selection = this.fPointListViewer.getSelection()) instanceof IStructuredSelection && !(ssel = (IStructuredSelection)selection).isEmpty();
    }

    public void createDescriptionIn(Composite composite) {
        this.fDescription = new Label(composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fDescription.setLayoutData((Object)gd);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public boolean finish() {
        String name;
        String id = this.fPointIdText.getText();
        if (id.length() == 0) {
            id = null;
        }
        if ((name = this.fPointNameText.getText()).length() == 0) {
            name = null;
        }
        String point = this.fCurrentPoint.getFullId();
        try {
            IPluginExtension extension = this.fPluginBase.getModel().getFactory().createExtension();
            extension.setName(name);
            extension.setPoint(point);
            if (id != null) {
                extension.setId(id);
            }
            this.fPluginBase.add(extension);
            String pluginID = this.fCurrentPoint.getPluginBase().getId();
            if (!this.fAvailableImports.contains(pluginID)) {
                IPluginModelBase modelBase = (IPluginModelBase)this.fPluginBase.getModel();
                IPluginImport importNode = modelBase.getPluginFactory().createImport();
                importNode.setId(pluginID);
                this.fPluginBase.add(importNode);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return true;
    }

    private void doShowDescription() {
        if (this.fShowDescriptionAction == null) {
            this.fShowDescriptionAction = new ShowDescriptionAction(this.fCurrentPoint);
        } else {
            this.fShowDescriptionAction.setExtensionPoint(this.fCurrentPoint);
        }
        BusyIndicator.showWhile((Display)this.fDescriptionButton.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                PointSelectionPage.this.fShowDescriptionAction.run();
            }
        });
    }

    public IPluginExtension getNewExtension() {
        return this.fNewExtension;
    }

    protected void initialize() {
        this.fPointListViewer.addFilter((ViewerFilter)new PointFilter());
        this.fPointListViewer.setInput((Object)PDECore.getDefault().getModelManager());
        this.fPointListViewer.getTable().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection ssel;
        ISelection selection = event.getSelection();
        this.setDescription("");
        if (selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection) != null && !ssel.isEmpty()) {
            this.fCurrentPoint = (IPluginExtensionPoint)ssel.getFirstElement();
            if (this.fAvailableImports.contains(this.fCurrentPoint.getPluginBase().getId())) {
                this.setMessage(null);
            } else {
                this.setMessage(PDEPlugin.getResourceString("NewExtensionWizard.PointSelectionPage.message"), 1);
            }
            this.setDescription(this.fCurrentPoint.getFullId());
            this.fDescriptionButton.setEnabled(true);
        }
        this.getContainer().updateButtons();
    }

    public void setDescriptionText(String text) {
        this.fDescription.setText(text);
    }

    class PointFilter
    extends ViewerFilter {
        PointFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!PointSelectionPage.this.fFilterCheck.getSelection()) {
                return true;
            }
            IPluginExtensionPoint point = (IPluginExtensionPoint)element;
            return PointSelectionPage.this.fAvailableImports.contains(point.getPluginBase().getId());
        }
    }

    class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            HashSet<IPluginExtensionPoint> extPoints = new HashSet<IPluginExtensionPoint>();
            PluginModelManager manager = (PluginModelManager)parent;
            IPluginModelBase[] plugins = manager.getPlugins();
            int i = 0;
            while (i < plugins.length) {
                IPluginExtensionPoint[] points = plugins[i].getPluginBase().getExtensionPoints();
                int j = 0;
                while (j < points.length) {
                    extPoints.add(points[j]);
                    ++j;
                }
                ++i;
            }
            return extPoints.toArray();
        }
    }

    class PointLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        PointLabelProvider() {
        }

        public String getText(Object obj) {
            return this.getColumnText(obj, 0);
        }

        public String getColumnText(Object obj, int index) {
            PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
            if (provider.isFullNameModeEnabled()) {
                return provider.getText((IPluginExtensionPoint)obj);
            }
            return ((IPluginExtensionPoint)obj).getFullId();
        }

        public Image getImage(Object obj) {
            return this.getColumnImage(obj, 0);
        }

        public Image getColumnImage(Object obj, int index) {
            IPluginExtensionPoint exp = (IPluginExtensionPoint)obj;
            int flag = PointSelectionPage.this.fAvailableImports.contains(exp.getPluginBase().getId()) ? 0 : 2;
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXT_POINT_OBJ, flag);
        }
    }
}

