/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.ui.IExtensionWizard;
import org.eclipse.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewExtensionTemplateWizard
extends Wizard
implements IExtensionWizard {
    private ITemplateSection section;
    IProject project;
    IPluginModelBase model;

    public NewExtensionTemplateWizard(ITemplateSection section) {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWEX_WIZ);
        this.setNeedsProgressMonitor(true);
        this.section = section;
    }

    public void init(IProject project, IPluginModelBase model) {
        this.project = project;
        this.model = model;
    }

    public void setSection(ITemplateSection section) {
        this.section = section;
    }

    public ITemplateSection getSection() {
        return this.section;
    }

    public void addPages() {
        this.section.addPages(this);
        if (this.section instanceof BaseOptionTemplateSection) {
            ((BaseOptionTemplateSection)this.section).initializeFields(this.model);
        }
    }

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        NewExtensionTemplateWizard.this.doFinish(monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    protected void doFinish(IProgressMonitor monitor) throws CoreException {
        int totalWork = this.section.getNumberOfWorkUnits();
        monitor.beginTask("Generating content...", totalWork);
        this.updateDependencies();
        this.section.execute(this.project, this.model, monitor);
    }

    private void updateDependencies() throws CoreException {
        IPluginReference[] refs = this.section.getDependencies(this.model.getPluginBase().getSchemaVersion());
        int i = 0;
        while (i < refs.length) {
            IPluginReference ref = refs[i];
            if (!this.modelContains(ref)) {
                IPluginImport iimport = this.model.getPluginFactory().createImport();
                iimport.setId(ref.getId());
                iimport.setMatch(ref.getMatch());
                iimport.setVersion(ref.getVersion());
                this.model.getPluginBase().add(iimport);
            }
            ++i;
        }
    }

    private boolean modelContains(IPluginReference ref) {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginImport[] imports = plugin.getImports();
        int i = 0;
        while (i < imports.length) {
            IPluginImport iimport = imports[i];
            if (iimport.getId().equals(ref.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

