/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.Category;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionElement;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.swt.graphics.Image;

public class NewExtensionRegistryReader {
    public static final String TAG_WIZARD = "wizard";
    public static final String ATT_CATEGORY = "category";
    public static final String ATT_SHORTCUTTABLE = "availableAsShortcut";
    public static final String CATEGORY_SEPARATOR = "/";
    public static final String TAG_CATEGORY = "category";
    public static final String TAG_DESCRIPTION = "description";
    private static final String UNCATEGORIZED_WIZARD_CATEGORY = "org.eclipse.pde.ui.Other";
    private static final String UNCATEGORIZED_WIZARD_CATEGORY_LABEL = "Other";

    protected WizardCollectionElement createCollectionElement(WizardCollectionElement parent, String id, String label) {
        WizardCollectionElement newElement = new WizardCollectionElement(id, label, parent);
        if (parent != null) {
            parent.add(newElement);
        }
        return newElement;
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        String name = config.getAttribute("name");
        String id = config.getAttribute("id");
        String className = config.getAttribute("class");
        if (name == null || id == null || className == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute("icon");
        if (imageName != null) {
            IExtension extension = config.getDeclaringExtension();
            IPluginDescriptor pd = extension.getDeclaringPluginDescriptor();
            Image image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pd, imageName);
            element.setImage(image);
        }
        return element;
    }

    protected String getCategoryStringFor(IConfigurationElement config) {
        String result = config.getAttribute("category");
        if (result == null) {
            result = UNCATEGORIZED_WIZARD_CATEGORY;
        }
        return result;
    }

    protected WizardCollectionElement getChildWithID(WizardCollectionElement parent, String id) {
        Object[] children = parent.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                WizardCollectionElement currentChild = (WizardCollectionElement)children[i];
                if (currentChild.getId().equals(id)) {
                    return currentChild;
                }
                ++i;
            }
        }
        return null;
    }

    protected void insertUsingCategory(WizardElement element, ElementList result) {
        WizardCollectionElement currentResult = (WizardCollectionElement)result;
        StringTokenizer familyTokenizer = new StringTokenizer(this.getCategoryStringFor(element.getConfigurationElement()), CATEGORY_SEPARATOR);
        WizardCollectionElement currentCollectionElement = currentResult;
        boolean moveToOther = false;
        while (familyTokenizer.hasMoreElements()) {
            WizardCollectionElement tempCollectionElement = this.getChildWithID(currentCollectionElement, familyTokenizer.nextToken());
            if (tempCollectionElement == null) {
                moveToOther = true;
                break;
            }
            currentCollectionElement = tempCollectionElement;
        }
        if (moveToOther) {
            this.moveElementToUncategorizedCategory(currentResult, element);
        } else {
            currentCollectionElement.getWizards().add(element);
        }
    }

    protected void moveElementToUncategorizedCategory(WizardCollectionElement root, WizardElement element) {
        WizardCollectionElement otherCategory = this.getChildWithID(root, UNCATEGORIZED_WIZARD_CATEGORY);
        if (otherCategory == null) {
            otherCategory = this.createCollectionElement(root, UNCATEGORIZED_WIZARD_CATEGORY, UNCATEGORIZED_WIZARD_CATEGORY_LABEL);
        }
        otherCategory.getWizards().add(element);
    }

    private void processCategory(IConfigurationElement config, ElementList list) {
        WizardCollectionElement result = (WizardCollectionElement)list;
        Category category = null;
        category = new Category(config);
        if (category.getID() == null || category.getLabel() == null) {
            System.out.println("Cannot create category: id or name is missing");
            return;
        }
        String[] categoryPath = category.getParentCategoryPath();
        WizardCollectionElement parent = result;
        if (categoryPath != null) {
            int i = 0;
            while (i < categoryPath.length) {
                WizardCollectionElement tempElement = this.getChildWithID(parent, categoryPath[i]);
                if (tempElement == null) {
                    parent = null;
                    break;
                }
                parent = tempElement;
                ++i;
            }
        }
        if (parent != null) {
            this.createCollectionElement(parent, category.getID(), category.getLabel());
        }
    }

    protected void processElement(IConfigurationElement element, ElementList result, boolean shortcutsOnly) {
        String tag = element.getName();
        if (tag.equals(TAG_WIZARD)) {
            WizardElement wizard = this.createWizardElement(element);
            if (shortcutsOnly) {
                String shortcut = element.getAttribute(ATT_SHORTCUTTABLE);
                if (shortcut != null && shortcut.toLowerCase().equals("true")) {
                    result.add(wizard);
                }
            } else {
                this.insertUsingCategory(wizard, result);
            }
        } else if (tag.equals("category") && !shortcutsOnly) {
            this.processCategory(element, result);
        }
    }

    public ElementList readRegistry(String pluginId, String pluginPointId, boolean shortcutsOnly) {
        ElementList result = shortcutsOnly ? new ElementList("shortcuts") : new WizardCollectionElement("root", "root", null);
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint point = registry.getExtensionPoint(pluginId, pluginPointId);
        if (point == null) {
            return null;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement config = elements[j];
                this.processElement(config, result, shortcutsOnly);
                ++j;
            }
            ++i;
        }
        return result;
    }
}

