/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionElement;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.WizardNode;
import org.eclipse.pde.internal.ui.wizards.WizardTreeSelectionPage;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionTemplateWizard;
import org.eclipse.pde.ui.IBasePluginWizard;
import org.eclipse.pde.ui.IExtensionWizard;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewExtensionMainPage
extends WizardTreeSelectionPage {
    public static final String KEY_TITLE = "NewExtensionWizard.title";
    public static final String KEY_DESC = "NewExtensionWizard.desc";
    private IPluginModelBase model;
    private IProject project;

    public NewExtensionMainPage(IProject project, IPluginModelBase model, WizardCollectionElement wizardElements, String message) {
        super(wizardElements, "Base", message);
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.project = project;
        this.model = model;
    }

    protected IWizardNode createWizardNode(WizardElement element) {
        return new WizardNode(this, element){

            public IBasePluginWizard createWizard() throws CoreException {
                IExtensionWizard wizard = this.createWizard(this.wizardElement);
                wizard.init(NewExtensionMainPage.this.project, NewExtensionMainPage.this.model);
                return wizard;
            }

            protected IExtensionWizard createWizard(WizardElement element) throws CoreException {
                if (element.isTemplate()) {
                    ITemplateSection section = (ITemplateSection)element.createExecutableExtension();
                    return new NewExtensionTemplateWizard(section);
                }
                return (IExtensionWizard)element.createExecutableExtension();
            }
        };
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Dialog.applyDialogFont((Control)parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.pde.doc.user.add_extensions_main");
    }
}

