/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.DocumentSection;
import org.eclipse.pde.internal.core.schema.EditableSchema;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaCompositor;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.codegen.JavaCodeGenerator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public abstract class BaseExtensionPointMainPage
extends WizardPage {
    public static final String KEY_PLUGIN_ID = "BaseExtensionPoint.pluginId";
    public static final String KEY_ID = "BaseExtensionPoint.id";
    public static final String KEY_NAME = "BaseExtensionPoint.name";
    public static final String KEY_SCHEMA = "BaseExtensionPoint.schema";
    public static final String KEY_EDIT = "BaseExtensionPoint.edit";
    public static final String KEY_SHARED = "BaseExtensionPoint.shared";
    public static final String KEY_MISSING_ID = "BaseExtensionPoint.missingId";
    public static final String KEY_SECTIONS_OVERVIEW = "BaseExtensionPoint.sections.overview";
    public static final String KEY_SECTIONS_SINCE = "BaseExtensionPoint.sections.since";
    public static final String KEY_SECTIONS_USAGE = "BaseExtensionPoint.sections.usage";
    public static final String KEY_GENERATING = "BaseExtensionPoint.generating";
    public static final String KEY_SECTIONS_API = "BaseExtensionPoint.sections.api";
    public static final String KEY_SECTIONS_SUPPLIED = "BaseExtensionPoint.sections.supplied";
    public static final String KEY_SECTIONS_COPYRIGHT = "BaseExtensionPoint.sections.copyright";
    public static final String SETTINGS_PLUGIN_ID = "BaseExtensionPoint.settings.pluginId";
    private IContainer container;
    protected Text idText;
    protected Combo pluginIdText;
    protected Text nameText;
    protected Text schemaText;
    protected Button openSchemaButton;
    protected Button sharedSchemaButton;

    public BaseExtensionPointMainPage(IContainer container) {
        super("newExtensionPoint");
        this.container = container;
    }

    public void createControl(Composite parent) {
        GridData gd;
        Label label;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        if (this.isPluginIdNeeded()) {
            label = new Label(container, 0);
            label.setText(PDEPlugin.getResourceString(KEY_PLUGIN_ID));
            this.pluginIdText = new Combo(container, 2052);
            gd = new GridData(768);
            this.pluginIdText.setLayoutData((Object)gd);
            this.loadSettings();
            this.pluginIdText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BaseExtensionPointMainPage.this.validatePage();
                }
            });
        }
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_ID));
        this.idText = new Text(container, 2052);
        gd = new GridData(768);
        this.idText.setLayoutData((Object)gd);
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExtensionPointMainPage.this.validatePage();
            }
        });
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_NAME));
        this.nameText = new Text(container, 2052);
        gd = new GridData(768);
        this.nameText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_SCHEMA));
        this.schemaText = new Text(container, 2052);
        gd = new GridData(768);
        this.schemaText.setLayoutData((Object)gd);
        if (this.isSharedSchemaSwitchNeeded()) {
            this.sharedSchemaButton = new Button(container, 32);
            this.sharedSchemaButton.setText(PDEPlugin.getResourceString(KEY_SHARED));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.sharedSchemaButton.setLayoutData((Object)gd);
        }
        this.openSchemaButton = new Button(container, 32);
        this.openSchemaButton.setText(PDEPlugin.getResourceString(KEY_EDIT));
        this.openSchemaButton.setSelection(true);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.openSchemaButton.setLayoutData((Object)gd);
        this.validatePage();
        if (this.isPluginIdNeeded()) {
            this.pluginIdText.setFocus();
        } else {
            this.idText.setFocus();
        }
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.new_schema");
    }

    private InputStream createSchemaStream(String pluginId, String pointId, String name, boolean shared) {
        if (name.length() == 0) {
            name = pointId;
        }
        EditableSchema schema = new EditableSchema(pluginId, pointId, name);
        schema.setDescription(PDEPlugin.getResourceString(KEY_SECTIONS_OVERVIEW));
        DocumentSection section = new DocumentSection((ISchemaObject)schema, "since", "Since:");
        section.setDescription(PDEPlugin.getResourceString(KEY_SECTIONS_SINCE));
        schema.addDocumentSection((IDocumentSection)section);
        if (!shared) {
            SchemaElement element = new SchemaElement((ISchemaObject)schema, "extension");
            SchemaComplexType complexType = new SchemaComplexType((ISchema)schema);
            element.setType((ISchemaType)complexType);
            SchemaCompositor compositor = new SchemaCompositor((ISchemaObject)element, 2);
            complexType.setCompositor((ISchemaCompositor)compositor);
            SchemaAttribute attribute = new SchemaAttribute((ISchemaObject)element, "point");
            attribute.setType((ISchemaSimpleType)new SchemaSimpleType((ISchema)schema, "string"));
            attribute.setUse(1);
            complexType.addAttribute((ISchemaAttribute)attribute);
            attribute = new SchemaAttribute((ISchemaObject)element, "id");
            attribute.setType((ISchemaSimpleType)new SchemaSimpleType((ISchema)schema, "string"));
            complexType.addAttribute((ISchemaAttribute)attribute);
            attribute = new SchemaAttribute((ISchemaObject)element, "name");
            attribute.setType((ISchemaSimpleType)new SchemaSimpleType((ISchema)schema, "string"));
            complexType.addAttribute((ISchemaAttribute)attribute);
            schema.addElement((ISchemaElement)element);
        }
        section = new DocumentSection((ISchemaObject)schema, "examples", "Examples");
        section.setDescription(PDEPlugin.getResourceString(KEY_SECTIONS_USAGE));
        schema.addDocumentSection((IDocumentSection)section);
        section = new DocumentSection((ISchemaObject)schema, "apiInfo", "API Information");
        section.setDescription(PDEPlugin.getResourceString(KEY_SECTIONS_API));
        schema.addDocumentSection((IDocumentSection)section);
        section = new DocumentSection((ISchemaObject)schema, "implementation", "Supplied Implementation");
        section.setDescription(PDEPlugin.getResourceString(KEY_SECTIONS_SUPPLIED));
        schema.addDocumentSection((IDocumentSection)section);
        section = new DocumentSection((ISchemaObject)schema, "copyright", "Copyright");
        section.setDescription(PDEPlugin.getResourceString(KEY_SECTIONS_COPYRIGHT));
        schema.addDocumentSection((IDocumentSection)section);
        StringWriter swriter = new StringWriter();
        try {
            PrintWriter writer = new PrintWriter((Writer)swriter, true);
            schema.save(writer);
            swriter.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        try {
            return new ByteArrayInputStream(swriter.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private IFile generateSchemaFile(String pluginId, String id, String name, boolean shared, String schema, IProgressMonitor monitor) throws CoreException {
        IFile schemaFile = null;
        monitor.subTask(PDEPlugin.getResourceString(KEY_GENERATING));
        IWorkspace workspace = this.container.getWorkspace();
        IPath path = new Path(schema).removeLastSegments(1);
        if (!path.isEmpty()) {
            JavaCodeGenerator.ensureFoldersExist(this.container.getProject(), path.toString(), "/");
        }
        InputStream source = this.createSchemaStream(pluginId, id, name, shared);
        IPath filePath = this.container.getFullPath().append(schema);
        schemaFile = workspace.getRoot().getFile(filePath);
        if (!schemaFile.exists()) {
            schemaFile.create(source, true, monitor);
        } else {
            schemaFile.setContents(source, true, false, monitor);
        }
        monitor.done();
        IDE.setDefaultEditor((IFile)schemaFile, (String)"org.eclipse.pde.ui.schemaEditor");
        return schemaFile;
    }

    public IRunnableWithProgress getOperation() {
        final boolean openFile = this.openSchemaButton.getSelection();
        final String id = this.idText.getText();
        final String name = this.nameText.getText();
        final String schema = this.schemaText.getText();
        final boolean shared = this.sharedSchemaButton != null ? this.sharedSchemaButton.getSelection() : false;
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        IFile file = BaseExtensionPointMainPage.this.generateSchemaFile(BaseExtensionPointMainPage.this.getPluginId(), id, name, shared, schema, monitor);
                        if (file != null && openFile) {
                            BaseExtensionPointMainPage.this.openSchemaFile(file);
                        }
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
        return operation;
    }

    public String getPluginId() {
        if (this.pluginIdText != null) {
            return this.pluginIdText.getText();
        }
        return "";
    }

    protected void loadSettings() {
        if (this.pluginIdText != null) {
            ArrayList<String> items = new ArrayList<String>();
            IDialogSettings settings = this.getDialogSettings();
            int i = 0;
            while (i < 6) {
                String curr = settings.get(SETTINGS_PLUGIN_ID + String.valueOf(i));
                if (curr != null && !items.contains(curr)) {
                    items.add(curr);
                }
                ++i;
            }
            this.pluginIdText.setItems(items.toArray(new String[items.size()]));
        }
    }

    protected void saveSettings() {
        if (this.pluginIdText != null) {
            IDialogSettings settings = this.getDialogSettings();
            settings.put(SETTINGS_PLUGIN_ID + String.valueOf(0), this.pluginIdText.getText());
            String[] items = this.pluginIdText.getItems();
            int nEntries = Math.min(items.length, 5);
            int i = 0;
            while (i < nEntries) {
                settings.put(SETTINGS_PLUGIN_ID + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
    }

    public String getSchemaLocation() {
        return null;
    }

    protected boolean isPluginIdNeeded() {
        return false;
    }

    protected boolean isSharedSchemaSwitchNeeded() {
        return false;
    }

    private void openSchemaFile(final IFile file) {
        final IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
        Display d = ww.getShell().getDisplay();
        d.asyncExec(new Runnable(){

            public void run() {
                try {
                    String editorId = "org.eclipse.pde.ui.schemaEditor";
                    ww.getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorId);
                }
                catch (PartInitException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
    }

    private void validatePage() {
        boolean empty;
        if (!this.validateContainer()) {
            return;
        }
        String id = this.idText.getText();
        boolean bl = empty = id.length() == 0;
        if (!empty && this.pluginIdText != null) {
            empty = this.pluginIdText.getText().length() == 0;
        }
        this.setPageComplete(!empty);
        String message = null;
        if (empty) {
            message = PDEPlugin.getResourceString(KEY_MISSING_ID);
        }
        this.setMessage(message, 2);
        String location = this.getSchemaLocation();
        String prefix = location != null ? String.valueOf(location) + "/" : "";
        String schema = !empty ? String.valueOf(prefix) + id + ".exsd" : "";
        this.schemaText.setText(schema);
    }

    private boolean validateContainer() {
        boolean exists;
        boolean bl = exists = this.container != null && this.container.exists();
        if (!exists) {
            this.setErrorMessage(PDEPlugin.getResourceString("BaseExtensionPointMainPage.noContainer"));
            this.setPageComplete(false);
        }
        return exists;
    }
}

