/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class PluginExportWizardPage
extends BaseExportWizardPage {
    private static String S_SELECTED_PLUGINS = "selectedPlugins";

    public PluginExportWizardPage(IStructuredSelection selection) {
        super(selection, "pluginExport", PDEPlugin.getResourceString("ExportWizard.Plugin.pageBlock"), false);
        this.setTitle(PDEPlugin.getResourceString("ExportWizard.Plugin.pageTitle"));
    }

    public Object[] getListElements() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IModel> result = new ArrayList<IModel>();
        IWorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        int i = 0;
        while (i < projects.length) {
            IModel model;
            if (!WorkspaceModelManager.isBinaryPluginProject((IProject)projects[i]) && WorkspaceModelManager.isPluginProject((IProject)projects[i]) && (model = manager.getWorkspaceModel(projects[i])) != null && this.hasBuildProperties((WorkspacePluginModelBase)model)) {
                result.add(model);
            }
            ++i;
        }
        return result.toArray(new IModel[result.size()]);
    }

    protected void hookHelpContext(Control control) {
        WorkbenchHelp.setHelp((Control)control, (String)"org.eclipse.pde.doc.user.plugin_export_wizard");
    }

    private boolean hasBuildProperties(WorkspacePluginModelBase model) {
        File file = new File(model.getInstallLocation(), "build.properties");
        return file.exists();
    }

    protected void checkSelected() {
        IDialogSettings settings = this.getDialogSettings();
        String selectedPlugins = settings.get(S_SELECTED_PLUGINS);
        if (selectedPlugins == null) {
            super.checkSelected();
        } else {
            ArrayList<IPluginModelBase> selected = new ArrayList<IPluginModelBase>();
            StringTokenizer tokenizer = new StringTokenizer(selectedPlugins, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                IPluginModelBase model = PDECore.getDefault().getModelManager().findPlugin(token, null, 0);
                if (model == null || !(model instanceof WorkspacePluginModelBase)) continue;
                selected.add(model);
            }
            this.exportPart.setSelection(selected.toArray());
        }
    }

    public void saveSettings() {
        super.saveSettings();
        Object[] selected = this.exportPart.getSelection();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < selected.length) {
            IPluginModelBase model = (IPluginModelBase)selected[i];
            buffer.append(model.getPluginBase().getId());
            if (i < selected.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        if (buffer.length() > 0) {
            this.getDialogSettings().put(S_SELECTED_PLUGINS, buffer.toString());
        }
    }

    protected boolean isValidModel(IModel model) {
        return model instanceof IPluginModelBase;
    }
}

