/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.builder.FragmentBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.PluginBuildScriptGenerator;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportJob;

public class PluginExportJob
extends BaseExportJob {
    public PluginExportJob(int exportType, boolean exportSource, String destination, String zipFileName, Object[] items) {
        super(exportType, exportSource, destination, zipFileName, items);
    }

    protected HashMap createProperties(String destination, IPluginBase model, int exportType) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        String location = String.valueOf(this.buildTempLocation) + "/build_result/" + model.getId();
        File dir = new File(location);
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        map.put("build.result.folder", location);
        map.put("temp.folder", String.valueOf(this.buildTempLocation) + "/temp.folder/" + model.getId());
        if (exportType != 3) {
            map.put("destination.temp.folder", String.valueOf(this.buildTempLocation) + "/destination/plugins");
        } else {
            map.put("destination.temp.folder", String.valueOf(this.buildTempLocation) + "/temp.folder/" + model.getId());
        }
        map.put("plugin.destination", destination);
        map.put("baseos", TargetPlatform.getOS());
        map.put("basews", TargetPlatform.getWS());
        map.put("basearch", TargetPlatform.getOSArch());
        map.put("basenl", TargetPlatform.getNL());
        map.put("eclipse.running", "true");
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        map.put("javacFailOnError", "false");
        map.put("javacDebugInfo", store.getBoolean("javacDebugInfo") ? "on" : "off");
        map.put("javacVerbose", store.getString("javacVerbose"));
        map.put("javacSource", store.getString("javacSource"));
        map.put("javacTarget", store.getString("javacTarget"));
        return map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExport(IModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        IPluginModelBase modelBase = (IPluginModelBase)model;
        try {
            String label = PDEPlugin.getDefault().getLabelProvider().getObjectText(modelBase.getPluginBase());
            monitor.setTaskName(String.valueOf(PDEPlugin.getResourceString("ExportJob.exporting")) + " " + label);
            monitor.beginTask("", 10);
            this.makeScript(modelBase);
            monitor.worked(1);
            this.runScript(modelBase.getInstallLocation(), this.destination, this.exportType, this.exportSource, this.createProperties(this.destination, modelBase.getPluginBase(), this.exportType), (IProgressMonitor)new SubProgressMonitor(monitor, 9));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteBuildFile(modelBase);
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteBuildFile(modelBase);
        monitor.done();
    }

    public void deleteBuildFile(IPluginModelBase model) throws CoreException {
        if (this.isCustomBuild((IModel)model)) {
            return;
        }
        File file = new File(model.getInstallLocation(), "build.xml");
        if (file.exists()) {
            file.delete();
        }
    }

    private void makeScript(IPluginModelBase model) throws CoreException {
        Object generator = null;
        generator = model.isFragmentModel() ? new FragmentBuildScriptGenerator() : new PluginBuildScriptGenerator();
        generator.setWorkingDirectory(model.getInstallLocation());
        IProject project = model.getUnderlyingResource().getProject();
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IPath path = JavaCore.create((IProject)project).getOutputLocation().removeFirstSegments(1);
            generator.setDevEntries(new String[]{path.toOSString()});
        } else {
            generator.setDevEntries(new String[]{"bin"});
        }
        generator.setPluginPath(TargetPlatform.createPluginPath());
        generator.setModelId(model.getPluginBase().getId());
        generator.generate();
    }
}

