/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class FeatureExportWizardPage
extends BaseExportWizardPage {
    private static String S_SELECTED_FEATURES = "selectedFeatures";

    public FeatureExportWizardPage(IStructuredSelection selection) {
        super(selection, "featureExport", PDEPlugin.getResourceString("ExportWizard.Feature.pageBlock"), true);
        this.setTitle(PDEPlugin.getResourceString("ExportWizard.Feature.pageTitle"));
    }

    public Object[] getListElements() {
        IWorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        return manager.getFeatureModels();
    }

    protected void hookHelpContext(Control control) {
        WorkbenchHelp.setHelp((Control)control, (String)"org.eclipse.pde.doc.user.feature_export_wizard");
    }

    protected void checkSelected() {
        IDialogSettings settings = this.getDialogSettings();
        String selectedPlugins = settings.get(S_SELECTED_FEATURES);
        if (selectedPlugins == null) {
            super.checkSelected();
        } else {
            ArrayList<String> tokens = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(selectedPlugins, ",");
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            ArrayList<IFeatureModel> selected = new ArrayList<IFeatureModel>();
            IFeatureModel[] models = PDECore.getDefault().getWorkspaceModelManager().getFeatureModels();
            int i = 0;
            while (i < models.length) {
                if (tokens.contains(models[i].getFeature().getId())) {
                    selected.add(models[i]);
                }
                ++i;
            }
            this.exportPart.setSelection(selected.toArray());
        }
    }

    public void saveSettings() {
        super.saveSettings();
        Object[] selected = this.exportPart.getSelection();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < selected.length) {
            IFeatureModel model = (IFeatureModel)selected[i];
            buffer.append(model.getFeature().getId());
            if (i < selected.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        if (buffer.length() > 0) {
            this.getDialogSettings().put(S_SELECTED_FEATURES, buffer.toString());
        }
    }

    protected boolean isValidModel(IModel model) {
        return model instanceof IFeatureModel;
    }
}

