/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportJob;
import org.eclipse.pde.internal.ui.wizards.exports.ExportFeatureBuildScriptGenerator;

public class FeatureExportJob
extends BaseExportJob {
    public FeatureExportJob(int exportType, boolean exportSource, String destination, String zipFileName, Object[] items) {
        super(exportType, exportSource, destination, zipFileName, items);
    }

    protected HashMap createProperties(String destination, int exportType) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("feature.temp.folder", String.valueOf(this.buildTempLocation) + "/destination");
        if (exportType != 3) {
            map.put("plugin.destination", destination);
            map.put("feature.destination", destination);
        } else {
            String dest = destination;
            File file = new File(destination, "plugins");
            file.mkdirs();
            if (file.exists()) {
                dest = file.getAbsolutePath();
            }
            map.put("plugin.destination", dest);
            dest = destination;
            file = new File(destination, "features");
            file.mkdirs();
            if (file.exists()) {
                dest = file.getAbsolutePath();
            }
            map.put("feature.destination", dest);
        }
        map.put("baseos", TargetPlatform.getOS());
        map.put("basews", TargetPlatform.getWS());
        map.put("basearch", TargetPlatform.getOSArch());
        map.put("basenl", TargetPlatform.getNL());
        map.put("eclipse.running", "true");
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        map.put("javacFailOnError", "false");
        map.put("javacDebugInfo", store.getBoolean("javacDebugInfo") ? "on" : "off");
        map.put("javacVerbose", store.getString("javacVerbose"));
        map.put("javacSource", store.getString("javacSource"));
        map.put("javacTarget", store.getString("javacTarget"));
        return map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExport(IModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        IFeatureModel feature = (IFeatureModel)model;
        String label = PDEPlugin.getDefault().getLabelProvider().getObjectText(feature);
        monitor.beginTask("", 10);
        monitor.setTaskName(String.valueOf(PDEPlugin.getResourceString("ExportJob.exporting")) + " " + label);
        try {
            this.makeScript(feature);
            monitor.worked(1);
            this.runScript(feature.getInstallLocation(), this.destination, this.exportType, this.exportSource, this.createProperties(this.destination, this.exportType), (IProgressMonitor)new SubProgressMonitor(monitor, 9));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteBuildFiles(feature);
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteBuildFiles(feature);
        monitor.done();
    }

    private void deleteBuildFiles(IFeatureModel model) throws CoreException {
        this.deleteBuildFile((IModel)model);
        IFeaturePlugin[] plugins = model.getFeature().getPlugins();
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        int i = 0;
        while (i < plugins.length) {
            ModelEntry entry = manager.findEntry(plugins[i].getId(), plugins[i].getVersion());
            if (entry != null) {
                this.deleteBuildFile((IModel)entry.getActiveModel());
            }
            ++i;
        }
    }

    public void deleteBuildFile(IModel model) throws CoreException {
        if (this.isCustomBuild(model)) {
            return;
        }
        String directory = model instanceof IFeatureModel ? ((IFeatureModel)model).getInstallLocation() : ((IPluginModelBase)model).getInstallLocation();
        File file = new File(directory, "build.xml");
        if (file.exists()) {
            file.delete();
        }
    }

    private void makeScript(IFeatureModel model) throws CoreException {
        ExportFeatureBuildScriptGenerator generator = new ExportFeatureBuildScriptGenerator();
        generator.setFeatureRootLocation(model.getInstallLocation());
        generator.setWorkingDirectory(model.getInstallLocation());
        IProject project = model.getUnderlyingResource().getProject();
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IPath path = JavaCore.create((IProject)project).getOutputLocation().removeFirstSegments(1);
            generator.setDevEntries(new String[]{path.toOSString()});
        } else {
            generator.setDevEntries(new String[]{"bin"});
        }
        generator.setAnalyseChildren(true);
        generator.setPluginPath(this.getPaths());
        this.setConfigInfo(model.getFeature());
        generator.setFeature(model.getFeature().getId());
        generator.generate();
    }

    private void setConfigInfo(IFeature feature) throws CoreException {
        String os = feature.getOS() == null ? "*" : feature.getOS();
        String ws = feature.getWS() == null ? "*" : feature.getWS();
        String arch = feature.getArch() == null ? "*" : feature.getArch();
        FeatureBuildScriptGenerator.setConfigInfo((String)(String.valueOf(os) + "," + ws + "," + arch));
    }

    private URL[] getPaths() throws CoreException {
        ArrayList<URL> paths = new ArrayList<URL>();
        IFeatureModel[] models = PDECore.getDefault().getWorkspaceModelManager().getFeatureModels();
        int i = 0;
        while (i < models.length) {
            try {
                paths.add(new URL("file:" + models[i].getInstallLocation() + '/' + "feature.xml"));
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        URL[] plugins = TargetPlatform.createPluginPath();
        URL[] features = paths.toArray(new URL[paths.size()]);
        URL[] all = new URL[plugins.length + paths.size()];
        System.arraycopy(plugins, 0, all, 0, plugins.length);
        System.arraycopy(features, 0, all, plugins.length, features.length);
        return all;
    }

    protected String[] getExecutionTargets(int exportType, boolean exportSource) {
        ArrayList<String> targets = new ArrayList<String>();
        if (exportType == 3) {
            targets.add("build.update.jar");
        } else {
            targets.add("build.jars");
            targets.add("zip.distribution");
            if (exportSource) {
                targets.add("build.sources");
                targets.add("zip.sources");
            }
        }
        return targets.toArray(new String[targets.size()]);
    }
}

