/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IPlatformEnvironment;
import org.eclipse.update.core.IPluginEntry;

public class ExportFeatureBuildScriptGenerator
extends FeatureBuildScriptGenerator {
    protected void generateZipDistributionWholeTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.distribution", "init", null, null, Policy.bind((String)"build.feature.zips", (String)this.featureIdentifier));
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("feature.base", this.featureTempFolder);
        params.put("include.children", "true");
        params.put("os", this.feature.getOS() == null ? Config.ANY : this.feature.getOS());
        params.put("ws", this.feature.getWS() == null ? Config.ANY : this.feature.getWS());
        params.put("arch", this.feature.getOSArch() == null ? Config.ANY : this.feature.getOSArch());
        params.put("nl", this.feature.getNL() == null ? Config.ANY : this.feature.getNL());
        this.script.printAntCallTask("gather.bin.parts", null, params);
        this.script.printTargetEnd();
    }

    protected void generateZipSourcesTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.sources", "init", null, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "gather.sources");
        params.put("destination.temp.folder", String.valueOf(this.featureTempFolder) + "/plugins");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printTargetEnd();
    }

    protected void generateAllPluginsTarget() throws CoreException {
        List plugins = this.computeElements(false);
        List fragments = this.computeElements(true);
        String[] sortedPlugins = Utils.computePrerequisiteOrder((PluginModel[])plugins.toArray(new PluginModel[plugins.size()]), (PluginModel[])fragments.toArray(new PluginModel[fragments.size()]), (boolean)AbstractScriptGenerator.isBuildingOSGi());
        this.script.println();
        this.script.printTargetDeclaration("all.plugins", "init", null, null, null);
        HashSet<String> writtenCalls = new HashSet<String>(plugins.size() + fragments.size());
        int i = 0;
        while (i < sortedPlugins.length) {
            PluginDescriptorModel plugin = this.getSite(false).getPluginRegistry().getPlugin(sortedPlugins[i]);
            if (plugin == null) {
                plugin = this.getSite(false).getPluginRegistry().getFragment(sortedPlugins[i]);
            }
            if (!writtenCalls.contains(sortedPlugins[i])) {
                writtenCalls.add(sortedPlugins[i]);
                IPluginEntry[] entries = Utils.getPluginEntry((IFeature)this.feature, (String)sortedPlugins[i]);
                int j = 0;
                while (j < entries.length) {
                    List list = this.selectConfigs((IPlatformEnvironment)entries[j]);
                    if (list.size() != 0) {
                        String loc;
                        File dir;
                        HashMap<String, String> params = null;
                        Config aMatchingConfig = (Config)list.get(0);
                        params = new HashMap<String, String>(3);
                        if (!aMatchingConfig.getOs().equals(Config.ANY)) {
                            params.put("os", aMatchingConfig.getOs());
                        }
                        if (!aMatchingConfig.getWs().equals(Config.ANY)) {
                            params.put("ws", aMatchingConfig.getWs());
                        }
                        if (!aMatchingConfig.getArch().equals(Config.ANY)) {
                            params.put("arch", aMatchingConfig.getArch());
                        }
                        if (!(dir = new File(loc = PDEPlugin.getDefault().getStateLocation() + "/temp/build_result/" + plugin.getId())).exists() || !dir.isDirectory()) {
                            dir.mkdirs();
                        }
                        params.put("build.result.folder", loc);
                        params.put("temp.folder", PDEPlugin.getDefault().getStateLocation() + "/temp/temp.folder/" + plugin.getId());
                        IPath location = Utils.makeRelative((IPath)new Path(this.getLocation((PluginModel)plugin)), (IPath)new Path(this.featureRootLocation));
                        this.script.printAntTask("build.xml", location.toString(), this.getPropertyFormat("target"), null, null, params);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.script.printTargetEnd();
    }
}

