/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.exports.BuildOptionsPreferenceNode;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public abstract class BaseExportWizardPage
extends WizardPage {
    private String S_EXPORT_UPDATE = "exportUpdate";
    private String S_EXPORT_DIRECTORY = "exportDirectory";
    private String S_DESTINATION = "destination";
    private String S_EXPORT_SOURCE = "exportSource";
    private String S_ZIP_FILENAME = "zipFileName";
    private IStructuredSelection selection;
    protected ExportPart exportPart;
    protected boolean featureExport;
    private Button directoryRadio;
    private Button zipRadio;
    private Button updateRadio;
    private Label directoryLabel;
    private Combo destination;
    private Button browseDirectory;
    private Label fileLabel;
    private Combo zipFile;
    private Button browseFile;
    private Button includeSource;

    public BaseExportWizardPage(IStructuredSelection selection, String name, String choiceLabel, boolean featureExport) {
        super(name);
        this.selection = selection;
        this.featureExport = featureExport;
        String[] stringArray = new String[4];
        stringArray[0] = PDEPlugin.getResourceString("WizardCheckboxTablePart.selectAll");
        stringArray[1] = PDEPlugin.getResourceString("WizardCheckboxTablePart.deselectAll");
        stringArray[3] = PDEPlugin.getResourceString("ExportWizard.workingSet");
        this.exportPart = new ExportPart(choiceLabel, stringArray);
        this.setDescription(PDEPlugin.getResourceString("ExportWizard.Plugin.description"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.createTableViewerSection(container);
        this.createExportTypeSection(container);
        this.createOptionsSection(container);
        this.createExportDestinationSection(container);
        Dialog.applyDialogFont((Control)container);
        this.initializeList();
        this.loadSettings();
        this.pageChanged();
        this.hookListeners();
        this.setControl((Control)container);
        this.hookHelpContext((Control)container);
    }

    private void createTableViewerSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.exportPart.createControl(composite);
        GridData gd = (GridData)this.exportPart.getControl().getLayoutData();
        gd.heightHint = 100;
        gd.widthHint = 150;
        gd.horizontalSpan = 2;
    }

    private void createExportTypeSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEPlugin.getResourceString(this.featureExport ? "ExportWizard.Feature.label" : "ExportWizard.Plugin.label"));
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.zipRadio = new Button((Composite)group, 16);
        this.zipRadio.setText(PDEPlugin.getResourceString("ExportWizard.zip"));
        this.directoryRadio = new Button((Composite)group, 16);
        this.directoryRadio.setText(PDEPlugin.getResourceString("ExportWizard.directory"));
        this.updateRadio = new Button((Composite)group, 16);
        this.updateRadio.setText(PDEPlugin.getResourceString("ExportWizard.updateJars"));
    }

    private void createExportDestinationSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEPlugin.getResourceString("ExportWizard.destination.group"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.fileLabel = new Label((Composite)group, 0);
        this.fileLabel.setText(PDEPlugin.getResourceString("ExportWizard.zipFile"));
        this.zipFile = new Combo((Composite)group, 2048);
        this.zipFile.setLayoutData((Object)new GridData(768));
        this.browseFile = new Button((Composite)group, 8);
        this.browseFile.setText(PDEPlugin.getResourceString("ExportWizard.browse"));
        this.browseFile.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.browseFile);
        this.directoryLabel = new Label((Composite)group, 0);
        this.directoryLabel.setText(PDEPlugin.getResourceString("ExportWizard.destination"));
        this.destination = new Combo((Composite)group, 2048);
        this.destination.setLayoutData((Object)new GridData(768));
        this.browseDirectory = new Button((Composite)group, 8);
        this.browseDirectory.setText(PDEPlugin.getResourceString("ExportWizard.browse"));
        this.browseDirectory.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.browseDirectory);
    }

    private void createOptionsSection(Composite parent) {
        Group comp = new Group(parent, 0);
        comp.setText(PDEPlugin.getResourceString("ExportWizard.options"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.includeSource = new Button((Composite)comp, 32);
        this.includeSource.setText(PDEPlugin.getResourceString("ExportWizard.includeSource"));
        this.includeSource.setLayoutData((Object)new GridData(768));
        Button button = new Button((Composite)comp, 8);
        button.setText(PDEPlugin.getResourceString("ExportWizard.buildOptions.button"));
        button.setLayoutData((Object)new GridData(128));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.showPreferencePage(new BuildOptionsPreferenceNode());
            }
        });
        SWTUtil.setButtonDimensionHint(button);
    }

    private void showPreferencePage(final IPreferenceNode targetNode) {
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot(targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                dialog.create();
                dialog.setMessage(targetNode.getLabelText());
                dialog.open();
            }
        });
    }

    private void hookListeners() {
        this.browseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.doBrowseFile();
            }
        });
        this.zipFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.zipFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.destination.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.destination.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.browseDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseExportWizardPage.this.doBrowseDirectory();
            }
        });
        this.updateRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = BaseExportWizardPage.this.updateRadio.getSelection();
                BaseExportWizardPage.this.enableZipOption(!enabled);
                BaseExportWizardPage.this.enableDirectoryOption(enabled);
                if (BaseExportWizardPage.this.includeSource.getEnabled() == enabled) {
                    BaseExportWizardPage.this.includeSource.setEnabled(!enabled);
                }
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.directoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = BaseExportWizardPage.this.directoryRadio.getSelection();
                BaseExportWizardPage.this.enableZipOption(!enabled);
                BaseExportWizardPage.this.enableDirectoryOption(enabled);
                if (BaseExportWizardPage.this.includeSource.getEnabled() != enabled) {
                    BaseExportWizardPage.this.includeSource.setEnabled(enabled);
                }
                BaseExportWizardPage.this.pageChanged();
            }
        });
        this.zipRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = BaseExportWizardPage.this.zipRadio.getSelection();
                BaseExportWizardPage.this.enableZipOption(enabled);
                BaseExportWizardPage.this.enableDirectoryOption(!enabled);
                if (BaseExportWizardPage.this.includeSource.getEnabled() != enabled) {
                    BaseExportWizardPage.this.includeSource.setEnabled(enabled);
                }
                BaseExportWizardPage.this.pageChanged();
            }
        });
    }

    private void doBrowseFile() {
        IPath path = this.chooseFile();
        if (path != null) {
            this.zipFile.setText(path.toOSString());
        }
    }

    private IPath chooseFile() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFileName(this.zipFile.getText());
        dialog.setFilterExtensions(new String[]{"*.zip"});
        dialog.setText(PDEPlugin.getResourceString("ExportWizard.filedialog.title"));
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    private void enableZipOption(boolean enabled) {
        if (this.fileLabel.getEnabled() != enabled) {
            this.fileLabel.setEnabled(enabled);
            this.zipFile.setEnabled(enabled);
            this.browseFile.setEnabled(enabled);
        }
    }

    private void enableDirectoryOption(boolean enabled) {
        if (this.directoryLabel.getEnabled() != enabled) {
            this.directoryLabel.setEnabled(enabled);
            this.destination.setEnabled(enabled);
            this.browseDirectory.setEnabled(enabled);
        }
    }

    protected abstract Object[] getListElements();

    private void initializeList() {
        CheckboxTableViewer viewer = this.exportPart.getTableViewer();
        viewer.setContentProvider((IContentProvider)new ExportListProvider());
        viewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        viewer.setSorter(ListUtil.PLUGIN_SORTER);
        this.exportPart.getTableViewer().setInput((Object)PDECore.getDefault().getWorkspaceModelManager());
        this.checkSelected();
    }

    private void doBrowseDirectory() {
        IPath result = this.chooseDestination();
        if (result != null) {
            this.destination.setText(result.toOSString());
        }
    }

    private IPath chooseDestination() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.destination.getText());
        dialog.setText(PDEPlugin.getResourceString("ExportWizard.dialog.title"));
        dialog.setMessage(PDEPlugin.getResourceString("ExportWizard.dialog.message"));
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    protected void checkSelected() {
        Object[] elems = this.selection.toArray();
        ArrayList<IModel> checked = new ArrayList<IModel>(elems.length);
        int i = 0;
        while (i < elems.length) {
            IModel model;
            Object elem = elems[i];
            IProject project = null;
            if (elem instanceof IFile) {
                IFile file = (IFile)elem;
                project = file.getProject();
            } else if (elem instanceof IProject) {
                project = (IProject)elem;
            } else if (elem instanceof IJavaProject) {
                project = ((IJavaProject)elem).getProject();
            }
            if (project != null && (model = this.findModelFor(project)) != null && !checked.contains(model)) {
                checked.add(model);
            }
            ++i;
        }
        this.exportPart.setSelection(checked.toArray());
    }

    private IModel findModelFor(IProject project) {
        IWorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        return manager.getWorkspaceModel(project);
    }

    private void pageChanged() {
        boolean hasSel;
        boolean hasDestination = false;
        String message = null;
        if (this.zipRadio != null && !this.zipRadio.isDisposed() && this.zipRadio.getSelection()) {
            boolean bl = hasDestination = this.zipFile.getText().length() > 0;
            if (!hasDestination) {
                message = PDEPlugin.getResourceString("ExportWizard.status.nofile");
            }
        } else if (this.destination != null && !this.destination.isDisposed()) {
            boolean bl = hasDestination = this.destination.getText().length() > 0;
            if (!hasDestination) {
                message = PDEPlugin.getResourceString("ExportWizard.status.nodirectory");
            }
        }
        boolean bl = hasSel = this.exportPart.getSelectionCount() > 0;
        if (!hasSel) {
            message = PDEPlugin.getResourceString("ExportWizard.status.noselection");
        }
        this.setMessage(message);
        this.setPageComplete(hasSel && hasDestination);
    }

    private void loadSettings() {
        String curr;
        IDialogSettings settings = this.getDialogSettings();
        boolean exportUpdate = settings.getBoolean(this.S_EXPORT_UPDATE);
        boolean exportDirectory = settings.getBoolean(this.S_EXPORT_DIRECTORY);
        this.zipRadio.setSelection(!exportUpdate && !exportDirectory);
        this.updateRadio.setSelection(exportUpdate);
        this.directoryRadio.setSelection(exportDirectory);
        this.enableZipOption(!exportUpdate && !exportDirectory);
        this.enableDirectoryOption(!this.zipRadio.getSelection());
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < 6) {
            curr = settings.get(String.valueOf(this.S_DESTINATION) + String.valueOf(i));
            if (curr != null && !items.contains(curr)) {
                items.add(curr);
            }
            ++i;
        }
        this.destination.setItems(items.toArray(new String[items.size()]));
        if (items.size() > 0) {
            this.destination.setText(items.get(0).toString());
        }
        items.clear();
        i = 0;
        while (i < 6) {
            curr = settings.get(String.valueOf(this.S_ZIP_FILENAME) + String.valueOf(i));
            if (curr != null && !items.contains(curr)) {
                items.add(curr);
            }
            ++i;
        }
        this.zipFile.setItems(items.toArray(new String[items.size()]));
        if (items.size() > 0) {
            this.zipFile.setText(items.get(0).toString());
        }
        this.includeSource.setSelection(settings.getBoolean(this.S_EXPORT_SOURCE));
        this.includeSource.setEnabled(!this.updateRadio.getSelection());
    }

    public void saveSettings() {
        int i;
        int nEntries;
        String[] items;
        IDialogSettings settings = this.getDialogSettings();
        settings.put(this.S_EXPORT_UPDATE, this.updateRadio.getSelection());
        settings.put(this.S_EXPORT_DIRECTORY, this.directoryRadio.getSelection());
        settings.put(this.S_EXPORT_SOURCE, this.includeSource.getSelection());
        if (this.destination.getText().length() > 0) {
            settings.put(String.valueOf(this.S_DESTINATION) + String.valueOf(0), this.destination.getText());
            items = this.destination.getItems();
            nEntries = Math.min(items.length, 5);
            i = 0;
            while (i < nEntries) {
                settings.put(String.valueOf(this.S_DESTINATION) + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
        if (this.zipFile.getText().length() > 0) {
            settings.put(String.valueOf(this.S_ZIP_FILENAME) + String.valueOf(0), this.zipFile.getText());
            items = this.zipFile.getItems();
            nEntries = Math.min(items.length, 5);
            i = 0;
            while (i < nEntries) {
                settings.put(String.valueOf(this.S_ZIP_FILENAME) + String.valueOf(i + 1), items[i]);
                ++i;
            }
        }
    }

    public Object[] getSelectedItems() {
        return this.exportPart.getSelection();
    }

    public boolean getExportZip() {
        return this.zipRadio.getSelection();
    }

    public boolean getExportSource() {
        if (this.includeSource == null) {
            return false;
        }
        return this.includeSource.getSelection();
    }

    public String getFileName() {
        String path;
        if (this.zipRadio.getSelection() && (path = this.zipFile.getText()) != null && path.length() > 0) {
            String fileName = new Path(path).lastSegment();
            if (!fileName.endsWith(".zip")) {
                fileName = String.valueOf(fileName) + ".zip";
            }
            return fileName;
        }
        return null;
    }

    public String getDestination() {
        if (this.zipRadio != null && this.zipRadio.getSelection()) {
            String path = this.zipFile.getText();
            if (path != null && path.length() > 0) {
                return new Path(path).removeLastSegments(1).toOSString();
            }
            return "";
        }
        if (this.destination == null || this.destination.isDisposed()) {
            return "";
        }
        return this.destination.getText();
    }

    public int getExportType() {
        if (this.directoryRadio.getSelection()) {
            return 1;
        }
        if (this.zipRadio.getSelection()) {
            return 2;
        }
        return 3;
    }

    protected abstract void hookHelpContext(Control var1);

    private void handleWorkingSets() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(this.getShell(), true);
        if (dialog.open() == 0) {
            ArrayList<IModel> models = new ArrayList<IModel>();
            IWorkspaceModelManager wManager = PDECore.getDefault().getWorkspaceModelManager();
            IWorkingSet[] workingSets = dialog.getSelection();
            int i = 0;
            while (i < workingSets.length) {
                IAdaptable[] elements = workingSets[i].getElements();
                int j = 0;
                while (j < elements.length) {
                    IModel model;
                    IAdaptable element = elements[j];
                    if (element instanceof IJavaProject) {
                        element = ((IJavaProject)element).getProject();
                    }
                    if (element instanceof IProject && this.isValidModel(model = wManager.getWorkspaceModel((IProject)element))) {
                        models.add(model);
                    }
                    ++j;
                }
                ++i;
            }
            this.exportPart.setSelection(models.toArray());
        }
    }

    protected abstract boolean isValidModel(IModel var1);

    class ExportListProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ExportListProvider() {
        }

        public Object[] getElements(Object parent) {
            return BaseExportWizardPage.this.getListElements();
        }
    }

    class ExportPart
    extends WizardCheckboxTablePart {
        public ExportPart(String label, String[] buttonLabels) {
            super(label, buttonLabels);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            BaseExportWizardPage.this.pageChanged();
        }

        protected void buttonSelected(Button button, int index) {
            switch (index) {
                case 0: {
                    this.handleSelectAll(true);
                    break;
                }
                case 1: {
                    this.handleSelectAll(false);
                    break;
                }
                case 3: {
                    BaseExportWizardPage.this.handleWorkingSets();
                }
            }
        }
    }
}

