/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class BaseExportJob
extends Job
implements IPreferenceConstants {
    public static final int EXPORT_AS_DIRECTORY = 1;
    public static final int EXPORT_AS_ZIP = 2;
    public static final int EXPORT_AS_UPDATE_JARS = 3;
    private static final ISchedulingRule nonConcurentPDEExportRule = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this == rule;
        }
    };
    private static final IStatus OK_STATUS = new Status(0, PDEPlugin.getPluginId(), 0, "", null);
    protected static PrintWriter writer;
    protected static File logFile;
    protected int exportType;
    protected boolean exportSource;
    protected String destination;
    protected String zipFileName;
    protected Object[] items;
    protected String buildTempLocation;

    public BaseExportJob(int exportType, boolean exportSource, String destination, String zipFileName, Object[] items) {
        super(PDEPlugin.getResourceString("ExportJob.jobTitle"));
        this.exportType = exportType;
        this.exportSource = exportSource;
        this.destination = destination;
        this.zipFileName = zipFileName;
        this.items = items;
        this.setSchedulingRules();
        this.buildTempLocation = PDEPlugin.getDefault().getStateLocation().append("temp").toOSString();
    }

    private void setSchedulingRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(nonConcurentPDEExportRule);
        int i = 0;
        while (i < this.items.length) {
            IModel model = (IModel)this.items[i];
            IResource resource = model.getUnderlyingResource();
            if (resource != null) {
                rules.add(resource);
            }
            ++i;
        }
        ISchedulingRule[] rulesArray = rules.toArray(new ISchedulingRule[rules.size()]);
        this.setRule((ISchedulingRule)new MultiRule(rulesArray));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        String errorMessage;
        block12: {
            File zipFile;
            if (this.zipFileName != null && (zipFile = new File(this.destination, this.zipFileName)).exists()) {
                zipFile.delete();
            }
            errorMessage = null;
            try {
                try {
                    BaseExportJob.createLogWriter();
                    try {
                        this.doExports(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (InvocationTargetException e) {
                    String message = e.getTargetException().getMessage();
                    if (message != null && message.length() > 0) {
                        errorMessage = e.getTargetException().getMessage();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
            {
                Object var5_9 = null;
                if (writer != null) {
                    writer.close();
                }
                if (errorMessage != null || logFile == null || !logFile.exists() || logFile.length() <= 0L) break block12;
            }
            errorMessage = PDEPlugin.getFormattedMessage("ExportJob.error.message", this.destination);
        }
        if (errorMessage != null) {
            final String em = errorMessage;
            BaseExportJob.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    BaseExportJob.this.asyncNotifyExportException(em);
                }
            });
            return Job.ASYNC_FINISH;
        }
        return OK_STATUS;
    }

    protected void doExports(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        this.createDestination(this.destination);
        monitor.beginTask("", this.items.length + 1);
        int i = 0;
        while (i < this.items.length) {
            IModel model = (IModel)this.items[i];
            this.doExport(model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i;
        }
        this.cleanup(this.zipFileName, this.destination, this.exportType, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    protected abstract void doExport(IModel var1, IProgressMonitor var2) throws CoreException, InvocationTargetException;

    private static void createLogWriter() {
        try {
            String path = PDEPlugin.getDefault().getStateLocation().toOSString();
            logFile = new File(path, "exportLog.txt");
            if (logFile.exists()) {
                logFile.delete();
                logFile.createNewFile();
            }
            writer = new PrintWriter((Writer)new FileWriter(logFile), true);
        }
        catch (IOException iOException) {}
    }

    public static PrintWriter getWriter() {
        if (writer == null) {
            BaseExportJob.createLogWriter();
        }
        return writer;
    }

    private void createDestination(String destination) throws InvocationTargetException {
        File file = new File(destination);
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            throw new InvocationTargetException(new Exception(PDEPlugin.getResourceString("ExportWizard.badDirectory")));
        }
    }

    protected void runScript(String location, String destination, int exportType, boolean exportSource, Map properties, IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        AntRunner runner = new AntRunner();
        runner.addUserProperties(properties);
        runner.setAntHome(location);
        runner.setBuildFileLocation(String.valueOf(location) + '/' + "build.xml");
        runner.addBuildListener("org.eclipse.pde.internal.ui.ant.ExportBuildListener");
        runner.setExecutionTargets(this.getExecutionTargets(exportType, exportSource));
        runner.run(monitor);
    }

    protected String[] getExecutionTargets(int exportType, boolean exportSource) {
        ArrayList<String> targets = new ArrayList<String>();
        if (exportType == 3) {
            targets.add("build.update.jar");
        } else {
            targets.add("build.jars");
            targets.add("gather.bin.parts");
            if (exportSource) {
                targets.add("build.sources");
                targets.add("gather.sources");
            }
        }
        return targets.toArray(new String[targets.size()]);
    }

    /*
     * Exception decompiling
     */
    protected void cleanup(String filename, String destination, int exportType, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 248->252)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File createScriptFile() throws IOException {
        String path = PDEPlugin.getDefault().getStateLocation().toOSString();
        File zip = new File(path, "zip.xml");
        if (zip.exists()) {
            zip.delete();
            zip.createNewFile();
        }
        return zip;
    }

    private void generateHeader(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<project name=\"temp\" default=\"clean\" basedir=\".\">");
    }

    private void generateCleanTarget(PrintWriter writer) {
        writer.println("<target name=\"clean\">");
        writer.println("<delete dir=\"" + this.buildTempLocation + "\"/>");
        writer.println("</target>");
    }

    private void generateCopyResultTarget(PrintWriter writer, String destination) {
        writer.println("<target name=\"copy.result\">");
        writer.println("<copy todir=\"" + destination + "\">");
        writer.println("<fileset dir=\"" + this.buildTempLocation + "/destination\"/>");
        writer.println("</copy>");
        writer.println("</target>");
    }

    private void generateZipFolderTarget(PrintWriter writer, String destination, String filename) {
        writer.println("<target name=\"zip.folder\">");
        writer.println("<zip zipfile=\"" + destination + "/" + filename + "\" basedir=\"" + this.buildTempLocation + "/destination\"/>");
        writer.println("</target>");
    }

    private boolean generateZipLogsTarget(PrintWriter writer, String destination) {
        if (logFile != null && logFile.exists() && logFile.length() > 0L) {
            writer.println("<target name=\"zip.logs\">");
            writer.println("<delete file=\"" + destination + "/logs.zip\"/>");
            writer.println("<zip zipfile=\"" + destination + "/logs.zip\" basedir=\"" + this.buildTempLocation + "/temp.folder\"/>");
            writer.println("</target>");
            return true;
        }
        return false;
    }

    private void generateClosingTag(PrintWriter writer) {
        writer.println("</project>");
    }

    protected boolean isCustomBuild(IModel model) throws CoreException {
        IBuild build;
        IBuildEntry entry;
        WorkspaceBuildModel buildModel = null;
        IFile buildFile = model.getUnderlyingResource().getProject().getFile("build.properties");
        if (buildFile.exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        if (buildModel != null && (entry = (build = buildModel.getBuild()).getEntry("custom")) != null) {
            String[] tokens = entry.getTokens();
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i].equals("true")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void asyncNotifyExportException(String errorMessage) {
        BaseExportJob.getStandardDisplay().beep();
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("ExportJob.jobTitle"), (String)errorMessage);
        this.done(OK_STATUS);
    }
}

