/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.elements.ListContentProvider;
import org.eclipse.pde.internal.ui.wizards.BaseWizardSelectionPage;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class WizardListSelectionPage
extends BaseWizardSelectionPage
implements ISelectionChangedListener {
    protected TableViewer wizardSelectionViewer;
    private ElementList wizardElements;
    private WizardSelectedAction doubleClickAction = new WizardSelectedAction();

    public WizardListSelectionPage(ElementList wizardElements, String message) {
        super("ListSelection", message);
        this.wizardElements = wizardElements;
    }

    public void advanceToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    public ElementList getWizardElements() {
        return this.wizardElements;
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(272));
        Label label = new Label(outerContainer, 0);
        label.setText(this.getLabel());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.wizardSelectionViewer = new TableViewer(this.createTable(outerContainer, 2048));
        this.wizardSelectionViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)ListUtil.TABLE_LABEL_PROVIDER);
        this.wizardSelectionViewer.setSorter(ListUtil.NAME_SORTER);
        this.wizardSelectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WizardListSelectionPage.this.doubleClickAction.run();
            }
        });
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.wizardSelectionViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.createDescriptionIn(outerContainer);
        this.wizardSelectionViewer.setInput((Object)this.wizardElements);
        this.setControl((Control)outerContainer);
    }

    private Table createTable(Composite parent, int style) {
        Table table = new Table(parent, style);
        new TableColumn(table, 0);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        table.setLayout((Layout)layout);
        return table;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setErrorMessage(null);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        WizardElement currentWizardSelection = null;
        Iterator iter = selection.iterator();
        if (iter.hasNext()) {
            currentWizardSelection = (WizardElement)iter.next();
        }
        if (currentWizardSelection == null) {
            this.setDescriptionText("");
            this.setSelectedNode(null);
            return;
        }
        WizardElement finalSelection = currentWizardSelection;
        this.setSelectedNode(this.createWizardNode(finalSelection));
        this.setDescriptionText(finalSelection.getDescription());
    }

    public void setSelectedNode(IWizardNode node) {
        super.setSelectedNode(node);
    }

    public IWizardPage getNextPage(boolean shouldCreate) {
        if (!shouldCreate) {
            return super.getNextPage();
        }
        IWizardNode selectedNode = this.getSelectedNode();
        selectedNode.dispose();
        IWizard wizard = selectedNode.getWizard();
        if (wizard == null) {
            super.setSelectedNode(null);
            return null;
        }
        if (shouldCreate) {
            wizard.addPages();
        }
        return wizard.getStartingPage();
    }

    protected void focusAndSelectFirst() {
        Table table = this.wizardSelectionViewer.getTable();
        table.setFocus();
        TableItem[] items = table.getItems();
        if (items.length > 0) {
            TableItem first = items[0];
            Object obj = first.getData();
            this.wizardSelectionViewer.setSelection((ISelection)new StructuredSelection(obj));
        }
    }

    private class WizardSelectedAction
    extends Action {
        public WizardSelectedAction() {
            super("wizardSelection");
        }

        public void run() {
            WizardListSelectionPage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)WizardListSelectionPage.this.wizardSelectionViewer, WizardListSelectionPage.this.wizardSelectionViewer.getSelection()));
            WizardListSelectionPage.this.advanceToNextPage();
        }
    }
}

