/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.swt.graphics.Image;

public class WizardElement
extends NamedElement {
    public static final String ATT_NAME = "name";
    public static final String TAG_DESCRIPTION = "description";
    public static final String ATT_ICON = "icon";
    public static final String ATT_ID = "id";
    public static final String ATT_CLASS = "class";
    public static final String ATT_TEMPLATE = "template";
    private String description;
    private IConfigurationElement configurationElement;

    public WizardElement(IConfigurationElement config) {
        super(config.getAttribute(ATT_NAME));
        this.configurationElement = config;
    }

    public Object createExecutableExtension() throws CoreException {
        return this.configurationElement.createExecutableExtension(ATT_CLASS);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getDescription() {
        IConfigurationElement[] children;
        if (this.description == null && (children = this.configurationElement.getChildren(TAG_DESCRIPTION)).length > 0) {
            this.description = this.expandDescription(children[0].getValue());
        }
        return this.description;
    }

    private String expandDescription(String source) {
        if (source == null || source.length() == 0) {
            return source;
        }
        if (source.indexOf(37) == -1) {
            return source;
        }
        ResourceBundle bundle = this.configurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getResourceBundle();
        if (bundle == null) {
            return source;
        }
        StringBuffer buf = new StringBuffer();
        boolean keyMode = false;
        int keyStartIndex = -1;
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == '%') {
                char c2 = source.charAt(i + 1);
                if (c2 == '%') {
                    ++i;
                    buf.append('%');
                } else if (keyMode) {
                    String key;
                    keyMode = false;
                    String value = key = source.substring(keyStartIndex, i);
                    try {
                        value = bundle.getString(key);
                    }
                    catch (MissingResourceException missingResourceException) {}
                    buf.append(value);
                } else {
                    keyStartIndex = i + 1;
                    keyMode = true;
                }
            } else if (!keyMode) {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public String getID() {
        return this.configurationElement.getAttribute(ATT_ID);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public boolean isTemplate() {
        String att = this.configurationElement.getAttribute(ATT_TEMPLATE);
        return att != null && att.equalsIgnoreCase("true");
    }
}

