/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.view.DependenciesView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;

public class OpenDependenciesAction
implements IWorkbenchWindowActionDelegate {
    private ISelection fSelection;

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.fSelection;
            this.openDependencies(ssel.getFirstElement());
        }
    }

    private void openDependencies(Object el) {
        IModel model;
        if (el instanceof IFile) {
            el = ((IFile)el).getProject();
        }
        if (el instanceof IJavaProject) {
            el = ((IJavaProject)el).getProject();
        }
        if (el instanceof IProject && (model = PDECore.getDefault().getWorkspaceModelManager().getWorkspaceModel((IProject)el)) instanceof IPluginModelBase) {
            el = model;
        }
        if (el instanceof IPluginObject) {
            el = ((IPluginObject)el).getModel();
        }
        if (el instanceof IPluginModelBase) {
            this.openDependencies((IPluginModelBase)el);
        }
    }

    private void openDependencies(IPluginModelBase model) {
        IWorkbenchPage page = PDEPlugin.getActivePage();
        try {
            IViewPart view = page.showView("org.eclipse.pde.ui.DependenciesView");
            ((DependenciesView)view).openTo(model);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }
}

