/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.io.File;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.pde.internal.core.SourceLocation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SourceLocationDialog
extends Dialog {
    private Text nameText;
    private Text pathText;
    private Button browseButton;
    private String name;
    private IPath path;
    private Label statusLabel;
    private SourceLocation location;
    private static String previousPath = "";
    private HashSet existingNames = new HashSet();

    public SourceLocationDialog(Shell parentShell, SourceLocation location) {
        super(parentShell);
        this.location = location;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("SourceLocationDialog.locationName"));
        this.nameText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.nameText.setLayoutData((Object)gd);
        new Label(container, 0);
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("SourceLocationDialog.locationPath"));
        this.pathText = new Text(container, 2052);
        this.pathText.setText(previousPath);
        gd = new GridData(768);
        this.pathText.setLayoutData((Object)gd);
        this.browseButton = new Button(container, 8);
        this.browseButton.setText(PDEPlugin.getResourceString("SourceLocationDialog.browse"));
        this.browseButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.browseButton);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SourceLocationDialog.this.handleBrowse();
            }
        });
        this.statusLabel = new Label(container, 0);
        gd = new GridData(256);
        gd.horizontalSpan = 3;
        this.statusLabel.setLayoutData((Object)gd);
        if (this.location != null) {
            this.nameText.setText(this.location.getName());
            this.pathText.setText(this.location.getPath().toOSString());
        }
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SourceLocationDialog.this.dialogChanged();
            }
        };
        this.nameText.addModifyListener(listener);
        this.pathText.addModifyListener(listener);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void handleBrowse() {
        DirectoryDialog dd = new DirectoryDialog(this.getShell());
        dd.setFilterPath(this.pathText.getText());
        String path = dd.open();
        if (path != null) {
            this.pathText.setText(path);
        }
    }

    private void dialogChanged() {
        String error = null;
        String name = this.nameText.getText();
        String path = this.pathText.getText();
        if (name.length() == 0) {
            error = PDEPlugin.getResourceString("SourceLocationDialog.nameNotDefined");
        } else if (this.isInvalidVariable(name)) {
            error = PDEPlugin.getResourceString("SourceLocationDialog.exists");
        } else if (path.length() == 0) {
            error = PDEPlugin.getResourceString("SourceLocationDialog.pathNotDefined");
        } else {
            File file = new File(path);
            if (!file.exists() || !file.isDirectory()) {
                error = PDEPlugin.getResourceString("SourceLocationDialog.locationNotFound");
            }
        }
        this.setError(error);
    }

    private void setError(String error) {
        if (error != null) {
            this.statusLabel.setText(error);
            this.statusLabel.setForeground(JFaceColors.getErrorText((Display)this.getShell().getDisplay()));
        } else {
            this.statusLabel.setText("");
            this.statusLabel.setForeground(null);
        }
        this.getButton(0).setEnabled(error == null);
    }

    private boolean isInvalidVariable(String name) {
        return this.existingNames.contains(name);
    }

    protected void okPressed() {
        this.name = this.nameText.getText();
        previousPath = this.pathText.getText();
        this.path = new Path(this.pathText.getText());
        if (this.location != null) {
            this.location.setName(this.name);
            this.location.setPath(this.path);
        }
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public IPath getPath() {
        return this.path;
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    public void setInvalidNames(HashSet names) {
        this.existingNames = names;
    }
}

