/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.pde.core.IExternalModelManager;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.EclipseHomeInitializer;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.ModelProviderEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.RegistryLoader;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.preferences.TargetPlatformPreferencePage;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class ExternalPluginsBlock {
    private CheckboxTableViewer pluginListViewer;
    private TargetPlatformPreferencePage page;
    private static final String KEY_RELOAD = "ExternalPluginsBlock.reload";
    private static final String KEY_WORKSPACE = "ExternalPluginsBlock.workspace";
    private Vector models;
    private Vector fmodels;
    private boolean reloaded;
    private TablePart tablePart;
    private HashSet changed = new HashSet();
    private IPluginModelBase[] initialModels;
    private static final boolean DEFAULT_STATE = true;

    public ExternalPluginsBlock(TargetPlatformPreferencePage page) {
        this.page = page;
        String[] stringArray = new String[6];
        stringArray[0] = PDEPlugin.getResourceString(KEY_RELOAD);
        stringArray[2] = PDEPlugin.getResourceString("WizardCheckboxTablePart.selectAll");
        stringArray[3] = PDEPlugin.getResourceString("WizardCheckboxTablePart.deselectAll");
        stringArray[5] = PDEPlugin.getResourceString(KEY_WORKSPACE);
        String[] buttonLabels = stringArray;
        this.tablePart = new TablePart(buttonLabels);
        this.tablePart.setSelectAllIndex(2);
        this.tablePart.setDeselectAllIndex(3);
        PDEPlugin.getDefault().getLabelProvider().connect(this);
    }

    void computeDelta() {
        int type = 0;
        IModel[] addedArray = null;
        IModel[] removedArray = null;
        IModel[] changedArray = null;
        if (this.reloaded) {
            type = 3;
            removedArray = this.initialModels;
            addedArray = this.getAllModels();
        }
        if (this.changed.size() > 0) {
            type |= 4;
            changedArray = this.changed.toArray(new IModel[this.changed.size()]);
            this.changed.clear();
        }
        if (type != 0) {
            IExternalModelManager registry = PDECore.getDefault().getExternalModelManager();
            ModelProviderEvent event = new ModelProviderEvent((Object)registry, type, addedArray, removedArray, changedArray);
            registry.fireModelProviderEvent((IModelProviderEvent)event);
        }
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 15;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("ExternalPluginsBlock.title"));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.tablePart.createControl(container);
        this.pluginListViewer = this.tablePart.getTableViewer();
        this.pluginListViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        gd = (GridData)this.tablePart.getControl().getLayoutData();
        gd.heightHint = 100;
        return container;
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
    }

    private IPluginModelBase[] getAllModels() {
        if (this.models == null && this.fmodels == null) {
            this.initialModels = PDECore.getDefault().getExternalModelManager().getAllModels();
            return this.initialModels;
        }
        IPluginModelBase[] allModels = new IPluginModelBase[this.models.size() + this.fmodels.size()];
        System.arraycopy(this.models.toArray(new IPluginModel[this.models.size()]), 0, allModels, 0, this.models.size());
        System.arraycopy(this.fmodels.toArray(new IFragmentModel[this.fmodels.size()]), 0, allModels, this.models.size(), this.fmodels.size());
        return allModels;
    }

    void handleReload() {
        String platformPath = this.page.getPlatformPath();
        if (platformPath != null && platformPath.length() > 0) {
            String[] pluginPaths = PluginPathFinder.getPluginPaths((String)platformPath);
            ReloadOperation op = new ReloadOperation(pluginPaths);
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(PDEPlugin.getActiveWorkbenchShell());
            try {
                pmd.run(true, false, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            this.models = op.getPluginModels();
            this.fmodels = op.getFragmentModels();
            this.pluginListViewer.refresh();
            this.tablePart.selectAll(true);
            this.reloaded = true;
        }
        this.page.resetNeedsReload();
    }

    public void initialize() {
        String platformPath = this.page.getPlatformPath();
        if (platformPath != null && platformPath.length() == 0) {
            return;
        }
        this.pluginListViewer.setInput((Object)PDECore.getDefault().getExternalModelManager());
        IPluginModelBase[] allModels = this.getAllModels();
        Vector<IPluginModelBase> selection = new Vector<IPluginModelBase>();
        int i = 0;
        while (i < allModels.length) {
            IPluginModelBase model = allModels[i];
            if (model.isEnabled()) {
                selection.add(model);
            }
            ++i;
        }
        this.tablePart.setSelection(selection.toArray());
    }

    public void save() {
        BusyIndicator.showWhile((Display)this.page.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    JavaCore.run((IWorkspaceRunnable)new SaveOperation(), null);
                }
                catch (CoreException coreException) {}
            }
        });
    }

    private void savePreferences() {
        Path defaultPath;
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        Path newPath = new Path(this.page.getPlatformPath());
        String mode = newPath.equals((Object)(defaultPath = new Path(ExternalModelManager.computeDefaultPlatformPath()))) ? "useThis" : "useOther";
        preferences.setValue("target_mode", mode);
        preferences.setValue("platform_path", this.page.getPlatformPath());
        String[] locations = this.page.getPlatformLocations();
        int i = 0;
        while (i < locations.length && i < 5) {
            preferences.setValue("saved_platform" + i, locations[i]);
            ++i;
        }
        PDECore.getDefault().savePluginPreferences();
    }

    private void updateModels() {
        Iterator iter = this.changed.iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            model.setEnabled(this.tablePart.getTableViewer().getChecked((Object)model));
        }
        if (this.reloaded) {
            PDECore.getDefault().getExternalModelManager().resetModels(this.models, this.fmodels);
        }
    }

    private void selectNotInWorkspace() {
        IWorkspaceModelManager wm = PDECore.getDefault().getWorkspaceModelManager();
        IPluginModelBase[] wsModels = wm.getAllModels();
        IPluginModelBase[] exModels = this.getAllModels();
        Vector<IPluginModelBase> selected = new Vector<IPluginModelBase>();
        int i = 0;
        while (i < exModels.length) {
            IPluginModelBase exModel = exModels[i];
            boolean inWorkspace = false;
            int j = 0;
            while (j < wsModels.length) {
                IPluginModelBase wsModel = wsModels[j];
                if (exModel.getPluginBase().getId().equals(wsModel.getPluginBase().getId())) {
                    inWorkspace = true;
                    break;
                }
                ++j;
            }
            if (!inWorkspace) {
                selected.add(exModel);
            }
            if (exModel.isEnabled() == inWorkspace) {
                this.changed.add(exModel);
            } else if (this.changed.contains(exModel)) {
                this.changed.remove(exModel);
            }
            ++i;
        }
        this.tablePart.setSelection(selected.toArray());
    }

    public void handleSelectAll(boolean selected) {
        this.tablePart.selectAll(selected);
    }

    class ReloadOperation
    implements IRunnableWithProgress {
        private Vector models = new Vector();
        private Vector fmodels = new Vector();
        private String[] pluginPaths;

        public ReloadOperation(String[] pluginPaths) {
            this.pluginPaths = pluginPaths;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            RegistryLoader.reload((String[])this.pluginPaths, (Vector)this.models, (Vector)this.fmodels, (IProgressMonitor)monitor);
        }

        public Vector getPluginModels() {
            return this.models;
        }

        public Vector getFragmentModels() {
            return this.fmodels;
        }
    }

    class SaveOperation
    implements IWorkspaceRunnable {
        SaveOperation() {
        }

        public void run(IProgressMonitor monitor) {
            ExternalPluginsBlock.this.savePreferences();
            if (ExternalPluginsBlock.this.reloaded) {
                EclipseHomeInitializer.resetEclipseHomeVariables();
            }
            ExternalPluginsBlock.this.updateModels();
            ExternalPluginsBlock.this.computeDelta();
            if (ExternalPluginsBlock.this.reloaded) {
                PDECore.getDefault().getSourceLocationManager().reinitializeClasspathVariables(null);
            }
        }
    }

    public class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            return ExternalPluginsBlock.this.getAllModels();
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String[] buttonLabels) {
            super(null, buttonLabels);
        }

        protected void buttonSelected(Button button, int index) {
            switch (index) {
                case 0: {
                    ExternalPluginsBlock.this.handleReload();
                    break;
                }
                case 5: {
                    ExternalPluginsBlock.this.selectNotInWorkspace();
                    break;
                }
                default: {
                    super.buttonSelected(button, index);
                }
            }
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, factory);
            viewer.setSorter(ListUtil.PLUGIN_SORTER);
            return viewer;
        }

        protected void elementChecked(Object element, boolean checked) {
            IPluginModelBase model = (IPluginModelBase)element;
            if (ExternalPluginsBlock.this.changed.contains(model) && model.isEnabled() == checked) {
                ExternalPluginsBlock.this.changed.remove(model);
            } else if (model.isEnabled() != checked) {
                ExternalPluginsBlock.this.changed.add(model);
            }
            super.elementChecked(element, checked);
        }

        protected void handleSelectAll(boolean select) {
            super.handleSelectAll(select);
            IPluginModelBase[] allModels = ExternalPluginsBlock.this.getAllModels();
            int i = 0;
            while (i < allModels.length) {
                IPluginModelBase model = allModels[i];
                if (model.isEnabled() != select) {
                    ExternalPluginsBlock.this.changed.add(model);
                } else if (ExternalPluginsBlock.this.changed.contains(model) && model.isEnabled() == select) {
                    ExternalPluginsBlock.this.changed.remove(model);
                }
                ++i;
            }
        }
    }
}

