/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BuildOptionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
    private Button fFailOnError;
    private Button fVerbose;
    private Button fDebugInfo;
    private Combo fJavacSource;
    private Combo fJavacTarget;

    public BuildOptionsPreferencePage() {
        this.setDescription(PDEPlugin.getResourceString("BuildPropertiesPreferencePage.desc"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 15;
        composite.setLayout((Layout)layout);
        this.fFailOnError = new Button(composite, 32);
        this.fFailOnError.setText(PDEPlugin.getResourceString("BuildPropertiesPreferencePage.failOnError"));
        this.fFailOnError.setSelection(this.store.getBoolean("javacFailOnError"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fFailOnError.setLayoutData((Object)gd);
        this.fVerbose = new Button(composite, 32);
        this.fVerbose.setText(PDEPlugin.getResourceString("BuildPropertiesPreferencePage.compilerVerbose"));
        this.fVerbose.setSelection(this.store.getBoolean("javacVerbose"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fVerbose.setLayoutData((Object)gd);
        this.fDebugInfo = new Button(composite, 32);
        this.fDebugInfo.setText(PDEPlugin.getResourceString("BuildPropertiesPreferencePage.compilerDebug"));
        this.fDebugInfo.setSelection(this.store.getBoolean("javacDebugInfo"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fDebugInfo.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(PDEPlugin.getResourceString("BuildPropertiesPreferencePage.javacSource"));
        this.fJavacSource = new Combo(composite, 8);
        this.fJavacSource.setItems(new String[]{"1.3", "1.4"});
        this.fJavacSource.setText(this.store.getString("javacSource"));
        gd = new GridData();
        gd.widthHint = 100;
        this.fJavacSource.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText(PDEPlugin.getResourceString("BuildPropertiesPreferencePage.javacTarget"));
        this.fJavacTarget = new Combo(composite, 8);
        this.fJavacTarget.setItems(new String[]{"1.1", "1.2", "1.3", "1.4"});
        this.fJavacTarget.setText(this.store.getString("javacTarget"));
        gd = new GridData();
        gd.widthHint = 100;
        this.fJavacTarget.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public boolean performOk() {
        this.store.setValue("javacFailOnError", this.fFailOnError.getSelection());
        this.store.setValue("javacVerbose", this.fVerbose.getSelection());
        this.store.setValue("javacDebugInfo", this.fDebugInfo.getSelection());
        this.store.setValue("javacSource", this.fJavacSource.getText());
        this.store.setValue("javacTarget", this.fJavacTarget.getText());
        PDEPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        this.fFailOnError.setSelection(this.store.getDefaultBoolean("javacFailOnError"));
        this.fVerbose.setSelection(this.store.getDefaultBoolean("javacVerbose"));
        this.fDebugInfo.setSelection(this.store.getDefaultBoolean("javacDebugInfo"));
        this.fJavacSource.setText(this.store.getDefaultString("javacSource"));
        this.fJavacTarget.setText(this.store.getDefaultString("javacTarget"));
    }
}

