/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameDialog
extends Dialog {
    private String oldName;
    private String newName;
    private Text text;

    public RenameDialog(Shell shell, String oldName) {
        super(shell);
        this.setOldName(oldName);
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
        if (this.text != null) {
            this.text.setText(oldName);
        }
        this.newName = oldName;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("RenameDialog.label"));
        this.text = new Text(container, 2052);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameDialog.this.textChanged(RenameDialog.this.text.getText());
            }
        });
        gd = new GridData(768);
        this.text.setLayoutData((Object)gd);
        return container;
    }

    public int open() {
        this.text.setText(this.oldName);
        this.text.selectAll();
        this.textChanged(this.oldName);
        return super.open();
    }

    private void textChanged(String text) {
        Button okButton = this.getButton(0);
        okButton.setEnabled(!text.equals(this.oldName));
    }

    public String getNewName() {
        return this.newName;
    }

    protected void okPressed() {
        this.newName = this.text.getText();
        super.okPressed();
    }
}

