/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.HyperlinkSettings;
import org.eclipse.update.ui.forms.internal.engine.FormEngine;

public class FormBrowser {
    ScrolledComposite scomp;
    FormEngine engine;
    String text;
    FormWidgetFactory factory;
    int style;

    public FormBrowser(int style) {
        this.style = style;
    }

    public void createControl(Composite parent) {
        this.factory = new FormWidgetFactory(parent.getDisplay());
        this.scomp = new ScrolledComposite(parent, this.style);
        this.scomp.setBackground(this.factory.getBackgroundColor());
        this.engine = this.factory.createFormEngine((Composite)this.scomp);
        this.engine.setMarginWidth(2);
        this.engine.setMarginHeight(2);
        this.engine.setHyperlinkSettings((HyperlinkSettings)this.factory.getHyperlinkHandler());
        this.scomp.setContent((Control)this.engine);
        this.scomp.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                FormBrowser.this.updateSize();
            }
        });
        this.engine.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FormBrowser.this.factory != null) {
                    FormBrowser.this.factory.dispose();
                    FormBrowser.this.factory = null;
                }
            }
        });
        if (this.text != null) {
            this.loadText(this.text);
        }
    }

    public Control getControl() {
        return this.scomp;
    }

    public void setText(String text) {
        this.text = text;
        this.loadText(text);
    }

    private void loadText(String text) {
        if (this.engine != null) {
            String markup = "<form>" + text + "</form>";
            this.engine.load(markup, true, false);
            this.updateSize();
            this.engine.redraw();
            this.scomp.layout();
        }
    }

    private void updateSize() {
        Rectangle ssize = this.scomp.getClientArea();
        int swidth = ssize.width;
        ScrollBar vbar = this.scomp.getVerticalBar();
        if (vbar != null) {
            swidth -= vbar.getSize().x;
        }
        Point size = this.engine.computeSize(swidth, -1, true);
        this.engine.setSize(size);
    }
}

