/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.parts.RenameDialog;
import org.eclipse.pde.internal.ui.parts.TablePart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class EditableTablePart
extends TablePart {
    private boolean editable;
    private Action renameAction;

    public EditableTablePart(String[] buttonLabels) {
        super(buttonLabels);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public IAction getRenameAction() {
        if (this.renameAction == null) {
            this.renameAction = new RenameAction();
        }
        return this.renameAction;
    }

    protected StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory) {
        TableViewer tableViewer = (TableViewer)super.createStructuredViewer(parent, style, factory);
        return tableViewer;
    }

    private void doRename() {
        TableViewer viewer = this.getTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.size() == 1 && this.isEditable()) {
            Object obj = selection.getFirstElement();
            String oldName = obj.toString();
            RenameDialog dialog = new RenameDialog(this.getControl().getShell(), oldName);
            dialog.create();
            dialog.getShell().setText(PDEPlugin.getResourceString("EditableTablePart.renameTitle"));
            dialog.getShell().setSize(300, 150);
            if (dialog.open() == 0) {
                this.entryModified(this.doFindItem(obj), dialog.getNewName());
            }
        }
    }

    private Widget doFindItem(Object element) {
        TableItem[] children = this.getTableViewer().getTable().getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            Object data = item.getData();
            if (data != null && data.equals(element)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected void entryModified(Object entry, String value) {
    }

    class RenameAction
    extends Action {
        public RenameAction() {
            super(PDEPlugin.getResourceString("EditableTablePart.renameAction"));
        }

        public void run() {
            EditableTablePart.this.doRename();
        }
    }

    class NameModifier
    implements ICellModifier {
        NameModifier() {
        }

        public boolean canModify(Object object, String property) {
            return true;
        }

        public void modify(Object object, String property, Object value) {
            EditableTablePart.this.entryModified(object, value.toString());
        }

        public Object getValue(Object object, String property) {
            return object.toString();
        }
    }
}

