/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.osgi.wizards;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.osgi.wizards.PluginToBundleAction;
import org.eclipse.pde.internal.ui.osgi.wizards.PluginToBundleWizardPage;

public class PluginToBundleWizard
extends Wizard {
    private PluginToBundleWizardPage page1;
    private IPluginModelBase[] selected;
    private static final String STORE_SECTION = "PluginToBundleWizard";
    private static final String KEY_WTITLE = "PluginToBundleWizard.wtitle";

    public PluginToBundleWizard(IPluginModelBase[] selected) {
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PLUGIN2BUNDLE_WIZ);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
        this.setNeedsProgressMonitor(true);
        this.selected = selected;
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public boolean performFinish() {
        Object[] finalSelected = this.page1.getSelected();
        this.page1.storeSettings();
        IPluginModelBase[] modelArray = new IPluginModelBase[finalSelected.length];
        System.arraycopy(finalSelected, 0, modelArray, 0, finalSelected.length);
        PluginToBundleAction.run(true, (IRunnableContext)this.getContainer(), modelArray);
        return true;
    }

    public void addPages() {
        this.page1 = new PluginToBundleWizardPage(this.selected);
        this.addPage((IWizardPage)this.page1);
    }
}

