/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.osgi.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.osgi.bundle.IBundle;
import org.eclipse.pde.core.osgi.bundle.IBundlePluginModelBase;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.osgi.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.plugin.WorkspaceExtensionsModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.osgi.wizards.PluginToBundleWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PluginToBundleAction
implements IWorkbenchWindowActionDelegate {
    private ISelection fSelection;
    private static final String KEY_TITLE = "Actions.classpath.title";
    private static final String KEY_MESSAGE = "Actions.classpath.message";
    private static final String KEY_UPDATE = "Actions.classpath.update";
    private static final String KEY_SETTING = "Actions.classpath.setting";

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            ArrayList<IPluginModelBase> models = new ArrayList<IPluginModelBase>(elems.length);
            int i = 0;
            while (i < elems.length) {
                IPluginModelBase model;
                Object elem = elems[i];
                IProject project = null;
                if (elem instanceof IFile) {
                    IFile file = (IFile)elem;
                    project = file.getProject();
                } else if (elem instanceof IProject) {
                    project = (IProject)elem;
                } else if (elem instanceof IJavaProject) {
                    project = ((IJavaProject)elem).getProject();
                }
                if (project != null && WorkspaceModelManager.isJavaPluginProject((IProject)project) && (model = this.findModelFor(project)) != null && !(model instanceof IBundlePluginModelBase)) {
                    models.add(model);
                }
                ++i;
            }
            IPluginModelBase[] modelArray = models.toArray(new IPluginModelBase[models.size()]);
            PluginToBundleWizard wizard = new PluginToBundleWizard(modelArray);
            WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public static void run(boolean fork, IRunnableContext context, final IPluginModelBase[] models) {
        try {
            context.run(fork, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(this, models){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ IPluginModelBase[] val$models;
                            {
                                this.this$1 = var1_1;
                                this.val$models = iPluginModelBaseArray;
                            }

                            public void run(IProgressMonitor monitor) throws CoreException {
                                PluginToBundleAction.doConvertPluginsToBundles(monitor, this.val$models);
                            }
                        };
                        PDEPlugin.getWorkspace().run(runnable, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            String title = PDEPlugin.getResourceString(KEY_TITLE);
            String message = PDEPlugin.getResourceString(KEY_MESSAGE);
            PDEPlugin.logException(e, title, message);
        }
    }

    private IPluginModelBase findModelFor(IProject project) {
        IWorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        return (IPluginModelBase)manager.getWorkspaceModel(project);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doConvertPluginsToBundles(IProgressMonitor monitor, IPluginModelBase[] models) throws CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(KEY_UPDATE), models.length);
        try {
            int i = 0;
            while (i < models.length) {
                IPluginModelBase model = models[i];
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                PluginToBundleAction.convertPluginToBundle(model, (IProgressMonitor)subMonitor);
                if (!monitor.isCanceled()) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    private static void convertPluginToBundle(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        IPluginBase pluginBase = model.getPluginBase();
        String message = PDEPlugin.getFormattedMessage(KEY_SETTING, pluginBase.getId());
        monitor.beginTask(message, 2);
        PluginToBundleAction.createBundleManifest(model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        PluginToBundleAction.createExtensions(model);
        monitor.worked(1);
        monitor.done();
    }

    private static void createBundleManifest(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        IProject project = model.getUnderlyingResource().getProject();
        IFile file = project.getFile("META-INF/MANIFEST.MF");
        WorkspaceBundleModel bmodel = new WorkspaceBundleModel(file);
        IBundle bundle = bmodel.getBundle(true);
        monitor.beginTask("", 2);
        bundle.load(model.getPluginBase(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IFolder folder = (IFolder)file.getParent();
        CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        bmodel.save();
    }

    private static void createExtensions(IPluginModelBase model) {
        IProject project = model.getUnderlyingResource().getProject();
        IFile file = project.getFile("extensions.xml");
        WorkspaceExtensionsModel emodel = new WorkspaceExtensionsModel(file);
        IExtensions ex = emodel.getExtensions(true);
        ex.load((IExtensions)model.getPluginBase());
        emodel.save();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }
}

