/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.osgi.templates;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.osgi.bundle.IBundleModel;
import org.eclipse.pde.core.plugin.IExtensionsModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.osgi.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.osgi.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.osgi.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.osgi.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.plugin.WorkspaceExtensionsModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.osgi.templates.BundleActivatorClassCodeGenerator;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.project.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.wizards.templates.FieldData;
import org.eclipse.pde.internal.ui.wizards.templates.IFirstWizardPage;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;
import org.eclipse.pde.ui.IPluginStructureData;
import org.eclipse.pde.ui.IProjectProvider;
import org.eclipse.pde.ui.templates.IFieldData;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class FirstBundleTemplateWizardPage
extends WizardPage
implements IFirstWizardPage {
    private static final String KEY_TITLE = "DefaultBundleCodeGenerationPage.title";
    private static final String KEY_FTITLE = "DefaultBundleCodeGenerationPage.ftitle";
    private static final String KEY_ID_NOT_SET = "DefaultCodeGenerationPage.idNotSet";
    private static final String KEY_VERSION_FORMAT = "DefaultCodeGenerationPage.versionFormat";
    private static final String KEY_INVALID_ID = "DefaultCodeGenerationPage.invalidId";
    private static final String KEY_DESC = "DefaultBundleCodeGenerationPage.desc";
    private static final String KEY_FDESC = "DefaultBundleCodeGenerationPage.fdesc";
    private static final String KEY_FNAME = "DefaultBundleCodeGenerationPage.fname";
    private static final String KEY_NAME = "DefaultBundleCodeGenerationPage.name";
    private static final String KEY_VERSION = "DefaultBundleCodeGenerationPage.version";
    private static final String KEY_PROVIDER = "DefaultBundleCodeGenerationPage.providerName";
    private static final String KEY_PLUGIN_ID = "DefaultBundleCodeGenerationPage.pluginId";
    private static final String KEY_BROWSE = "DefaultBundleCodeGenerationPage.pluginId.browse";
    private static final String KEY_PLUGIN_VERSION = "DefaultBundleCodeGenerationPage.pluginVersion";
    private static final String KEY_MATCH = "ManifestEditor.PluginSpecSection.versionMatch";
    private static final String KEY_MATCH_PERFECT = "ManifestEditor.MatchSection.perfect";
    private static final String KEY_MATCH_EQUIVALENT = "ManifestEditor.MatchSection.equivalent";
    private static final String KEY_MATCH_COMPATIBLE = "ManifestEditor.MatchSection.compatible";
    private static final String KEY_MATCH_GREATER = "ManifestEditor.MatchSection.greater";
    private static final String KEY_CLASS = "DefaultBundleCodeGenerationPage.class";
    private static final String KEY_GENERATE = "DefaultBundleCodeGenerationPage.generate";
    private static final String KEY_INITIAL_NAME = "DefaultBundleCodeGenerationPage.initialName";
    private static final String KEY_INITIAL_FNAME = "DefaultBundleCodeGenerationPage.initialFName";
    private static final String KEY_CREATING = "DefaultBundleCodeGenerationPage.creating";
    private static final String KEY_OPTIONS = "DefaultBundleCodeGenerationPage.options";
    private static final String KEY_OPTIONS_THIS = "DefaultBundleCodeGenerationPage.options.this";
    private static final String KEY_OPTIONS_BUNDLE = "DefaultBundleCodeGenerationPage.options.bundle";
    private static final String KEY_OPTIONS_WORKSPACE = "DefaultBundleCodeGenerationPage.options.workspace";
    private static final String KEY_BROWSE_TITLE = "DefaultBundleCodeGenerationPage.pluginId.browse.title";
    private IProjectProvider projectProvider;
    private IPluginStructureData structureData;
    private boolean fragment;
    private Text nameField;
    private Text pluginVersionField;
    private Text pluginIdField;
    private Button thisCheck;
    private Button bundleCheck;
    private Button workspaceCheck;
    private Text versionField;
    private Combo matchCombo;
    private Text providerField;
    private Text classField;
    private Button generateMainClass;
    private boolean pluginFieldsStatus;
    private boolean versionStatus;
    private boolean classStatus;
    private String versionError;
    private String classError;

    public FirstBundleTemplateWizardPage(IProjectProvider projectProvider, IPluginStructureData structureData, boolean fragment) {
        super("FirstTemplateWizardPage");
        this.fragment = fragment;
        if (fragment) {
            this.setTitle(PDEPlugin.getResourceString(KEY_FTITLE));
            this.setDescription(PDEPlugin.getResourceString(KEY_FDESC));
        } else {
            this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
            this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        }
        this.projectProvider = projectProvider;
        this.structureData = structureData;
        this.pluginFieldsStatus = true;
        this.versionStatus = true;
        this.classStatus = true;
    }

    public void becomesVisible(int event) {
        this.nameField.setFocus();
    }

    private void browsePluginId() {
        BusyIndicator.showWhile((Display)this.pluginIdField.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                PluginSelectionDialog dialog = new PluginSelectionDialog(FirstBundleTemplateWizardPage.this.pluginIdField.getShell());
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 300, 400);
                dialog.getShell().setText(PDEPlugin.getResourceString(FirstBundleTemplateWizardPage.KEY_BROWSE_TITLE));
                if (dialog.open() == 0) {
                    IPluginModel model = (IPluginModel)dialog.getFirstResult();
                    IPlugin plugin = model.getPlugin();
                    FirstBundleTemplateWizardPage.this.pluginIdField.setText(plugin.getId());
                    FirstBundleTemplateWizardPage.this.pluginVersionField.setText(plugin.getVersion());
                }
            }
        });
    }

    private Button createCheck(Composite parent, String label, boolean state) {
        Button check = new Button(parent, 32);
        check.setText(label);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        check.setLayoutData((Object)gd);
        check.setSelection(state);
        return check;
    }

    private void addCommonControls(Composite parent) {
        this.nameField = this.createField(parent, PDEPlugin.getResourceString(this.fragment ? KEY_FNAME : KEY_NAME));
        this.versionField = this.createField(parent, PDEPlugin.getResourceString(KEY_VERSION));
        this.versionField.setText("1.0.0");
        this.versionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!FirstBundleTemplateWizardPage.this.isVersionValid(FirstBundleTemplateWizardPage.this.versionField.getText())) {
                    FirstBundleTemplateWizardPage.this.versionStatus = false;
                    FirstBundleTemplateWizardPage.this.setPageComplete(FirstBundleTemplateWizardPage.this.versionStatus);
                    FirstBundleTemplateWizardPage.this.setVersionError(PDEPlugin.getResourceString(FirstBundleTemplateWizardPage.KEY_VERSION_FORMAT));
                } else if (FirstBundleTemplateWizardPage.this.fragment) {
                    FirstBundleTemplateWizardPage.this.verifyPluginFields();
                } else {
                    FirstBundleTemplateWizardPage.this.versionStatus = true;
                    FirstBundleTemplateWizardPage.this.evalPageComplete();
                    FirstBundleTemplateWizardPage.this.setVersionError(null);
                }
            }
        });
        this.providerField = this.createField(parent, PDEPlugin.getResourceString(KEY_PROVIDER));
    }

    private void addFragmentSpecificControls(Composite parent) {
        this.pluginIdField = this.createField(parent, PDEPlugin.getResourceString(KEY_PLUGIN_ID), false);
        this.pluginIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FirstBundleTemplateWizardPage.this.verifyPluginFields();
            }
        });
        Button browsePluginButton = new Button(parent, 8);
        browsePluginButton.setText(PDEPlugin.getResourceString(KEY_BROWSE));
        browsePluginButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FirstBundleTemplateWizardPage.this.browsePluginId();
            }
        });
        this.pluginVersionField = this.createField(parent, PDEPlugin.getResourceString(KEY_PLUGIN_VERSION));
        this.pluginVersionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FirstBundleTemplateWizardPage.this.verifyPluginFields();
            }
        });
        this.matchCombo = this.createMatchCombo(parent);
    }

    private void addPluginSpecificControls(Composite parent) {
        this.classField = this.createField(parent, PDEPlugin.getResourceString(KEY_CLASS));
        this.classField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                IStatus status = JavaConventions.validateJavaTypeName((String)FirstBundleTemplateWizardPage.this.classField.getText());
                if (FirstBundleTemplateWizardPage.this.classField.getText().equals("")) {
                    FirstBundleTemplateWizardPage.this.generateMainClass.setEnabled(false);
                    FirstBundleTemplateWizardPage.this.thisCheck.setEnabled(false);
                    FirstBundleTemplateWizardPage.this.bundleCheck.setEnabled(false);
                    FirstBundleTemplateWizardPage.this.workspaceCheck.setEnabled(false);
                    FirstBundleTemplateWizardPage.this.setClassError(null);
                    FirstBundleTemplateWizardPage.this.classStatus = true;
                    FirstBundleTemplateWizardPage.this.evalPageComplete();
                } else if (status.getSeverity() == 4) {
                    FirstBundleTemplateWizardPage.this.generateMainClass.setEnabled(true);
                    FirstBundleTemplateWizardPage.this.thisCheck.setEnabled(FirstBundleTemplateWizardPage.this.generateMainClass.getSelection());
                    FirstBundleTemplateWizardPage.this.bundleCheck.setEnabled(FirstBundleTemplateWizardPage.this.generateMainClass.getSelection());
                    FirstBundleTemplateWizardPage.this.workspaceCheck.setEnabled(FirstBundleTemplateWizardPage.this.generateMainClass.getSelection());
                    FirstBundleTemplateWizardPage.this.setClassError(status.getMessage());
                    FirstBundleTemplateWizardPage.this.classStatus = false;
                    FirstBundleTemplateWizardPage.this.setPageComplete(FirstBundleTemplateWizardPage.this.classStatus);
                } else {
                    FirstBundleTemplateWizardPage.this.generateMainClass.setEnabled(true);
                    FirstBundleTemplateWizardPage.this.thisCheck.setEnabled(FirstBundleTemplateWizardPage.this.generateMainClass.getSelection());
                    FirstBundleTemplateWizardPage.this.bundleCheck.setEnabled(FirstBundleTemplateWizardPage.this.generateMainClass.getSelection());
                    FirstBundleTemplateWizardPage.this.workspaceCheck.setEnabled(FirstBundleTemplateWizardPage.this.generateMainClass.getSelection());
                    FirstBundleTemplateWizardPage.this.setClassError(null);
                    FirstBundleTemplateWizardPage.this.classStatus = true;
                    FirstBundleTemplateWizardPage.this.evalPageComplete();
                }
            }
        });
        new Label(parent, 0);
        this.generateMainClass = new Button(parent, 32);
        this.generateMainClass.setText(PDEPlugin.getResourceString(KEY_GENERATE));
        this.generateMainClass.setSelection(true);
        this.generateMainClass.setEnabled(true);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.generateMainClass.setLayoutData((Object)gd);
        this.generateMainClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean value = FirstBundleTemplateWizardPage.this.generateMainClass.getSelection();
                FirstBundleTemplateWizardPage.this.thisCheck.setEnabled(value);
                FirstBundleTemplateWizardPage.this.bundleCheck.setEnabled(value);
                FirstBundleTemplateWizardPage.this.workspaceCheck.setEnabled(value);
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 3;
        new Label(parent, 0).setLayoutData((Object)gd);
        Group checkGroup = new Group(parent, 0);
        checkGroup.setText(PDEPlugin.getResourceString(KEY_OPTIONS));
        checkGroup.setLayout((Layout)new GridLayout());
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        checkGroup.setLayoutData((Object)gd);
        this.thisCheck = this.createCheck((Composite)checkGroup, PDEPlugin.getResourceString(KEY_OPTIONS_THIS), true);
        this.bundleCheck = this.createCheck((Composite)checkGroup, PDEPlugin.getResourceString(KEY_OPTIONS_BUNDLE), true);
        this.workspaceCheck = this.createCheck((Composite)checkGroup, PDEPlugin.getResourceString(KEY_OPTIONS_WORKSPACE), true);
        this.thisCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean value = FirstBundleTemplateWizardPage.this.thisCheck.getSelection();
                FirstBundleTemplateWizardPage.this.bundleCheck.setEnabled(value);
            }
        });
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        Composite container = new Composite(parent, 0);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        this.addCommonControls(container);
        if (this.fragment) {
            this.addFragmentSpecificControls(container);
        } else {
            this.addPluginSpecificControls(container);
        }
        this.presetFields();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        if (this.fragment) {
            WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.new_fragment_required_data");
        } else {
            WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.new_project_required_data");
        }
    }

    private void verifyPluginFields() {
        if (this.pluginIdField.getText().length() == 0) {
            this.setErrorMessage(PDEPlugin.getResourceString(KEY_ID_NOT_SET));
            this.pluginFieldsStatus = false;
            this.setPageComplete(this.pluginFieldsStatus);
        } else {
            String id = this.pluginIdField.getText();
            String version = this.pluginVersionField.getText();
            if (version.length() == 0 || !this.isVersionValid(version)) {
                this.pluginFieldsStatus = false;
                this.setPageComplete(this.pluginFieldsStatus);
                this.setErrorMessage(PDEPlugin.getResourceString(KEY_VERSION_FORMAT));
                return;
            }
            int match = this.matchCombo.getSelectionIndex();
            if (this.isPluginValid(id, version, match)) {
                this.pluginFieldsStatus = true;
                this.evalPageComplete();
                this.setErrorMessage(null);
            } else {
                this.pluginFieldsStatus = false;
                this.setPageComplete(this.pluginFieldsStatus);
                this.setErrorMessage(PDEPlugin.getResourceString(KEY_INVALID_ID));
            }
        }
    }

    private boolean isPluginValid(String pluginId, String pluginVersion, int match) {
        IPlugin plugin = PDECore.getDefault().findPlugin(pluginId, pluginVersion, match);
        return plugin != null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.nameField.setFocus();
        }
    }

    private Text createField(Composite parent, String label) {
        return this.createField(parent, label, true);
    }

    private Text createField(Composite parent, String label, boolean addFiller) {
        Label l = new Label(parent, 0);
        l.setText(label);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        Text text = new Text(parent, 2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gd);
        if (addFiller) {
            Label filler = new Label(parent, 0);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            filler.setLayoutData((Object)gd);
        }
        return text;
    }

    private Combo createMatchCombo(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText(PDEPlugin.getResourceString(KEY_MATCH));
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        Combo combo = new Combo(parent, 2056);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gd);
        String[] items = new String[]{"", PDEPlugin.getResourceString(KEY_MATCH_EQUIVALENT), PDEPlugin.getResourceString(KEY_MATCH_COMPATIBLE), PDEPlugin.getResourceString(KEY_MATCH_PERFECT), PDEPlugin.getResourceString(KEY_MATCH_GREATER)};
        combo.setItems(items);
        combo.select(0);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FirstBundleTemplateWizardPage.this.verifyPluginFields();
            }
        });
        Label filler = new Label(parent, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        filler.setLayoutData((Object)gd);
        return combo;
    }

    private boolean isVersionValid(String version) {
        try {
            new PluginVersionIdentifier(version);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void presetFields() {
        String name = this.projectProvider.getProjectName();
        String noSpaceName = this.removeSpaces(name);
        int loc = name.lastIndexOf(46);
        String lastSegment = name;
        if (loc != -1) {
            StringBuffer buf = new StringBuffer(name.substring(loc + 1));
            buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
            lastSegment = buf.toString();
        }
        String noSpaceLastSegment = this.removeSpaces(lastSegment);
        if (!this.fragment) {
            this.classField.setText(String.valueOf(noSpaceName) + "." + noSpaceLastSegment.toString() + "Plugin");
        }
        this.versionField.setText("1.0.0");
        if (this.fragment) {
            this.nameField.setText(PDEPlugin.getFormattedMessage(KEY_INITIAL_FNAME, lastSegment));
        } else {
            this.nameField.setText(PDEPlugin.getFormattedMessage(KEY_INITIAL_NAME, lastSegment));
        }
        loc = name.indexOf(46);
        if (loc == -1) {
            return;
        }
        String firstSegment = name.substring(0, loc);
        if (firstSegment.toLowerCase().equals("com")) {
            String provider = name.substring(loc + 1);
            if ((loc = provider.indexOf(46)) != -1) {
                provider = provider.substring(0, loc);
                this.providerField.setText(provider.toUpperCase());
            } else {
                provider = "";
            }
        }
        this.evalPageComplete();
    }

    private String removeSpaces(String name) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c != ' ') {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public IFieldData createFieldData(ITemplateSection[] activeSections) {
        FieldData data = (FieldData)this.createFieldData();
        data.setHasPreference(false);
        if (this.thisCheck.getSelection()) {
            return data;
        }
        int i = 0;
        while (i < activeSections.length) {
            if (activeSections[i].getLabel().equals("Preference Page")) {
                data.setHasPreference(true);
            }
            ++i;
        }
        return data;
    }

    public IFieldData createFieldData() {
        FieldData data = new FieldData();
        data.setName(this.nameField.getText());
        PluginVersionIdentifier pvi = new PluginVersionIdentifier(this.versionField.getText());
        data.setVersion(pvi.toString());
        data.setProvider(this.providerField.getText());
        data.setFragment(this.fragment);
        if (this.fragment) {
            data.setPluginId(this.pluginIdField.getText());
            try {
                PluginVersionIdentifier fvi = new PluginVersionIdentifier(this.pluginVersionField.getText());
                data.setPluginVersion(fvi.toString());
            }
            catch (NumberFormatException numberFormatException) {
                data.setPluginVersion(this.pluginVersionField.getText());
            }
            data.setMatch(this.matchCombo.getSelectionIndex());
        } else {
            data.setDoMain(this.generateMainClass.getSelection());
            data.setClassName(this.classField.getText());
            data.setThisCheck(this.thisCheck.getSelection());
            data.setBundleCheck(this.bundleCheck.getSelection() && this.bundleCheck.isEnabled());
            data.setWorkspaceCheck(this.workspaceCheck.getSelection());
        }
        return data;
    }

    public BundlePluginModelBase createPluginManifest(IProject project, IFieldData data, ArrayList dependencies, IProgressMonitor monitor) throws CoreException {
        IFile buildFile;
        IFile file = project.getFile("META-INF/MANIFEST.MF");
        WorkspaceBundleModel bmodel = new WorkspaceBundleModel(file);
        file = project.getFile("extensions.xml");
        WorkspaceExtensionsModel emodel = new WorkspaceExtensionsModel(file);
        emodel.load();
        Object model = this.fragment ? new BundleFragmentModel() : new BundlePluginModel();
        model.setBundleModel((IBundleModel)bmodel);
        model.setExtensionsModel((IExtensionsModel)emodel);
        IPluginBase plugin = model.getPluginBase(true);
        plugin.setId(this.structureData.getPluginId());
        plugin.setName(data.getName());
        plugin.setProviderName(data.getProvider());
        plugin.setVersion(data.getVersion());
        if (this.fragment) {
            IFragment fragment = (IFragment)plugin;
            fragment.setPluginId(data.getPluginId());
            fragment.setPluginVersion(data.getPluginVersion());
            fragment.setRule(data.getMatch());
        } else {
            ((IPlugin)plugin).setClassName(data.getClassName());
        }
        if (this.structureData.getRuntimeLibraryName() != null) {
            IPluginLibrary library = model.getPluginFactory().createLibrary();
            library.setName(this.structureData.getRuntimeLibraryName());
            library.setExported(true);
            plugin.add(library);
        }
        boolean hasRuntime = false;
        int i = 0;
        while (i < dependencies.size()) {
            IPluginReference ref = (IPluginReference)dependencies.get(i);
            IPluginImport iimport = model.getPluginFactory().createImport();
            iimport.setId(ref.getId());
            iimport.setVersion(ref.getVersion());
            iimport.setMatch(ref.getMatch());
            plugin.add(iimport);
            ++i;
        }
        if (data.getClassName() != null && !hasRuntime) {
            IPluginImport iimport = model.getPluginFactory().createImport();
            iimport.setId("org.eclipse.core.runtime");
            plugin.add(iimport);
        }
        if ((buildFile = project.getFile("build.properties")).exists()) {
            WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
            model.setBuildModel((IBuildModel)buildModel);
        }
        if (data.isDoMain()) {
            this.generatePluginClass(project, data, monitor);
        }
        return model;
    }

    public void generatePluginClass(IProject project, IFieldData data, IProgressMonitor monitor) throws CoreException {
        String fullyQualifiedClassName = data.getClassName();
        if (fullyQualifiedClassName == null || fullyQualifiedClassName.length() == 0) {
            return;
        }
        int flags = 0;
        if (data.isThisCheck()) {
            flags |= 1;
        }
        if (data.isWorkspaceCheck()) {
            flags |= 2;
        }
        if (data.isBundleCheck()) {
            flags |= 8;
        }
        if (data.hasPreference()) {
            flags |= 0x10;
        }
        String sourceFolder = this.structureData.getSourceFolderName();
        IPath folderPath = project.getFullPath().append(sourceFolder);
        IFolder folder = project.getWorkspace().getRoot().getFolder(folderPath);
        BundleActivatorClassCodeGenerator generator = new BundleActivatorClassCodeGenerator(folder, fullyQualifiedClassName, flags);
        monitor.subTask(PDEPlugin.getFormattedMessage(KEY_CREATING, fullyQualifiedClassName));
        generator.generate(monitor);
        monitor.worked(1);
    }

    public IPluginReference[] getDependencies() {
        boolean needActivator = this.generateMainClass.getSelection();
        IPluginReference[] dependencies = new IPluginReference[needActivator ? 3 : 2];
        dependencies[0] = new PluginReference("org.eclipse.core.resources", null, 0);
        dependencies[1] = new PluginReference("org.eclipse.ui", null, 0);
        if (needActivator) {
            dependencies[2] = new PluginReference("org.eclipse.osgi", null, 0);
        }
        return dependencies;
    }

    public IPluginStructureData getStructureData() {
        return this.structureData;
    }

    public void evalPageComplete() {
        this.setPageComplete(this.pluginFieldsStatus && this.versionStatus && this.classStatus);
    }

    protected void setClassError(String err) {
        this.classError = err;
        this.evalErrorMsg();
    }

    protected void setVersionError(String err) {
        this.versionError = err;
        this.evalErrorMsg();
    }

    protected void evalErrorMsg() {
        if (this.versionError != null) {
            this.setErrorMessage(this.versionError);
        } else if (this.classError != null) {
            this.setErrorMessage(this.classError);
        } else {
            this.setErrorMessage(null);
        }
    }
}

