/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.osgi.templates;

import java.io.PrintWriter;
import org.eclipse.core.resources.IFolder;
import org.eclipse.pde.internal.ui.codegen.JavaCodeGenerator;

public class BundleActivatorClassCodeGenerator
extends JavaCodeGenerator {
    public static final int F_THIS = 1;
    public static final int F_WORKSPACE = 2;
    public static final int F_BUNDLES = 8;
    public static final int F_PREF = 16;
    public static final int F_UI = 32;
    private int flags;

    public BundleActivatorClassCodeGenerator(IFolder sourceFolder, String fullyQualifiedClassName, int flags) {
        super(sourceFolder.getProject(), sourceFolder, fullyQualifiedClassName);
        this.flags = flags;
    }

    public void generateContents(String packageName, String className, PrintWriter writer) {
        if (!packageName.equals("")) {
            writer.println("package " + packageName + ";");
            writer.println();
        }
        if ((this.flags & 0x20) != 0) {
            writer.println("import org.eclipse.ui.plugin.*;");
        }
        writer.println("import org.eclipse.core.runtime.*;");
        if ((this.flags & 2) != 0) {
            writer.println("import org.eclipse.core.resources.*;");
        }
        if ((this.flags & 0x10) != 0) {
            writer.println("import org.eclipse.jface.preference.*;");
        }
        if ((this.flags & 8) != 0) {
            writer.println("import java.util.*;");
        }
        writer.println();
        writer.println("/**");
        writer.println(" * The bundle activator.");
        writer.println(" */");
        if ((this.flags & 0x20) != 0) {
            writer.println("public class " + className + " extends AbstractUIPlugin {");
        } else {
            writer.println("public class " + className + " extends Plugin {");
        }
        if ((this.flags & 1) != 0) {
            writer.println("\t//The shared instance.");
            writer.println("\tprivate static " + className + " plugin;");
        }
        if ((this.flags & 8) != 0) {
            writer.println("\t//Resource bundle.");
            writer.println("\tprivate ResourceBundle resourceBundle;");
        }
        if ((this.flags & 0x10) != 0) {
            writer.println("\t//Preference store.");
            writer.println("\tprivate static IPreferenceStore preferenceStore;");
        }
        writer.println("\t");
        writer.println("\t/**");
        writer.println("\t * The constructor.");
        writer.println("\t */");
        writer.println("\tpublic " + className + "() {");
        if ((this.flags & 1) != 0) {
            writer.println("\t\tplugin = this;");
        }
        if ((this.flags & 0x10) != 0) {
            writer.println("\t\tpreferenceStore = this.getPreferenceStore();");
        }
        if ((this.flags & 8) != 0) {
            writer.println("\t\ttry {");
            writer.println("\t\t\tresourceBundle= ResourceBundle.getBundle(\"" + packageName + "." + className + "Resources\");");
            writer.println("\t\t} catch (MissingResourceException x) {");
            writer.println("\t\t\tresourceBundle = null;");
            writer.println("\t\t}");
        }
        writer.println("\t}");
        if ((this.flags & 1) != 0) {
            writer.println();
            writer.println("\t/**");
            writer.println("\t * Returns the shared instance.");
            writer.println("\t */");
            writer.println("\tpublic static " + className + " getDefault() {");
            writer.println("\t\treturn plugin;");
            writer.println("\t}");
        }
        if ((this.flags & 0x10) != 0) {
            writer.println();
            writer.println("\t/**");
            writer.println("\t * Returns the shared preference store.");
            writer.println("\t */");
            writer.println("\tpublic static IPreferenceStore getDefaultPreferenceStore() {");
            writer.println("\t\treturn preferenceStore;");
            writer.println("\t}");
        }
        if ((this.flags & 2) != 0) {
            writer.println();
            writer.println("\t/**");
            writer.println("\t * Returns the workspace instance.");
            writer.println("\t */");
            writer.println("\tpublic static IWorkspace getWorkspace() {");
            writer.println("\t\treturn ResourcesPlugin.getWorkspace();");
            writer.println("\t}");
        }
        if ((this.flags & 8) != 0) {
            writer.println();
            writer.println("\t/**");
            writer.println("\t * Returns the string from the plugin's resource bundle,");
            writer.println("\t * or 'key' if not found.");
            writer.println("\t */");
            writer.println("\tpublic static String getResourceString(String key) {");
            writer.println("\t\tResourceBundle bundle= " + className + ".getDefault().getResourceBundle();");
            writer.println("\t\ttry {");
            writer.println("\t\t\treturn (bundle!=null ? bundle.getString(key) : key);");
            writer.println("\t\t} catch (MissingResourceException e) {");
            writer.println("\t\t\treturn key;");
            writer.println("\t\t}");
            writer.println("\t}");
            writer.println();
            writer.println("\t/**");
            writer.println("\t * Returns the plugin's resource bundle,");
            writer.println("\t */");
            writer.println("\tpublic ResourceBundle getResourceBundle() {");
            writer.println("\t\treturn resourceBundle;");
            writer.println("\t}");
        }
        writer.println("}");
    }
}

