/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.osgi.templates;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.IExternalModelManager;
import org.eclipse.pde.core.osgi.bundle.IBundle;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.osgi.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.codegen.JavaCodeGenerator;
import org.eclipse.pde.internal.ui.osgi.templates.FirstBundleTemplateWizardPage;
import org.eclipse.pde.internal.ui.osgi.wizards.project.BundleProjectStructurePage;
import org.eclipse.pde.internal.ui.wizards.templates.PreferencePageTemplate;
import org.eclipse.pde.ui.ClasspathUtil;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.pde.ui.IPluginStructureData;
import org.eclipse.pde.ui.IProjectProvider;
import org.eclipse.pde.ui.templates.AbstractTemplateSection;
import org.eclipse.pde.ui.templates.IFieldData;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class AbstractNewBundleTemplateWizard
extends Wizard
implements IPluginContentWizard {
    private static final String KEY_WTITLE = "PluginCodeGeneratorWizard.title";
    private static final String KEY_WFTITLE = "PluginCodeGeneratorWizard.ftitle";
    private static final String KEY_MISSING = "PluginCodeGeneratorWizard.missing";
    private static final String KEY_FMISSING = "PluginCoreGeneratorWizard.fmissing";
    private static final String KEY_GENERATING = "PluginCoreGeneratorWizard.generating";
    private IProjectProvider provider;
    private IPluginStructureData structureData;
    private boolean fragment;
    private FirstBundleTemplateWizardPage firstPage;
    private ITemplateSection[] activeSections;
    private IConfigurationElement config;

    public AbstractNewBundleTemplateWizard() {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWBEXPRJ_WIZ);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IProjectProvider provider, IPluginStructureData structureData, boolean fragment, IConfigurationElement config) {
        this.provider = provider;
        this.structureData = structureData;
        this.fragment = fragment;
        this.config = config;
        this.setWindowTitle(PDEPlugin.getResourceString(fragment ? KEY_WFTITLE : KEY_WTITLE));
    }

    protected abstract ITemplateSection[] getTemplateSections();

    protected abstract void addAdditionalPages();

    public final void addPages() {
        this.firstPage = new FirstBundleTemplateWizardPage(this.provider, this.structureData, this.fragment);
        this.addPage((IWizardPage)this.firstPage);
        this.addAdditionalPages();
    }

    public final boolean performFinish() {
        this.activeSections = this.getTemplateSections();
        final IFieldData data = this.firstPage.createFieldData(this.activeSections);
        int i = 0;
        while (i < this.activeSections.length) {
            if (this.activeSections[i].getLabel().equals("Preference Page")) {
                ((PreferencePageTemplate)this.activeSections[i]).addDefaultOption(data.isThisCheck());
            }
            ++i;
        }
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) throws InterruptedException {
                try {
                    try {
                        AbstractNewBundleTemplateWizard.this.doFinish(data, monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private int computeTotalWork() {
        int totalWork = 5;
        int i = 0;
        while (i < this.activeSections.length) {
            totalWork += this.activeSections[i].getNumberOfWorkUnits();
            ++i;
        }
        return totalWork;
    }

    private void doFinish(IFieldData data, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IEditorDescriptor exeditorId;
        monitor.beginTask(PDEPlugin.getResourceString(KEY_GENERATING), this.computeTotalWork());
        ArrayList dependencies = this.getDependencies(this.structureData.isR3Compatible() ? "3.0" : null);
        if (!this.verifyPluginPath(dependencies)) {
            throw new InterruptedException();
        }
        IProject project = this.provider.getProject();
        BundleProjectStructurePage.createProject(project, this.provider, this.structureData, monitor);
        monitor.worked(1);
        BundleProjectStructurePage.createBuildProperties(project, this.structureData, data.isFragment(), monitor);
        monitor.worked(1);
        BundlePluginModelBase model = this.firstPage.createPluginManifest(project, data, dependencies, monitor);
        monitor.worked(1);
        if (this.structureData.getRuntimeLibraryName() != null) {
            this.setJavaSettings((IPluginModelBase)model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        ArrayList<String> generatedPackages = new ArrayList<String>();
        if (data.getClassName() != null) {
            generatedPackages.add(this.structureData.getPluginId());
        }
        this.executeTemplates(project, (IPluginModelBase)model, generatedPackages, monitor);
        this.setPackages(model, generatedPackages);
        JavaCodeGenerator.ensureFoldersExist(project, "META-INF", "/");
        model.save();
        this.saveTemplateFile(project, monitor);
        monitor.worked(1);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IFile manifestFile = (IFile)model.getBundleModel().getUnderlyingResource();
        IFile extensionsFile = (IFile)model.getExtensionsModel().getUnderlyingResource();
        IEditorRegistry ereg = workbench.getEditorRegistry();
        IEditorDescriptor meditorId = IDE.getDefaultEditor((IFile)manifestFile);
        if (meditorId == null) {
            meditorId = ereg.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if ((exeditorId = IDE.getDefaultEditor((IFile)extensionsFile)) == null) {
            exeditorId = ereg.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (exeditorId != null && extensionsFile.exists()) {
            this.openFile(extensionsFile, exeditorId.getId(), false);
        }
        if (meditorId != null) {
            this.openFile(manifestFile, meditorId.getId(), true);
        }
    }

    private void setJavaSettings(IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        boolean useContainers = PDEPlugin.getUseClasspathContainers();
        ClasspathUtil.setClasspath((IPluginModelBase)model, (boolean)useContainers, (IProgressMonitor)monitor);
    }

    private void setPackages(BundlePluginModelBase model, ArrayList generatedPackages) {
        if (generatedPackages.size() == 0) {
            return;
        }
        StringBuffer provides = new StringBuffer();
        int i = 0;
        while (i < generatedPackages.size()) {
            String packageName = (String)generatedPackages.get(i);
            if (i > 0) {
                provides.append(", ");
            }
            provides.append(packageName);
            ++i;
        }
        IBundle bundle = model.getBundleModel().getBundle();
        try {
            bundle.setHeader("Provide-Package", provides.toString());
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private ArrayList getDependencies(String schemaVersion) {
        ArrayList result = new ArrayList();
        IPluginReference[] list = this.firstPage.getDependencies();
        this.addDependencies(list, result);
        int i = 0;
        while (i < this.activeSections.length) {
            this.addDependencies(this.activeSections[i].getDependencies(schemaVersion), result);
            ++i;
        }
        return result;
    }

    private void addDependencies(IPluginReference[] list, ArrayList result) {
        int i = 0;
        while (i < list.length) {
            IPluginReference reference = list[i];
            if (!result.contains(reference)) {
                result.add(reference);
            }
            ++i;
        }
    }

    private boolean verifyPluginPath(ArrayList dependencies) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        ArrayList<IPluginModelBase> matches = new ArrayList<IPluginModelBase>();
        boolean workspaceModels = false;
        int i = 0;
        while (i < dependencies.size()) {
            IPluginReference ref = (IPluginReference)dependencies.get(i);
            IPluginModelBase model = manager.findPlugin(ref.getId(), ref.getVersion(), ref.getMatch());
            if (model != null) {
                if (model.getUnderlyingResource() != null) {
                    workspaceModels = true;
                    break;
                }
                if (!model.isEnabled()) {
                    matches.add(model);
                }
            }
            ++i;
        }
        if (!workspaceModels && matches.size() > 0) {
            final boolean[] result = new boolean[1];
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (AbstractNewBundleTemplateWizard.this.askToEnable()) {
                        IExternalModelManager mng = PDECore.getDefault().getExternalModelManager();
                        mng.enableAll();
                        result[0] = true;
                    } else {
                        result[0] = false;
                    }
                }
            });
            return result[0];
        }
        return true;
    }

    private boolean askToEnable() {
        String title = this.getWindowTitle();
        String message = PDEPlugin.getResourceString(this.fragment ? KEY_FMISSING : KEY_MISSING);
        MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        return dialog.open() == 0;
    }

    private void executeTemplates(IProject project, IPluginModelBase model, ArrayList generatedPackages, IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < this.activeSections.length) {
            String packageName;
            AbstractTemplateSection asection;
            Object packageValue;
            ITemplateSection section = this.activeSections[i];
            section.execute(project, model, monitor);
            if (section instanceof AbstractTemplateSection && (packageValue = (asection = (AbstractTemplateSection)section).getValue("packageName")) != null && (packageName = packageValue.toString()).length() > 0 && !generatedPackages.contains(packageName)) {
                generatedPackages.add(packageName);
            }
            ++i;
        }
    }

    private void writeTemplateFile(PrintWriter writer) {
        String indent = "   ";
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<form>");
        if (this.activeSections.length > 0) {
            writer.println(String.valueOf(indent) + PDEPlugin.getResourceString("ManifestEditor.TemplatePage.intro"));
            int i = 0;
            while (i < this.activeSections.length) {
                ITemplateSection section = this.activeSections[i];
                String list = "<li style=\"text\" value=\"" + (i + 1) + ".\">";
                writer.println(String.valueOf(indent) + list + "<b>" + section.getLabel() + ".</b>" + section.getDescription() + "</li>");
                ++i;
            }
        }
        writer.println(String.valueOf(indent) + PDEPlugin.getResourceString("ManifestEditor.TemplatePage.common"));
        writer.println("</form>");
    }

    private void saveTemplateFile(IProject project, IProgressMonitor monitor) {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.writeTemplateFile(writer);
        writer.flush();
        try {
            swriter.close();
        }
        catch (IOException iOException) {}
        String contents = swriter.toString();
        IFile file = project.getFile(".template");
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF8"));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, false, null);
            } else {
                file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        catch (IOException iOException) {}
    }

    private void openFile(final IFile file, String editorId, final boolean selectReveal) {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
        final IWorkbenchPage page = ww.getActivePage();
        if (page == null) {
            return;
        }
        Display d = ww.getShell().getDisplay();
        final IWorkbenchPart focusPart = page.getActivePart();
        d.asyncExec(new Runnable(){

            public void run() {
                try {
                    if (focusPart instanceof ISetSelectionTarget && selectReveal) {
                        StructuredSelection selection = new StructuredSelection((Object)file);
                        ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                    }
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)selectReveal);
                }
                catch (PartInitException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
    }
}

