/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.osgi;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.core.osgi.bundle.IBundlePluginBase;
import org.eclipse.pde.core.osgi.bundle.IBundlePluginModel;
import org.eclipse.pde.core.osgi.bundle.IBundlePluginModelBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.osgi.OSGiWorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.swt.graphics.Image;

public class OSGiLabelProvider
extends PDELabelProvider {
    public Image getImage(Object obj) {
        if (obj instanceof IBundlePluginBase) {
            return this.getObjectImage((IBundlePluginBase)obj);
        }
        if (obj instanceof IBundlePluginModelBase) {
            return this.getObjectImage((IBundlePluginBase)((IBundlePluginModelBase)obj).getPluginBase());
        }
        return super.getImage(obj);
    }

    protected ImageDescriptor getRequiredPluginImageDescriptor(IPluginImport iobj) {
        ISharedPluginModel model = iobj.getModel();
        if (model instanceof IBundlePluginModel) {
            return PDEPluginImages.DESC_BUNDLE_OBJ;
        }
        return super.getRequiredPluginImageDescriptor(iobj);
    }

    public Image getObjectImage(IBundlePluginBase bundlePluginBase) {
        return this.getObjectImage(bundlePluginBase, false, false);
    }

    public Image getObjectImage(IBundlePluginBase bundlePluginBase, boolean checkEnabled, boolean javaSearch) {
        IBundlePluginModelBase model = (IBundlePluginModelBase)bundlePluginBase.getModel();
        int flags = this.getModelFlags(model);
        if (javaSearch) {
            flags |= 0x40;
        }
        ImageDescriptor desc = PDEPluginImages.DESC_BUNDLE_OBJ;
        if (model.isFragmentModel()) {
            desc = PDEPluginImages.DESC_BUNDLE_FRAGMENT_OBJ;
        }
        if (checkEnabled) {
            model.isEnabled();
        }
        return this.get(desc, flags);
    }

    private int getModelFlags(IBundlePluginModelBase model) {
        IResource resource;
        int flags = 0;
        if (!model.isLoaded() || !model.isInSync()) {
            flags = 1;
        }
        if ((resource = model.getUnderlyingResource()) == null) {
            flags |= 0x20;
        } else {
            IProject project = resource.getProject();
            try {
                String property;
                if (OSGiWorkspaceModelManager.isBinaryBundleProject((IProject)project) && (property = project.getPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY)) != null) {
                    flags |= 0x10;
                }
            }
            catch (CoreException coreException) {}
        }
        return flags;
    }
}

