/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class WorkbenchLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate,
ILauncherSettings {
    private static final String KEY_BAD_FEATURE_SETUP = "WorkbenchLauncherConfigurationDelegate.badFeatureSetup";
    private static final String KEY_NO_STARTUP = "WorkbenchLauncherConfigurationDelegate.noStartup";
    private File configFile = null;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 3);
            IVMInstall launcher = LauncherUtils.createLauncher(configuration);
            monitor.worked(1);
            VMRunnerConfiguration runnerConfig = this.createVMRunner(configuration);
            if (runnerConfig == null) {
                monitor.setCanceled(true);
                return;
            }
            monitor.worked(1);
            if (this.configFile == null) {
                launch.setAttribute("configLocation", null);
            } else {
                launch.setAttribute("configLocation", this.configFile.isDirectory() ? this.configFile.toString() : this.configFile.getParent());
            }
            String workspace = configuration.getAttribute("location0", LauncherUtils.getDefaultPath().append("runtime-workbench-workspace").toOSString());
            LauncherUtils.clearWorkspace(configuration, workspace);
            LauncherUtils.setDefaultSourceLocator(configuration, launch);
            PDEPlugin.getDefault().getLaunchesListener().manage(launch);
            launcher.getVMRunner(mode).run(runnerConfig, launch, monitor);
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    private VMRunnerConfiguration createVMRunner(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = LauncherUtils.constructClasspath();
        if (classpath == null) {
            String message = PDEPlugin.getResourceString(KEY_NO_STARTUP);
            throw new CoreException(LauncherUtils.createErrorStatus(message));
        }
        String[] programArgs = this.getProgramArguments(configuration);
        if (programArgs == null) {
            return null;
        }
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        VMRunnerConfiguration runnerConfig = new VMRunnerConfiguration("org.eclipse.core.launcher.Main", classpath);
        runnerConfig.setVMArguments(this.getVMArguments(configuration));
        runnerConfig.setProgramArguments(programArgs);
        runnerConfig.setEnvironment(envp);
        return runnerConfig;
    }

    private String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String bootPath;
        ArrayList<String> programArgs = new ArrayList<String>();
        programArgs.add("-pdelaunch");
        String appName = configuration.getAttribute("application", null);
        if (appName != null && appName.length() > 0) {
            programArgs.add("-application");
            programArgs.add(appName);
        }
        String targetWorkspace = configuration.getAttribute("location0", LauncherUtils.getDefaultPath().append("runtime-workbench-workspace").toOSString());
        programArgs.add("-data");
        programArgs.add(targetWorkspace);
        boolean useDefault = configuration.getAttribute("default", true);
        boolean isOSGI = PDECore.getDefault().getModelManager().isOSGiRuntime();
        if (configuration.getAttribute("usefeatures", false)) {
            this.validateFeatures();
            IPath installPath = PDEPlugin.getWorkspace().getRoot().getLocation();
            File installDir = installPath.removeLastSegments(1).toFile();
            programArgs.add("-install");
            programArgs.add("file:" + installDir.getPath() + File.separator);
            programArgs.add("-update");
        } else {
            TreeMap pluginMap = LauncherUtils.validatePlugins(LauncherUtils.getWorkspacePluginsToRun(configuration, useDefault), this.getExternalPluginsToRun(configuration, useDefault));
            if (pluginMap == null) {
                return null;
            }
            programArgs.add("-configuration");
            String primaryFeatureId = this.getPrimaryFeatureId();
            this.configFile = TargetPlatform.createPlatformConfigurationArea((TreeMap)pluginMap, (IPath)new Path(targetWorkspace), (String)primaryFeatureId);
            programArgs.add("file:" + this.configFile.getPath());
            if (primaryFeatureId != null && !isOSGI) {
                programArgs.add("-feature");
                programArgs.add(primaryFeatureId);
            }
        }
        if (LauncherUtils.isBootInSource() && !isOSGI && (bootPath = LauncherUtils.getBootPath()) != null) {
            programArgs.add("-boot");
            programArgs.add("file:" + bootPath);
        }
        programArgs.add("-dev");
        String devEntry = LauncherUtils.getBuildOutputFolders(LauncherUtils.getWorkspacePluginsToRun(configuration, useDefault));
        programArgs.add(configuration.getAttribute("classpath", devEntry));
        if (configuration.getAttribute("tracing", false)) {
            if (this.configFile == null) {
                this.configFile = TargetPlatform.createWorkingDirectory((IPath)new Path(targetWorkspace));
            }
            String directoryName = this.configFile.isDirectory() ? this.configFile.toString() : this.configFile.getParent();
            programArgs.add("-debug");
            programArgs.add(LauncherUtils.getTracingFileArgument(configuration, String.valueOf(directoryName) + '/' + ".options"));
        }
        StringTokenizer tokenizer = new StringTokenizer(configuration.getAttribute("progargs", ""));
        while (tokenizer.hasMoreTokens()) {
            programArgs.add(tokenizer.nextToken());
        }
        if (configuration.getAttribute("showSplash", true)) {
            boolean showSplash = true;
            int index = programArgs.indexOf("-application");
            if (index != -1 && index <= programArgs.size() - 2 && !programArgs.get(index + 1).equals("org.eclipse.ui.workbench") && !programArgs.get(index + 1).equals("org.eclipse.ui.ide.workbench")) {
                showSplash = false;
            }
            if (showSplash) {
                programArgs.add("-showsplash");
                programArgs.add(this.computeShowsplashArgument());
            }
        }
        return programArgs.toArray(new String[programArgs.size()]);
    }

    private String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        return new ExecutionArguments(configuration.getAttribute("vmargs", ""), "").getVMArgumentsArray();
    }

    private void validateFeatures() throws CoreException {
        IPath featuresPath;
        IPath installPath = PDEPlugin.getWorkspace().getRoot().getLocation();
        String lastSegment = installPath.lastSegment();
        boolean badStructure = false;
        if (!lastSegment.equalsIgnoreCase("plugins")) {
            badStructure = true;
        }
        if (!(featuresPath = installPath.removeLastSegments(1).append("features")).toFile().exists()) {
            badStructure = true;
        }
        if (badStructure) {
            throw new CoreException(LauncherUtils.createErrorStatus(PDEPlugin.getResourceString(KEY_BAD_FEATURE_SETUP)));
        }
        this.ensureProductFilesExist(this.getProductPath());
    }

    private IPath getInstallPath() {
        return PDEPlugin.getWorkspace().getRoot().getLocation();
    }

    private IPath getProductPath() {
        return this.getInstallPath().removeLastSegments(1);
    }

    private IPluginModelBase[] getExternalPluginsToRun(ILaunchConfiguration config, boolean useDefault) throws CoreException {
        if (useDefault) {
            return PDECore.getDefault().getExternalModelManager().getAllEnabledModels();
        }
        ArrayList<IPluginModelBase> exList = new ArrayList<IPluginModelBase>();
        TreeSet selectedExModels = LauncherUtils.parseSelectedExtIds(config);
        IPluginModelBase[] exmodels = PDECore.getDefault().getExternalModelManager().getAllModels();
        int i = 0;
        while (i < exmodels.length) {
            String id = exmodels[i].getPluginBase().getId();
            if (id != null && selectedExModels.contains(id)) {
                exList.add(exmodels[i]);
            }
            ++i;
        }
        return exList.toArray(new IPluginModelBase[exList.size()]);
    }

    private String computeShowsplashArgument() {
        IPath eclipseHome = ExternalModelManager.getEclipseHome(null);
        IPath fullPath = eclipseHome.append("eclipse");
        return String.valueOf(fullPath.toOSString()) + " -showsplash 600";
    }

    private String getPrimaryFeatureId() {
        IPath eclipsePath = ExternalModelManager.getEclipseHome(null);
        File iniFile = new File(eclipsePath.toFile(), "install.ini");
        if (!iniFile.exists()) {
            return null;
        }
        Properties pini = new Properties();
        try {
            FileInputStream fis = new FileInputStream(iniFile);
            pini.load(fis);
            fis.close();
            return pini.getProperty("feature.default.id");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void ensureProductFilesExist(IPath productArea) {
        File productDir = productArea.toFile();
        File marker = new File(productDir, ".eclipseproduct");
        File ini = new File(productDir, "install.ini");
        if (marker.exists() && ini.exists()) {
            return;
        }
        IPath eclipsePath = ExternalModelManager.getEclipseHome(null);
        if (!marker.exists()) {
            this.copyFile(eclipsePath, ".eclipseproduct", marker);
        }
        if (!ini.exists()) {
            this.copyFile(eclipsePath, "install.ini", ini);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(IPath eclipsePath, String name, File target) {
        File source = new File(eclipsePath.toFile(), name);
        if (!source.exists()) {
            return;
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            try {
                is = new FileInputStream(source);
                os = new FileOutputStream(target);
                byte[] buf = new byte[1024];
                long currentLen = 0L;
                int len = is.read(buf);
                while (len != -1) {
                    currentLen += (long)len;
                    os.write(buf, 0, len);
                    len = is.read(buf);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (is != null) {
                    is.close();
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var11_12 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (is != null) {
            is.close();
        }
        if (os == null) return;
        os.close();
    }
}

