/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.launcher.TracingLauncherTab;
import org.eclipse.pde.internal.ui.util.ChoicePropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class TracingPropertySource
implements IPropertySource,
IAdaptable {
    private IPluginModelBase fModel;
    private Vector fDescriptors;
    private Hashtable fTemplate;
    private Hashtable fValues;
    private Hashtable fDvalues;
    private static final String[] fBooleanChoices = new String[]{"false", "true"};
    private Properties fMasterOptions;
    private boolean fIsModified;
    private TracingLauncherTab fTab;
    static /* synthetic */ Class class$0;

    public TracingPropertySource(IPluginModelBase model, Properties masterOptions, Hashtable template, TracingLauncherTab tab) {
        this.fModel = model;
        this.fMasterOptions = masterOptions;
        this.fTemplate = template;
        this.fTab = tab;
        this.fValues = new Hashtable();
        this.fDvalues = new Hashtable();
    }

    private PropertyDescriptor createBooleanPropertyDescriptor(String key, String value) {
        ChoicePropertyDescriptor desc = new ChoicePropertyDescriptor(key, key, fBooleanChoices);
        desc.setLabelProvider((ILabelProvider)new BooleanLabelProvider(key));
        return desc;
    }

    private void createDescriptors() {
        this.fDescriptors = new Vector();
        Enumeration enumeration = this.fTemplate.keys();
        while (enumeration.hasMoreElements()) {
            PropertyDescriptor desc;
            String key = (String)enumeration.nextElement();
            Path path = new Path(key);
            path = path.removeFirstSegments(1);
            String shortKey = path.toString().toLowerCase();
            String value = (String)this.fTemplate.get(key);
            String lvalue = null;
            String masterValue = this.fMasterOptions.getProperty(key);
            if (value != null) {
                lvalue = value.toLowerCase();
            }
            if (lvalue != null && (lvalue.equals("true") || lvalue.equals("false"))) {
                desc = this.createBooleanPropertyDescriptor(shortKey, value);
                Integer dvalue = new Integer(lvalue.equals("true") ? 1 : 0);
                this.fDvalues.put(shortKey, dvalue);
                if (masterValue != null) {
                    Integer mvalue = new Integer(masterValue.equals("true") ? 1 : 0);
                    this.fValues.put(shortKey, mvalue);
                }
            } else {
                desc = this.createTextPropertyDescriptor(shortKey, value);
                this.fDvalues.put(shortKey, value != null ? value : "");
                if (masterValue != null) {
                    this.fValues.put(shortKey, masterValue);
                }
            }
            this.fDescriptors.add(desc);
        }
    }

    private PropertyDescriptor createTextPropertyDescriptor(String key, String value) {
        return new TextPropertyDescriptor((Object)key, key);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.views.properties.IPropertySource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.fDescriptors == null) {
            this.createDescriptors();
        }
        return this.fDescriptors.toArray(new IPropertyDescriptor[this.fDescriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        Object value = this.fValues.get(id);
        return value;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void reset() {
        this.fValues = (Hashtable)this.fDvalues.clone();
        this.fIsModified = true;
        this.fTab.updateLaunchConfigurationDialog();
    }

    public void resetPropertyValue(Object id) {
    }

    public void save() {
        String pid = this.fModel.getPluginBase().getId();
        Enumeration enumeration = this.fValues.keys();
        while (enumeration.hasMoreElements()) {
            String shortKey = (String)enumeration.nextElement();
            Object value = this.fValues.get(shortKey);
            String svalue = value.toString();
            if (value instanceof Integer) {
                svalue = fBooleanChoices[(Integer)value];
            }
            IPath path = new Path(pid).append(shortKey);
            this.fMasterOptions.setProperty(path.toString(), svalue);
        }
        this.fIsModified = false;
    }

    public void setPropertyValue(Object id, Object value) {
        this.fValues.put(id, value);
        this.fIsModified = true;
        this.fTab.updateLaunchConfigurationDialog();
    }

    public boolean isModified() {
        return this.fIsModified;
    }

    class BooleanLabelProvider
    extends LabelProvider {
        String id;

        public BooleanLabelProvider(String id) {
            this.id = id;
        }

        public String getText(Object obj) {
            Object value = TracingPropertySource.this.getPropertyValue(this.id);
            if (value instanceof Integer) {
                Integer ivalue = (Integer)value;
                return fBooleanChoices[ivalue];
            }
            return value.toString();
        }
    }
}

