/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.TracingPropertySource;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class TracingLauncherTab
extends AbstractLauncherTab
implements ILauncherSettings {
    private Button fTracingCheck;
    private TableViewer fPluginViewer;
    private IPluginModelBase[] fTraceableModels;
    private Properties fMasterOptions = new Properties();
    private Hashtable fPropertySources = new Hashtable();
    private PropertySheetPage fPropertySheet;
    private Label fPropertyLabel;
    private Image fImage;

    public TracingLauncherTab() {
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fImage = PDEPluginImages.DESC_DOC_SECTION_OBJ.createImage();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Dialog.applyDialogFont((Control)container);
        this.createEnableTracingButton(container);
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.createSashSection(container);
        this.setControl((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.launcher_tracing");
    }

    private void createEnableTracingButton(Composite container) {
        this.fTracingCheck = new Button(container, 32);
        this.fTracingCheck.setText(PDEPlugin.getResourceString("TracingLauncherTab.tracing"));
        this.fTracingCheck.setLayoutData((Object)new GridData(768));
        this.fTracingCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracingLauncherTab.this.masterCheckChanged(true);
                TracingLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createSashSection(Composite container) {
        SashForm sashForm = new SashForm(container, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.createPluginViewer((Composite)sashForm);
        this.createPropertySheetClient((Composite)sashForm);
    }

    private void createPluginViewer(Composite sashForm) {
        Composite composite = new Composite(sashForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(PDEPlugin.getResourceString("TracingLauncherTab.plugins"));
        this.fPluginViewer = new TableViewer(composite, 2048);
        this.fPluginViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fPluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPluginViewer.setSorter((ViewerSorter)new ListUtil.PluginSorter());
        this.fPluginViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                TracingLauncherTab.this.pluginSelected(TracingLauncherTab.this.getSelectedModel());
            }
        });
        GridData gd = new GridData(1808);
        gd.widthHint = 125;
        gd.heightHint = 100;
        this.fPluginViewer.getTable().setLayoutData((Object)gd);
        this.fPluginViewer.setInput((Object)this.getTraceableModels());
    }

    private void createPropertySheetClient(Composite sashForm) {
        Composite tableChild = new Composite(sashForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tableChild.setLayout((Layout)layout);
        this.fPropertyLabel = new Label(tableChild, 0);
        this.fPropertyLabel.setLayoutData((Object)new GridData(768));
        this.updatePropertyLabel(null);
        this.createPropertySheet(tableChild);
    }

    protected void createPropertySheet(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fPropertySheet = new PropertySheetPage();
        this.fPropertySheet.createControl(composite);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        gd.widthHint = 125;
        this.fPropertySheet.getControl().setLayoutData((Object)gd);
        this.fPropertySheet.makeContributions((IMenuManager)new MenuManager(), (IToolBarManager)new ToolBarManager(), null);
    }

    public void dispose() {
        if (this.fPropertySheet != null) {
            this.fPropertySheet.dispose();
        }
        this.fImage.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    private IPluginModelBase[] getTraceableModels() {
        if (this.fTraceableModels == null) {
            PluginModelManager manager = PDECore.getDefault().getModelManager();
            IPluginModelBase[] models = manager.getPlugins();
            ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
            int i = 0;
            while (i < models.length) {
                if (TracingOptionsManager.isTraceable((IPluginModelBase)models[i])) {
                    result.add(models[i]);
                }
                ++i;
            }
            this.fTraceableModels = result.toArray(new IPluginModelBase[result.size()]);
        }
        return this.fTraceableModels;
    }

    private IAdaptable getAdaptable(IPluginModelBase model) {
        if (model == null) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)this.fPropertySources.get(model);
        if (adaptable == null) {
            String id = model.getPluginBase().getId();
            Hashtable defaults = PDECore.getDefault().getTracingOptionsManager().getTemplateTable(id);
            adaptable = new TracingPropertySource(model, this.fMasterOptions, defaults, this);
            this.fPropertySources.put(model, adaptable);
        }
        return adaptable;
    }

    private void masterCheckChanged(boolean userChange) {
        boolean enabled = this.fTracingCheck.getSelection();
        this.fPluginViewer.getTable().setEnabled(enabled);
        this.fPropertySheet.getControl().setEnabled(enabled);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.fMasterOptions.clear();
        this.fPropertySources.clear();
        try {
            this.fTracingCheck.setSelection(config.getAttribute("tracing", false));
            Map options = config.getAttribute("tracingOptions", null);
            options = options == null ? PDECore.getDefault().getTracingOptionsManager().getTracingTemplateCopy() : PDECore.getDefault().getTracingOptionsManager().getTracingOptions(options);
            this.fMasterOptions.putAll((Map<?, ?>)options);
            this.masterCheckChanged(false);
            IPluginModelBase model = this.getLastSelectedPlugin(config);
            if (model != null) {
                this.fPluginViewer.setSelection((ISelection)new StructuredSelection((Object)model));
            } else {
                this.pluginSelected(null);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private IPluginModelBase getLastSelectedPlugin(ILaunchConfiguration config) throws CoreException {
        String pluginID = config.getAttribute("selectedPlugin", null);
        if (pluginID != null) {
            int i = 0;
            while (i < this.fTraceableModels.length) {
                if (this.fTraceableModels[i].getPluginBase().getId().equals(pluginID)) {
                    return this.fTraceableModels[i];
                }
                ++i;
            }
        }
        return null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        boolean tracingEnabled = this.fTracingCheck.getSelection();
        config.setAttribute("tracing", tracingEnabled);
        IPluginModelBase model = this.getSelectedModel();
        String id = model == null ? null : model.getPluginBase().getId();
        config.setAttribute("selectedPlugin", id);
        if (tracingEnabled) {
            boolean changes = false;
            Enumeration enumeration = this.fPropertySources.elements();
            while (enumeration.hasMoreElements()) {
                TracingPropertySource source = (TracingPropertySource)enumeration.nextElement();
                if (!source.isModified()) continue;
                changes = true;
                source.save();
            }
            if (changes) {
                config.setAttribute("tracingOptions", (Map)this.fMasterOptions);
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("tracing", false);
    }

    private void updatePropertyLabel(IPluginModelBase model) {
        String text = model == null ? PDEPlugin.getResourceString("TracingLauncherTab.options") : PDEPlugin.getDefault().getLabelProvider().getText(model);
        this.fPropertyLabel.setText(text);
    }

    private void pluginSelected(IPluginModelBase model) {
        IAdaptable adaptable = this.getAdaptable(model);
        StructuredSelection selection = adaptable != null ? new StructuredSelection((Object)adaptable) : new StructuredSelection();
        this.fPropertySheet.selectionChanged(null, (ISelection)selection);
        this.updatePropertyLabel(model);
    }

    public String getName() {
        return PDEPlugin.getResourceString("TracingLauncherTab.name");
    }

    public Image getImage() {
        return this.fImage;
    }

    private IPluginModelBase getSelectedModel() {
        Object item;
        if (this.fTracingCheck.isEnabled() && (item = ((IStructuredSelection)this.fPluginViewer.getSelection()).getFirstElement()) instanceof IPluginModelBase) {
            return (IPluginModelBase)item;
        }
        return null;
    }
}

