/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PluginPathDialog
extends Dialog {
    private URL[] urls;
    private boolean blockResize;

    public PluginPathDialog(Shell shell, URL[] urls) {
        super(shell);
        this.urls = urls;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        final Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 9;
        layout.marginWidth = 9;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        final Label label = new Label(container, 64);
        label.setText(PDEPlugin.getResourceString("PluginPathDialog.desc"));
        gd = new GridData(768);
        Point lsize = label.computeSize(container.getSize().x, -1, true);
        gd.heightHint = lsize.y;
        label.setLayoutData((Object)gd);
        container.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (PluginPathDialog.this.blockResize) {
                    return;
                }
                int width = container.getSize().x;
                Point lsize = label.computeSize(width -= ((GridLayout)container.getLayout()).marginWidth * 2, -1, true);
                GridData gd = (GridData)label.getLayoutData();
                gd.heightHint = lsize.y;
                PluginPathDialog.this.blockResize = true;
                container.layout();
                PluginPathDialog.this.blockResize = false;
            }
        });
        TableViewer viewer = new TableViewer(container);
        viewer.setContentProvider((IContentProvider)new URLContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new URLLabelProvider());
        gd = new GridData(1808);
        viewer.getControl().setLayoutData((Object)gd);
        viewer.setInput((Object)PDEPlugin.getDefault());
        return container;
    }

    class URLContentProvider
    extends DefaultTableProvider {
        URLContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return PluginPathDialog.this.urls;
        }
    }

    class URLLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        URLLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return ((URL)obj).toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

