/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LauncherUtils {
    private static final String KEY_MISSING_REQUIRED = "WorkbenchLauncherConfigurationDelegate.missingRequired";
    private static final String KEY_BROKEN_PLUGINS = "WorkbenchLauncherConfigurationDelegate.brokenPlugins";
    private static final String KEY_NO_JRE = "WorkbenchLauncherConfigurationDelegate.noJRE";
    private static final String KEY_JRE_PATH_NOT_FOUND = "WorkbenchLauncherConfigurationDelegate.jrePathNotFound";
    private static final String KEY_PROBLEMS_DELETING = "WorkbenchLauncherConfigurationDelegate.problemsDeleting";
    private static final String KEY_TITLE = "WorkbenchLauncherConfigurationDelegate.title";
    private static final String KEY_DELETE_WORKSPACE = "WorkbenchLauncherConfigurationDelegate.confirmDeleteWorkspace";
    private static String bootPath = null;
    private static boolean bootInSource = false;

    public static IVMInstall[] getAllVMInstances() {
        ArrayList<IVMInstall> res = new ArrayList<IVMInstall>();
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstall[] installs = types[i].getVMInstalls();
            int k = 0;
            while (k < installs.length) {
                res.add(installs[k]);
                ++k;
            }
            ++i;
        }
        return res.toArray(new IVMInstall[res.size()]);
    }

    public static String[] getVMInstallNames() {
        IVMInstall[] installs = LauncherUtils.getAllVMInstances();
        String[] names = new String[installs.length];
        int i = 0;
        while (i < installs.length) {
            names[i] = installs[i].getName();
            ++i;
        }
        return names;
    }

    public static String getDefaultVMInstallName() {
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null) {
            return install.getName();
        }
        return null;
    }

    public static IVMInstall getVMInstall(String name) {
        if (name != null) {
            IVMInstall[] installs = LauncherUtils.getAllVMInstances();
            int i = 0;
            while (i < installs.length) {
                if (installs[i].getName().equals(name)) {
                    return installs[i];
                }
                ++i;
            }
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    public static String getDefaultProgramArguments() {
        String os = TargetPlatform.getOS();
        String ws = TargetPlatform.getWS();
        String arch = TargetPlatform.getOSArch();
        String nl = TargetPlatform.getNL();
        return "-os " + os + " -ws " + ws + " -arch " + arch + " -nl " + nl;
    }

    public static String getDefaultWorkspace() {
        return LauncherUtils.getDefaultPath().append("runtime-workspace").toOSString();
    }

    public static IPath getDefaultPath() {
        return PDEPlugin.getWorkspace().getRoot().getLocation().removeLastSegments(1);
    }

    public static TreeSet parseDeselectedWSIds(ILaunchConfiguration config) throws CoreException {
        TreeSet<String> deselected = new TreeSet<String>();
        String ids = config.getAttribute("wsproject", null);
        if (ids != null) {
            StringTokenizer tok = new StringTokenizer(ids, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                deselected.add(tok.nextToken());
            }
        }
        return deselected;
    }

    public static TreeSet parseSelectedExtIds(ILaunchConfiguration config) throws CoreException {
        TreeSet<String> selected = new TreeSet<String>();
        String ids = config.getAttribute("extplugins", null);
        if (ids != null) {
            StringTokenizer tok = new StringTokenizer(ids, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int loc = token.lastIndexOf(44);
                if (loc == -1) {
                    selected.add(token);
                    continue;
                }
                if (token.charAt(loc + 1) != 't') continue;
                selected.add(token.substring(0, loc));
            }
        }
        return selected;
    }

    public static String[] constructClasspath() throws CoreException {
        String[] stringArray;
        File startupJar;
        IProject project;
        IPlugin plugin = PDECore.getDefault().findPlugin("org.eclipse.platform");
        if (plugin != null && plugin.getModel() instanceof WorkspacePluginModel && (project = plugin.getModel().getUnderlyingResource().getProject()).hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject jProject = JavaCore.create((IProject)project);
            IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1) {
                    IPath path = jProject.getOutputLocation().removeFirstSegments(1);
                    return new String[]{project.getLocation().append(path).toOSString()};
                }
                ++i;
            }
        }
        if ((startupJar = ExternalModelManager.getEclipseHome(null).append("startup.jar").toFile()).exists()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = startupJar.getAbsolutePath();
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    protected static IPluginModelBase[] getWorkspacePluginsToRun(ILaunchConfiguration config, boolean useDefault) throws CoreException {
        IPluginModelBase[] wsmodels = PDECore.getDefault().getWorkspaceModelManager().getAllModels();
        if (useDefault) {
            return wsmodels;
        }
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        TreeSet deselectedWSPlugins = LauncherUtils.parseDeselectedWSIds(config);
        int i = 0;
        while (i < wsmodels.length) {
            String id = wsmodels[i].getPluginBase().getId();
            if (id != null && !deselectedWSPlugins.contains(id)) {
                result.add(wsmodels[i]);
            }
            ++i;
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public static String getBuildOutputFolders(IPluginModelBase[] wsmodels) {
        ArrayList<Path> result = new ArrayList<Path>();
        result.add(new Path("bin"));
        int i = 0;
        while (i < wsmodels.length) {
            LauncherUtils.addOutputLocations(result, wsmodels[i]);
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < result.size()) {
            buffer.append(result.get(i2).toString());
            if (i2 < result.size() - 1) {
                buffer.append(",");
            }
            ++i2;
        }
        return buffer.toString();
    }

    private static void addOutputLocations(ArrayList result, IPluginModelBase model) {
        IProject project = model.getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                LauncherUtils.addPath(result, jProject.getOutputLocation());
                IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        LauncherUtils.addPath(result, roots[i].getRawClasspathEntry().getOutputLocation());
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
    }

    private static void addPath(ArrayList result, IPath path) {
        if (path != null && path.segmentCount() > 1 && !result.contains(path = path.removeFirstSegments(1))) {
            result.add(path);
        }
    }

    public static TreeMap validatePlugins(IPluginModelBase[] wsmodels, IPluginModelBase[] exmodels) throws CoreException {
        MultiStatus multiStatus;
        bootPath = null;
        bootInSource = false;
        TreeMap<String, IPluginModelBase> result = new TreeMap<String, IPluginModelBase>();
        ArrayList<IStatus> statusEntries = new ArrayList<IStatus>();
        int i = 0;
        while (i < wsmodels.length) {
            IStatus status = LauncherUtils.validateModel(wsmodels[i]);
            if (status == null) {
                String id = wsmodels[i].getPluginBase().getId();
                if (id != null) {
                    result.put(id, wsmodels[i]);
                }
            } else {
                statusEntries.add(status);
            }
            ++i;
        }
        i = 0;
        while (i < exmodels.length) {
            String id = exmodels[i].getPluginBase().getId();
            if (id != null && !result.containsKey(id)) {
                result.put(id, exmodels[i]);
            }
            ++i;
        }
        StringBuffer errorText = new StringBuffer();
        bootPath = LauncherUtils.getBootPath((IPluginModelBase)result.get("org.eclipse.core.boot"));
        boolean isOSGI = PDECore.getDefault().getModelManager().isOSGiRuntime();
        final String lineSeparator = System.getProperty("line.separator");
        if (bootPath == null && !isOSGI) {
            errorText.append("org.eclipse.core.boot" + lineSeparator);
        }
        if (isOSGI) {
            if (!result.containsKey("org.eclipse.osgi")) {
                errorText.append("org.eclipse.osgi" + lineSeparator);
            }
            if (!result.containsKey("org.eclipse.osgi.services")) {
                errorText.append("org.eclipse.osgi.services" + lineSeparator);
            }
            if (!result.containsKey("org.eclipse.osgi.util")) {
                errorText.append("org.eclipse.osgi.util" + lineSeparator);
            }
            if (!result.containsKey("org.eclipse.core.runtime")) {
                errorText.append("org.eclipse.core.runtime" + lineSeparator);
            }
            if (!result.containsKey("org.eclipse.update.configurator")) {
                errorText.append("org.eclipse.update.configurator");
            }
        }
        if (errorText.length() > 0) {
            final String text = errorText.toString();
            final Display display = LauncherUtils.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)PDEPlugin.getResourceString(LauncherUtils.KEY_TITLE), (String)(String.valueOf(PDEPlugin.getResourceString(LauncherUtils.KEY_MISSING_REQUIRED)) + lineSeparator + text));
                }
            });
            return null;
        }
        if (statusEntries.size() > 0 && !LauncherUtils.ignoreValidationErrors(multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, statusEntries.toArray(new IStatus[statusEntries.size()]), PDEPlugin.getResourceString(KEY_BROKEN_PLUGINS), null))) {
            return null;
        }
        return result;
    }

    private static IStatus validateModel(IPluginModelBase model) {
        return model.isLoaded() ? null : new Status(2, PDEPlugin.getPluginId(), 0, model.getPluginBase().getId(), null);
    }

    private static String getBootPath(IPluginModelBase bootModel) {
        if (bootModel == null) {
            return null;
        }
        try {
            IResource resource = bootModel.getUnderlyingResource();
            if (resource != null) {
                IProject project = resource.getProject();
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    resource = project.findMember("boot.jar");
                    if (resource != null) {
                        return "file:" + resource.getLocation().toOSString();
                    }
                    IPath path = JavaCore.create((IProject)project).getOutputLocation();
                    if (path != null) {
                        bootInSource = true;
                        IPath sourceBootPath = project.getParent().getLocation().append(path);
                        return sourceBootPath.addTrailingSeparator().toOSString();
                    }
                }
            } else {
                File binDir = new File(bootModel.getInstallLocation(), "bin/");
                if (binDir.exists()) {
                    return binDir.getAbsolutePath();
                }
                File bootJar = new File(bootModel.getInstallLocation(), "boot.jar");
                if (bootJar.exists()) {
                    return "file:" + bootJar.getAbsolutePath();
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private static boolean ignoreValidationErrors(final MultiStatus status) {
        final boolean[] result = new boolean[1];
        LauncherUtils.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = MessageDialog.openConfirm((Shell)LauncherUtils.getDisplay().getActiveShell(), (String)PDEPlugin.getResourceString(LauncherUtils.KEY_TITLE), (String)status.getMessage());
            }
        });
        return result[0];
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static boolean isBootInSource() {
        return bootInSource;
    }

    public static String getBootPath() {
        return bootPath;
    }

    public static IVMInstall createLauncher(ILaunchConfiguration configuration) throws CoreException {
        String vm = configuration.getAttribute("vminstall", null);
        IVMInstall launcher = LauncherUtils.getVMInstall(vm);
        if (launcher == null) {
            throw new CoreException(LauncherUtils.createErrorStatus(PDEPlugin.getFormattedMessage(KEY_NO_JRE, vm)));
        }
        if (!launcher.getInstallLocation().exists()) {
            throw new CoreException(LauncherUtils.createErrorStatus(PDEPlugin.getResourceString(KEY_JRE_PATH_NOT_FOUND)));
        }
        return launcher;
    }

    public static IStatus createErrorStatus(String message) {
        return new Status(4, PDEPlugin.getPluginId(), 0, message, null);
    }

    public static void setDefaultSourceLocator(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        String id = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        if (id == null) {
            IPersistableSourceLocator locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(JavaUISourceLocator.ID_PROMPTING_JAVA_SOURCE_LOCATOR);
            ILaunchConfigurationWorkingCopy wc = null;
            wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, JavaUISourceLocator.ID_PROMPTING_JAVA_SOURCE_LOCATOR);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
            locator.initializeDefaults((ILaunchConfiguration)wc);
            wc.doSave();
            launch.setSourceLocator((ISourceLocator)locator);
        }
    }

    public static void clearWorkspace(ILaunchConfiguration configuration, String workspace) throws CoreException {
        File workspaceFile = new Path(workspace).toFile();
        if (configuration.getAttribute("clearws", false) && workspaceFile.exists() && (!configuration.getAttribute("askclear", true) || LauncherUtils.confirmDeleteWorkspace(workspaceFile))) {
            try {
                LauncherUtils.deleteContent(workspaceFile);
            }
            catch (IOException iOException) {
                LauncherUtils.showWarningDialog(PDEPlugin.getResourceString(KEY_PROBLEMS_DELETING));
            }
        }
    }

    private static void showWarningDialog(final String message) {
        LauncherUtils.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = PDEPlugin.getResourceString(LauncherUtils.KEY_TITLE);
                MessageDialog.openWarning((Shell)LauncherUtils.getDisplay().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    private static boolean confirmDeleteWorkspace(final File workspaceFile) {
        final boolean[] result = new boolean[1];
        LauncherUtils.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = PDEPlugin.getResourceString(LauncherUtils.KEY_TITLE);
                String message = PDEPlugin.getFormattedMessage(LauncherUtils.KEY_DELETE_WORKSPACE, workspaceFile.getPath());
                result[0] = MessageDialog.openQuestion((Shell)LauncherUtils.getDisplay().getActiveShell(), (String)title, (String)message);
            }
        });
        return result[0];
    }

    private static void deleteContent(File curr) throws IOException {
        File[] children;
        if (curr.isDirectory() && (children = curr.listFiles()) != null) {
            int i = 0;
            while (i < children.length) {
                LauncherUtils.deleteContent(children[i]);
                ++i;
            }
        }
        curr.delete();
    }

    public static String getTracingFileArgument(ILaunchConfiguration config, String optionsFileName) throws CoreException {
        try {
            TracingOptionsManager mng = PDECore.getDefault().getTracingOptionsManager();
            Map options = config.getAttribute("tracingOptions", null);
            mng.save(optionsFileName, options);
        }
        catch (CoreException coreException) {
            return "";
        }
        String tracingArg = "\"file:" + optionsFileName + "\"";
        if (SWT.getPlatform().equals("motif")) {
            tracingArg = "file:" + optionsFileName;
        } else if (SWT.getPlatform().equals("gtk")) {
            tracingArg = "file://localhost" + optionsFileName;
        }
        return tracingArg;
    }
}

