/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LaunchListener
implements ILaunchListener,
IDebugEventSetListener {
    private ArrayList managedLaunches = new ArrayList();

    public void manage(ILaunch launch) {
        if (this.managedLaunches.size() == 0) {
            this.hookListener(true);
        }
        if (!this.managedLaunches.contains(launch)) {
            this.managedLaunches.add(launch);
        }
    }

    public void launchRemoved(ILaunch launch) {
        this.update(launch, true);
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    private void update(ILaunch launch, boolean remove) {
        if (this.managedLaunches.contains(launch) && (remove || launch.isTerminated())) {
            this.managedLaunches.remove(launch);
            if (this.managedLaunches.size() == 0) {
                this.hookListener(false);
            }
        }
    }

    private void hookListener(boolean add) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        ILaunchManager launchManager = debugPlugin.getLaunchManager();
        if (add) {
            launchManager.addLaunchListener((ILaunchListener)this);
            debugPlugin.addDebugEventListener((IDebugEventSetListener)this);
        } else {
            launchManager.removeLaunchListener((ILaunchListener)this);
            debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
        }
    }

    private void doRestart(ILaunch launch) {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        try {
            config.launch(launch.getLaunchMode(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void shutdown() {
        this.hookListener(false);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IProcess process;
            ILaunch launch;
            DebugEvent event = events[i];
            Object source = event.getSource();
            if (source instanceof IProcess && event.getKind() == 8 && (launch = (process = (IProcess)source).getLaunch()) != null) {
                try {
                    this.launchTerminated(launch, process.getExitValue());
                }
                catch (DebugException debugException) {}
            }
            ++i;
        }
    }

    private void launchTerminated(ILaunch launch, int returnValue) {
        if (this.managedLaunches.contains(launch)) {
            String configDir;
            this.update(launch, true);
            if (returnValue == 23) {
                this.doRestart(launch);
                return;
            }
            if (returnValue == 15) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("Launcher.error.title"), (String)PDEPlugin.getResourceString("Launcher.error.code15"));
                    }
                });
                return;
            }
            if (returnValue == 13) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("Launcher.error.title"), (String)PDEPlugin.getResourceString("Launcher.error.code13"));
                    }
                });
            }
            if ((configDir = launch.getAttribute("configLocation")) != null) {
                this.deleteConfig(new File(configDir));
            }
        }
    }

    private void deleteConfig(File file) {
        File[] children;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            int i = 0;
            while (i < children.length) {
                this.deleteConfig(children[i]);
                ++i;
            }
        }
        file.delete();
    }
}

