/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class JUnitWorkbenchShortcut
extends JUnitLaunchShortcut {
    protected ILaunchConfigurationType getJUnitLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.pde.ui.JunitLaunchConfig");
    }

    protected ILaunchConfiguration createConfiguration(IJavaProject project, String name, String mainType, String container, String testName) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getJUnitLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name));
            wc.setAttribute("application", this.getApplicationName());
            wc.setAttribute("location0", this.getDefaultWorkspaceLocation());
            wc.setAttribute("vmargs", "");
            wc.setAttribute("progargs", LauncherUtils.getDefaultProgramArguments());
            wc.setAttribute("default", true);
            wc.setAttribute("clearws", true);
            wc.setAttribute("askclear", false);
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, JavaUISourceLocator.ID_PROMPTING_JAVA_SOURCE_LOCATOR);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getElementName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
            wc.setAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
            wc.setAttribute("org.eclipse.jdt.junit.CONTAINER", container);
            if (testName.length() > 0) {
                wc.setAttribute("org.eclipse.jdt.junit.TESTNAME", testName);
            }
            config = wc.doSave();
        }
        catch (CoreException ce) {
            PDEPlugin.log(ce);
        }
        return config;
    }

    protected String getApplicationName() {
        return "org.eclipse.pde.junit.runtime.uitestapplication";
    }

    protected String getDefaultWorkspaceLocation() {
        return LauncherUtils.getDefaultPath().append("junit-workbench-workspace").toOSString();
    }
}

