/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.launcher.JUnitBaseLaunchConfiguration;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.RegistryLoader;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class JUnitLaunchConfiguration
extends JUnitBaseLaunchConfiguration
implements ILauncherSettings {
    private static final String KEY_NO_STARTUP = "WorkbenchLauncherConfigurationDelegate.noStartup";
    public static final String CORE_APPLICATION = "org.eclipse.pde.junit.runtime.coretestapplication";
    public static final String UI_APPLICATION = "org.eclipse.pde.junit.runtime.uitestapplication";
    public static final String LEGACY_UI_APPLICATION = "org.eclipse.pde.junit.runtime.legacyUItestapplication";
    private static IPluginModelBase[] registryPlugins;
    private File configFile = null;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            IType[] testTypes;
            monitor.beginTask("", 4);
            IJavaProject javaProject = this.getJavaProject(configuration);
            if (javaProject == null || !javaProject.exists()) {
                this.abort(PDEPlugin.getResourceString("JUnitLaunchConfiguration.error.invalidproject"), null, 107);
            }
            if ((testTypes = this.getTestTypes(configuration, javaProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1))).length == 0) {
                this.abort(PDEPlugin.getResourceString("JUnitLaunchConfiguration.error.notests"), null, 101);
            }
            monitor.worked(1);
            IVMInstall launcher = LauncherUtils.createLauncher(configuration);
            monitor.worked(1);
            int port = SocketUtil.findFreePort();
            VMRunnerConfiguration runnerConfig = this.createVMRunner(configuration, testTypes, port, mode);
            if (runnerConfig == null) {
                monitor.setCanceled(true);
                return;
            }
            monitor.worked(1);
            launch.setAttribute("configLocation", this.configFile == null ? null : this.configFile.getParent());
            String workspace = configuration.getAttribute("location0", this.getDefaultWorkspace(configuration));
            LauncherUtils.clearWorkspace(configuration, workspace);
            this.setDefaultSourceLocator(launch, configuration);
            launch.setAttribute("org.eclipse.jdt.junit.PORT", Integer.toString(port));
            launch.setAttribute("org.eclipse.jdt.junit.TESTTYPE", testTypes[0].getHandleIdentifier());
            PDEPlugin.getDefault().getLaunchesListener().manage(launch);
            launcher.getVMRunner(mode).run(runnerConfig, launch, monitor);
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    protected VMRunnerConfiguration createVMRunner(ILaunchConfiguration configuration, IType[] testTypes, int port, String runMode) throws CoreException {
        String[] programArgs;
        String[] classpath = LauncherUtils.constructClasspath();
        if (classpath == null) {
            this.abort(PDEPlugin.getResourceString(KEY_NO_STARTUP), null, 0);
        }
        if ((programArgs = this.computeProgramArguments(configuration, testTypes, port, runMode)) == null) {
            return null;
        }
        String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
        VMRunnerConfiguration runnerConfig = new VMRunnerConfiguration("org.eclipse.core.launcher.Main", classpath);
        runnerConfig.setVMArguments(this.computeVMArguments(configuration));
        runnerConfig.setProgramArguments(programArgs);
        runnerConfig.setEnvironment(envp);
        return runnerConfig;
    }

    protected String getTestPluginId(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        IWorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
        IPluginModelBase model = (IPluginModelBase)manager.getWorkspaceModel(javaProject.getProject());
        if (model == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", 4, PDEPlugin.getResourceString("JUnitLaunchConfiguration.error.notaplugin"), null));
        }
        return model.getPluginBase().getId();
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", code, message, exception));
    }

    private String[] computeProgramArguments(ILaunchConfiguration configuration, IType[] testTypes, int port, String runMode) throws CoreException {
        String bootPath;
        ArrayList<String> programArgs = new ArrayList<String>();
        boolean useDefault = configuration.getAttribute("default", true);
        TreeMap pluginMap = LauncherUtils.validatePlugins(LauncherUtils.getWorkspacePluginsToRun(configuration, useDefault), this.getExternalPluginsToRun(configuration, useDefault));
        if (pluginMap == null) {
            return null;
        }
        this.addRequiredPlugins(pluginMap);
        programArgs.add("-application");
        programArgs.add(this.getApplicationName(pluginMap, configuration));
        String testApplication = configuration.getAttribute("testApplication", null);
        if (testApplication != null && testApplication.length() > 0) {
            programArgs.add("-testApplication");
            programArgs.add(testApplication);
        }
        String targetWorkspace = configuration.getAttribute("location0", this.getDefaultWorkspace(configuration));
        programArgs.add("-data");
        programArgs.add(targetWorkspace);
        programArgs.add("-configuration");
        String primaryFeatureId = this.getPrimaryFeatureId();
        this.configFile = TargetPlatform.createPlatformConfigurationArea((TreeMap)pluginMap, (IPath)new Path(targetWorkspace), (String)primaryFeatureId);
        programArgs.add("file:" + this.configFile.getPath());
        if (primaryFeatureId != null) {
            programArgs.add("-feature");
            programArgs.add(primaryFeatureId);
        }
        if (LauncherUtils.isBootInSource() && (bootPath = LauncherUtils.getBootPath()) != null) {
            programArgs.add("-boot");
            programArgs.add("file:" + bootPath);
        }
        programArgs.add("-dev");
        String devEntry = LauncherUtils.getBuildOutputFolders(LauncherUtils.getWorkspacePluginsToRun(configuration, useDefault));
        programArgs.add(configuration.getAttribute("classpath", devEntry));
        if (configuration.getAttribute("tracing", false)) {
            programArgs.add("-debug");
            programArgs.add(LauncherUtils.getTracingFileArgument(configuration, String.valueOf(this.configFile.getParent()) + '/' + ".options"));
        }
        StringTokenizer tokenizer = new StringTokenizer(configuration.getAttribute("progargs", ""));
        while (tokenizer.hasMoreTokens()) {
            programArgs.add(tokenizer.nextToken());
        }
        if (this.keepAlive(configuration) && runMode.equals("debug")) {
            programArgs.add("-keepalive");
        }
        programArgs.add("-consolelog");
        programArgs.add("-port");
        programArgs.add(Integer.toString(port));
        programArgs.add("-testpluginname");
        programArgs.add(this.getTestPluginId(configuration));
        String testName = configuration.getAttribute("org.eclipse.jdt.junit.TESTNAME", "");
        if (testName.length() > 0) {
            programArgs.add("-test");
            programArgs.add(String.valueOf(testTypes[0].getFullyQualifiedName()) + ":" + testName);
        } else {
            programArgs.add("-classnames");
            int i = 0;
            while (i < testTypes.length) {
                programArgs.add(testTypes[i].getFullyQualifiedName());
                ++i;
            }
        }
        return programArgs.toArray(new String[programArgs.size()]);
    }

    private IPluginModelBase[] addRequiredPlugins(TreeMap pluginMap) throws CoreException {
        if (!pluginMap.containsKey("org.eclipse.pde.junit.runtime")) {
            pluginMap.put("org.eclipse.pde.junit.runtime", this.findPlugin("org.eclipse.pde.junit.runtime"));
        }
        if (!pluginMap.containsKey("org.eclipse.jdt.junit.runtime")) {
            pluginMap.put("org.eclipse.jdt.junit.runtime", this.findPlugin("org.eclipse.jdt.junit.runtime"));
        }
        if (!pluginMap.containsKey("org.junit")) {
            pluginMap.put("org.junit", this.findPlugin("org.junit"));
        }
        return pluginMap.values().toArray(new IPluginModelBase[pluginMap.size()]);
    }

    private IPluginModelBase findPlugin(String id) throws CoreException {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        IPluginModelBase model = manager.findPlugin(id, null, 0);
        if (model != null) {
            return model;
        }
        if (registryPlugins == null) {
            String[] pluginPaths = PluginPathFinder.getPluginPaths((String)BootLoader.getInstallURL().getFile());
            Vector models = new Vector();
            RegistryLoader.loadFromDirectories(models, new Vector(), (String[])pluginPaths, (boolean)false, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
            registryPlugins = models.toArray(new IPluginModelBase[models.size()]);
        }
        int i = 0;
        while (i < registryPlugins.length) {
            if (registryPlugins[i].getPluginBase().getId().equals(id)) {
                return registryPlugins[i];
            }
            ++i;
        }
        this.abort(PDEPlugin.getFormattedMessage("JUnitLaunchConfiguration.error.missingPlugin", id), null, 0);
        return null;
    }

    private String[] computeVMArguments(ILaunchConfiguration configuration) throws CoreException {
        return new ExecutionArguments(this.getVMArguments(configuration), "").getVMArgumentsArray();
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("progargs", "");
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("vmargs", "");
    }

    protected void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        LauncherUtils.setDefaultSourceLocator(configuration, launch);
    }

    private String getPrimaryFeatureId() {
        IPath eclipsePath = ExternalModelManager.getEclipseHome(null);
        File iniFile = new File(eclipsePath.toFile(), "install.ini");
        if (!iniFile.exists()) {
            return null;
        }
        Properties pini = new Properties();
        try {
            FileInputStream fis = new FileInputStream(iniFile);
            pini.load(fis);
            fis.close();
            return pini.getProperty("feature.default.id");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private IPluginModelBase[] getExternalPluginsToRun(ILaunchConfiguration config, boolean useDefault) throws CoreException {
        if (useDefault) {
            return PDECore.getDefault().getExternalModelManager().getAllEnabledModels();
        }
        ArrayList<IPluginModelBase> exList = new ArrayList<IPluginModelBase>();
        TreeSet selectedExModels = LauncherUtils.parseSelectedExtIds(config);
        IPluginModelBase[] exmodels = PDECore.getDefault().getExternalModelManager().getAllModels();
        int i = 0;
        while (i < exmodels.length) {
            String id = exmodels[i].getPluginBase().getId();
            if (id != null && selectedExModels.contains(id)) {
                exList.add(exmodels[i]);
            }
            ++i;
        }
        return exList.toArray(new IPluginModelBase[exList.size()]);
    }

    private String getDefaultWorkspace(ILaunchConfiguration config) throws CoreException {
        if (config.getAttribute("application", UI_APPLICATION).equals(UI_APPLICATION)) {
            return LauncherUtils.getDefaultPath().append("junit-workbench-workspace").toOSString();
        }
        return LauncherUtils.getDefaultPath().append("junit-core-workspace").toOSString();
    }

    private String getApplicationName(TreeMap pluginMap, ILaunchConfiguration config) throws CoreException {
        String application = config.getAttribute("application", null);
        if (CORE_APPLICATION.equals(application)) {
            return CORE_APPLICATION;
        }
        IPluginModelBase model = (IPluginModelBase)pluginMap.get("org.eclipse.ui");
        if (model != null) {
            IPluginExtension[] extensions = model.getPluginBase().getExtensions();
            int i = 0;
            while (i < extensions.length) {
                String point = extensions[i].getPoint();
                if (point != null && point.equals("org.eclipse.core.runtime.applications") && "workbench".equals(extensions[i].getId())) {
                    return LEGACY_UI_APPLICATION;
                }
                ++i;
            }
        }
        return UI_APPLICATION;
    }
}

