/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.BasicLauncherTab;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JUnitArgumentsTab
extends BasicLauncherTab {
    private Combo fApplicationCombo;
    private Label fApplicationLabel;
    private Button fRequiresUI;

    protected void createApplicationSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Test Application");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.fRequiresUI = new Button((Composite)group, 32);
        this.fRequiresUI.setText("&Plug-in Tests require a user interface");
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.fRequiresUI.setLayoutData((Object)gd);
        this.fRequiresUI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JUnitArgumentsTab.this.fApplicationLabel.setEnabled(JUnitArgumentsTab.this.fRequiresUI.getSelection());
                JUnitArgumentsTab.this.fApplicationCombo.setEnabled(JUnitArgumentsTab.this.fRequiresUI.getSelection());
                JUnitArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fApplicationLabel = new Label((Composite)group, 0);
        this.fApplicationLabel.setText(PDEPlugin.getResourceString("JUnitArgumentsTab.applicationName"));
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.fApplicationLabel.setLayoutData((Object)gd);
        this.fApplicationCombo = new Combo((Composite)group, 12);
        this.fApplicationCombo.setItems(this.getApplicationNames());
        this.fApplicationCombo.setLayoutData((Object)new GridData(768));
        this.fApplicationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JUnitArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void initializeApplicationSection(ILaunchConfiguration config) throws CoreException {
        String junitApplication = config.getAttribute("application", "org.eclipse.pde.junit.runtime.uitestapplication");
        this.fRequiresUI.setSelection(junitApplication.equals("org.eclipse.pde.junit.runtime.uitestapplication"));
        this.fApplicationLabel.setEnabled(this.fRequiresUI.getSelection());
        this.fApplicationCombo.setEnabled(this.fRequiresUI.getSelection());
        String testApplication = config.getAttribute("testApplication", null);
        if (testApplication == null || testApplication.equals("") || this.fApplicationCombo.indexOf(testApplication) == -1) {
            int index = this.fApplicationCombo.indexOf("org.eclipse.ui.ide.workbench");
            if (index == -1) {
                index = this.fApplicationCombo.indexOf("org.eclipse.ui.workbench");
            }
            if (index != -1) {
                this.fApplicationCombo.setText(this.fApplicationCombo.getItem(index));
            } else if (this.fApplicationCombo.getItemCount() > 0) {
                this.fApplicationCombo.setText(this.fApplicationCombo.getItem(0));
            }
        } else {
            this.fApplicationCombo.setText(testApplication);
        }
    }

    protected void doRestoreDefaults() {
        super.doRestoreDefaults();
        this.fRequiresUI.setSelection(true);
        this.fApplicationLabel.setEnabled(true);
        this.fApplicationCombo.setEnabled(true);
    }

    protected void saveApplicationSection(ILaunchConfigurationWorkingCopy config) {
        try {
            if (this.fRequiresUI.getSelection()) {
                config.setAttribute("application", "org.eclipse.pde.junit.runtime.uitestapplication");
                String text = this.fApplicationCombo.getText();
                if (config.getAttribute("testApplication", null) != null || !text.equals("org.eclipse.ui.workbench") && !text.equals("org.eclipse.ui.ide.workbench")) {
                    config.setAttribute("testApplication", this.fApplicationCombo.getText());
                }
            } else {
                config.setAttribute("application", "org.eclipse.pde.junit.runtime.coretestapplication");
            }
        }
        catch (CoreException coreException) {}
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("location0", LauncherUtils.getDefaultPath().append("runtime-test-workspace").toOSString());
        config.setAttribute("clearws", true);
        config.setAttribute("progargs", LauncherUtils.getDefaultProgramArguments());
        config.setAttribute("askclear", false);
        config.setAttribute("vmargs", "");
    }

    private String[] getApplicationNames() {
        TreeSet<String> result = new TreeSet<String>();
        IPluginModelBase[] plugins = PDECore.getDefault().getModelManager().getPlugins();
        int i = 0;
        while (i < plugins.length) {
            IPluginExtension[] extensions = plugins[i].getPluginBase().getExtensions();
            int j = 0;
            while (j < extensions.length) {
                String id;
                String point = extensions[j].getPoint();
                if (point != null && point.equals("org.eclipse.core.runtime.applications") && (id = String.valueOf(extensions[j].getPluginBase().getId()) + "." + extensions[j].getId()) != null && !id.startsWith("org.eclipse.pde.junit.runtime")) {
                    result.add(id);
                }
                ++j;
            }
            ++i;
        }
        if (result.contains("org.eclipse.ui.workbench")) {
            result.clear();
            result.add("org.eclipse.ui.workbench");
        }
        return result.toArray(new String[result.size()]);
    }
}

