/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.pde.internal.ui.launcher.PluginPathDialog;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class AdvancedLauncherTab
extends AbstractLauncherTab
implements ILaunchConfigurationTab,
ILauncherSettings {
    private Button fUseDefaultRadio;
    private Button fUseFeaturesRadio;
    private Button fUseListRadio;
    private CheckboxTreeViewer fPluginTreeViewer;
    private Label fVisibleLabel;
    private NamedElement fWorkspacePlugins;
    private NamedElement fExternalPlugins;
    private IPluginModelBase[] fExternalModels;
    private IPluginModelBase[] fWorkspaceModels;
    private Button fDefaultsButton;
    private Button fPluginPathButton;
    private int fNumExternalChecked = 0;
    private int fNumWorkspaceChecked = 0;
    private Image fImage;
    private boolean fShowFeatures = true;

    public AdvancedLauncherTab() {
        this(true);
    }

    public AdvancedLauncherTab(boolean showFeatures) {
        this.fShowFeatures = showFeatures;
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fImage = PDEPluginImages.DESC_REQ_PLUGINS_OBJ.createImage();
        this.fExternalModels = PDECore.getDefault().getExternalModelManager().getAllModels();
        this.fWorkspaceModels = PDECore.getDefault().getWorkspaceModelManager().getAllModels();
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        this.fImage.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createStartingSpace(composite, 1);
        this.fUseDefaultRadio = new Button(composite, 16);
        this.fUseDefaultRadio.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.useDefault"));
        if (this.fShowFeatures) {
            this.fUseFeaturesRadio = new Button(composite, 16);
            this.fUseFeaturesRadio.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.useFeatures"));
        }
        this.fUseListRadio = new Button(composite, 16);
        this.fUseListRadio.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.useList"));
        this.fVisibleLabel = new Label(composite, 0);
        this.fVisibleLabel.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.visibleList"));
        Control list = this.createPluginList(composite);
        list.setLayoutData((Object)new GridData(1808));
        Composite buttonContainer = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 10;
        buttonContainer.setLayout((Layout)layout);
        buttonContainer.setLayoutData((Object)new GridData(128));
        this.fDefaultsButton = new Button(buttonContainer, 8);
        this.fDefaultsButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.defaults"));
        this.fDefaultsButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fDefaultsButton);
        this.fPluginPathButton = new Button(buttonContainer, 8);
        this.fPluginPathButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.pluginPath"));
        this.fPluginPathButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fPluginPathButton);
        this.hookListeners();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.pde.doc.user.launcher_advanced");
    }

    private void hookListeners() {
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.useDefaultChanged();
            }
        };
        this.fUseDefaultRadio.addSelectionListener((SelectionListener)adapter);
        if (this.fShowFeatures) {
            this.fUseFeaturesRadio.addSelectionListener((SelectionListener)adapter);
        }
        this.fDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.computeInitialCheckState();
                AdvancedLauncherTab.this.updateStatus();
            }
        });
        this.fPluginPathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.showPluginPaths();
            }
        });
    }

    private void useDefaultChanged() {
        this.adjustCustomControlEnableState(this.fUseListRadio.getSelection());
        if (this.fShowFeatures) {
            this.fPluginPathButton.setEnabled(!this.fUseFeaturesRadio.getSelection());
        }
        this.updateStatus();
    }

    private void adjustCustomControlEnableState(boolean enable) {
        this.fVisibleLabel.setVisible(enable);
        this.fPluginTreeViewer.getTree().setVisible(enable);
        this.fDefaultsButton.setVisible(enable);
    }

    protected Control createPluginList(Composite parent) {
        this.fPluginTreeViewer = new CheckboxTreeViewer(parent, 2048);
        this.fPluginTreeViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fPluginTreeViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPluginTreeViewer.setAutoExpandLevel(2);
        this.fPluginTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IPluginModelBase) {
                    AdvancedLauncherTab.this.handleCheckStateChanged((IPluginModelBase)element, event.getChecked());
                } else {
                    AdvancedLauncherTab.this.handleGroupStateChanged(element, event.getChecked());
                }
                AdvancedLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fPluginTreeViewer.setSorter((ViewerSorter)new ListUtil.PluginSorter(){

            public int category(Object obj) {
                if (obj == AdvancedLauncherTab.this.fWorkspacePlugins) {
                    return -1;
                }
                return 0;
            }
        });
        Image pluginsImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ);
        this.fWorkspacePlugins = new NamedElement(PDEPlugin.getResourceString("AdvancedLauncherTab.workspacePlugins"), pluginsImage);
        this.fExternalPlugins = new NamedElement(PDEPlugin.getResourceString("AdvancedLauncherTab.externalPlugins"), pluginsImage);
        return this.fPluginTreeViewer.getTree();
    }

    private void initWorkspacePluginsState(ILaunchConfiguration config) throws CoreException {
        this.fNumWorkspaceChecked = this.fWorkspaceModels.length;
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, true);
        TreeSet deselected = LauncherUtils.parseDeselectedWSIds(config);
        int i = 0;
        while (i < this.fWorkspaceModels.length) {
            if (deselected.contains(this.fWorkspaceModels[i].getPluginBase().getId()) && this.fPluginTreeViewer.setChecked((Object)this.fWorkspaceModels[i], false)) {
                --this.fNumWorkspaceChecked;
            }
            ++i;
        }
        if (this.fNumWorkspaceChecked == 0) {
            this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, false);
        }
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.fWorkspaceModels.length);
    }

    private void initExternalPluginsState(ILaunchConfiguration config) throws CoreException {
        this.fNumExternalChecked = 0;
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fExternalPlugins, false);
        TreeSet selected = LauncherUtils.parseSelectedExtIds(config);
        int i = 0;
        while (i < this.fExternalModels.length) {
            if (selected.contains(this.fExternalModels[i].getPluginBase().getId()) && this.fPluginTreeViewer.setChecked((Object)this.fExternalModels[i], true)) {
                ++this.fNumExternalChecked;
            }
            ++i;
        }
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.fExternalModels.length);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.fUseDefaultRadio.setSelection(config.getAttribute("default", true));
            if (this.fShowFeatures) {
                this.fUseFeaturesRadio.setSelection(config.getAttribute("usefeatures", false));
                this.fUseListRadio.setSelection(!this.fUseDefaultRadio.getSelection() && !this.fUseFeaturesRadio.getSelection());
            } else {
                this.fUseListRadio.setSelection(!this.fUseDefaultRadio.getSelection());
            }
            if (this.fPluginTreeViewer.getInput() == null) {
                this.fPluginTreeViewer.setUseHashlookup(true);
                this.fPluginTreeViewer.setInput((Object)PDEPlugin.getDefault());
                this.fPluginTreeViewer.reveal((Object)this.fWorkspacePlugins);
            }
            if (this.fUseDefaultRadio.getSelection()) {
                this.computeInitialCheckState();
            } else if (this.fUseListRadio.getSelection()) {
                this.initWorkspacePluginsState(config);
                this.initExternalPluginsState(config);
            } else {
                this.fPluginPathButton.setEnabled(false);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.adjustCustomControlEnableState(this.fUseListRadio.getSelection());
        this.updateStatus();
    }

    private void computeInitialCheckState() {
        IPluginModelBase model;
        TreeSet<String> wtable = new TreeSet<String>();
        this.fNumWorkspaceChecked = 0;
        this.fNumExternalChecked = 0;
        int i = 0;
        while (i < this.fWorkspaceModels.length) {
            model = this.fWorkspaceModels[i];
            ++this.fNumWorkspaceChecked;
            String id = model.getPluginBase().getId();
            if (id != null) {
                wtable.add(model.getPluginBase().getId());
            }
            ++i;
        }
        if (this.fNumWorkspaceChecked > 0) {
            this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, true);
        }
        this.fNumExternalChecked = 0;
        i = 0;
        while (i < this.fExternalModels.length) {
            model = this.fExternalModels[i];
            boolean masked = wtable.contains(model.getPluginBase().getId());
            if (!masked && model.isEnabled()) {
                this.fPluginTreeViewer.setChecked((Object)model, true);
                ++this.fNumExternalChecked;
            }
            ++i;
        }
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.fExternalModels.length);
    }

    private void handleCheckStateChanged(IPluginModelBase model, boolean checked) {
        if (model.getUnderlyingResource() == null) {
            this.fNumExternalChecked = checked ? ++this.fNumExternalChecked : --this.fNumExternalChecked;
            this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
            this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.fExternalModels.length);
        } else {
            this.fNumWorkspaceChecked = checked ? ++this.fNumWorkspaceChecked : --this.fNumWorkspaceChecked;
            this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
            this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.fWorkspaceModels.length);
        }
    }

    private void handleGroupStateChanged(Object group, boolean checked) {
        this.fPluginTreeViewer.setSubtreeChecked(group, checked);
        this.fPluginTreeViewer.setGrayed(group, false);
        if (group == this.fWorkspacePlugins) {
            this.fNumWorkspaceChecked = checked ? this.fWorkspaceModels.length : 0;
        } else if (group == this.fExternalPlugins) {
            this.fNumExternalChecked = checked ? this.fExternalModels.length : 0;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("default", true);
        if (this.fShowFeatures) {
            config.setAttribute("usefeatures", false);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("default", this.fUseDefaultRadio.getSelection());
        if (this.fShowFeatures) {
            config.setAttribute("usefeatures", this.fUseFeaturesRadio.getSelection());
        }
        if (this.fUseListRadio.getSelection()) {
            StringBuffer wbuf = new StringBuffer();
            int i = 0;
            while (i < this.fWorkspaceModels.length) {
                IPluginModelBase model = this.fWorkspaceModels[i];
                if (!this.fPluginTreeViewer.getChecked((Object)model)) {
                    wbuf.append(String.valueOf(model.getPluginBase().getId()) + File.pathSeparatorChar);
                }
                ++i;
            }
            config.setAttribute("wsproject", wbuf.toString());
            StringBuffer exbuf = new StringBuffer();
            Object[] checked = this.fPluginTreeViewer.getCheckedElements();
            int i2 = 0;
            while (i2 < checked.length) {
                if (checked[i2] instanceof ExternalPluginModelBase) {
                    IPluginModelBase model = (IPluginModelBase)checked[i2];
                    exbuf.append(String.valueOf(model.getPluginBase().getId()) + File.pathSeparatorChar);
                }
                ++i2;
            }
            config.setAttribute("extplugins", exbuf.toString());
        } else {
            config.setAttribute("wsproject", null);
            config.setAttribute("extplugins", null);
        }
    }

    private void showPluginPaths() {
        try {
            URL[] urls = TargetPlatform.createPluginPath((IPluginModelBase[])this.getPlugins());
            PluginPathDialog dialog = new PluginPathDialog(this.fPluginPathButton.getShell(), urls);
            dialog.create();
            dialog.getShell().setText(PDEPlugin.getResourceString("AdvancedLauncherTab.pluginPath.title"));
            dialog.getShell().setSize(500, 500);
            dialog.open();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void updateStatus() {
        this.updateStatus(this.validatePlugins());
    }

    private IStatus validatePlugins() {
        if (this.fShowFeatures && this.fUseFeaturesRadio.getSelection()) {
            IPath workspacePath = PDEPlugin.getWorkspace().getRoot().getLocation();
            IPath featurePath = workspacePath.removeLastSegments(1).append("features");
            if (!workspacePath.lastSegment().equalsIgnoreCase("plugins") || !featurePath.toFile().exists()) {
                return AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString("AdvancedLauncherTab.error.featureSetup"));
            }
        }
        return AbstractLauncherTab.createStatus(0, "");
    }

    private IPluginModelBase[] getPlugins() {
        if (this.fUseDefaultRadio.getSelection()) {
            String id;
            TreeMap<String, IPluginModelBase> map = new TreeMap<String, IPluginModelBase>();
            int i = 0;
            while (i < this.fWorkspaceModels.length) {
                id = this.fWorkspaceModels[i].getPluginBase().getId();
                if (id != null) {
                    map.put(id, this.fWorkspaceModels[i]);
                }
                ++i;
            }
            i = 0;
            while (i < this.fExternalModels.length) {
                id = this.fExternalModels[i].getPluginBase().getId();
                if (id != null && !map.containsKey(id) && this.fExternalModels[i].isEnabled()) {
                    map.put(id, this.fExternalModels[i]);
                }
                ++i;
            }
            return map.values().toArray(new IPluginModelBase[map.size()]);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] elements = this.fPluginTreeViewer.getCheckedElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IPluginModelBase) {
                result.add(elements[i]);
            }
            ++i;
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public String getName() {
        return PDEPlugin.getResourceString("AdvancedLauncherTab.name");
    }

    public Image getImage() {
        return this.fImage;
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return !(parent instanceof IPluginModelBase);
        }

        public Object[] getChildren(Object parent) {
            if (parent == AdvancedLauncherTab.this.fExternalPlugins) {
                return AdvancedLauncherTab.this.fExternalModels;
            }
            if (parent == AdvancedLauncherTab.this.fWorkspacePlugins) {
                return AdvancedLauncherTab.this.fWorkspaceModels;
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getElements(Object input) {
            return new Object[]{AdvancedLauncherTab.this.fWorkspacePlugins, AdvancedLauncherTab.this.fExternalPlugins};
        }
    }
}

