/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.feature;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class SiteHTMLPage
extends WizardPage {
    private boolean createSite = false;
    public static final String HTML_PAGE_TITLE = "SiteHTMLPage.HTMLPage.title";
    public static final String HTML_PAGE_DESC = "SiteHTMLPage.HTMLPage.desc";
    public static final String HTML_CHECK_LABEL = "SiteHTMLPage.HTMLPage.checkLabel";
    public static final String HTML_PLUGIN_LABEL = "SiteHTMLPage.HTMLPage.pluginLabel";
    public static final String HTML_FEATURE_LABEL = "SiteHTMLPage.HTMLPage.featureLabel";
    public static final String HTML_WEB_LABEL = "SiteHTMLPage.HTMLPage.webLabel";
    public static final String WEB_ERR = "SiteHTMLPage.HTMLPage.webError";
    public static final String PLUGIN_ERR = "SiteHTMLPage.HTMLPage.pluginError";
    public static final String FEATURE_ERR = "SiteHTMLPage.HTMLPage.featureError";
    private static final int SIZING_TEXT_FIELD_WIDTH = 350;
    protected Text pluginText;
    protected Text chkText;
    protected Text featureText;
    protected Text webText;
    private Listener textModifyListener = new Listener(){

        public void handleEvent(Event e) {
            SiteHTMLPage.this.setPageComplete(SiteHTMLPage.this.validatePage());
            SiteHTMLPage.this.setErrorMessage(SiteHTMLPage.this.getStatusString());
        }
    };

    public SiteHTMLPage(WizardNewProjectCreationPage mainPage) {
        super("htmlPage");
        this.setTitle(PDEPlugin.getResourceString(HTML_PAGE_TITLE));
        this.setDescription(PDEPlugin.getResourceString(HTML_PAGE_DESC));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createSettingsGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void createSettingsGroup(Composite container) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label pluginLabel = new Label(container, 0);
        pluginLabel.setText(PDEPlugin.getResourceString(HTML_PLUGIN_LABEL));
        GridData gd = new GridData(768);
        pluginLabel.setLayoutData((Object)gd);
        this.pluginText = new Text(container, 2052);
        gd = new GridData(768);
        gd.widthHint = 350;
        this.pluginText.setLayoutData((Object)gd);
        this.pluginText.setText("plugins");
        this.pluginText.addListener(24, this.textModifyListener);
        Label featureLabel = new Label(container, 0);
        featureLabel.setText(PDEPlugin.getResourceString(HTML_FEATURE_LABEL));
        gd = new GridData(768);
        featureLabel.setLayoutData((Object)gd);
        this.featureText = new Text(container, 2052);
        gd = new GridData(768);
        gd.widthHint = 350;
        this.featureText.setLayoutData((Object)gd);
        this.featureText.setText("features");
        this.featureText.addListener(24, this.textModifyListener);
        Label separator = new Label(container, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        final Button htmlButton = new Button(container, 131104);
        htmlButton.setText(PDEPlugin.getResourceString(HTML_CHECK_LABEL));
        gd = new GridData();
        gd.horizontalSpan = 2;
        htmlButton.setLayoutData((Object)gd);
        final Label webLabel = new Label(container, 0);
        webLabel.setText(PDEPlugin.getResourceString(HTML_WEB_LABEL));
        gd = new GridData(768);
        webLabel.setLayoutData((Object)gd);
        this.webText = new Text(container, 2048);
        gd = new GridData(768);
        gd.widthHint = 350;
        this.webText.setLayoutData((Object)gd);
        this.webText.setText("web");
        this.webText.setEnabled(this.createSite);
        webLabel.setEnabled(this.createSite);
        this.webText.addListener(24, this.textModifyListener);
        htmlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SiteHTMLPage.this.createSite = htmlButton.getSelection();
                webLabel.setEnabled(SiteHTMLPage.this.createSite);
                SiteHTMLPage.this.webText.setEnabled(SiteHTMLPage.this.createSite);
                SiteHTMLPage.this.setPageComplete(SiteHTMLPage.this.validatePage());
                SiteHTMLPage.this.setErrorMessage(SiteHTMLPage.this.getStatusString());
            }
        });
    }

    public String getStatusString() {
        if (this.getPluginLocation().equals("")) {
            return PDEPlugin.getResourceString(PLUGIN_ERR);
        }
        if (this.getFeaturesLocation().equals("")) {
            return PDEPlugin.getResourceString(FEATURE_ERR);
        }
        if (this.createSite && this.getWebLocation().equals("")) {
            return PDEPlugin.getResourceString(WEB_ERR);
        }
        return null;
    }

    public boolean isCreateUpdateSiteHTML() {
        return this.createSite;
    }

    public String getPluginLocation() {
        String text = this.pluginText.getText();
        if (text.startsWith(File.separator) || text.startsWith("/")) {
            text = text.substring(1);
        }
        if (text.endsWith(File.separator) || text.endsWith("/")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public String getFeaturesLocation() {
        String text = this.featureText.getText();
        if (text.startsWith(File.separator) || text.startsWith("/")) {
            text = text.substring(1);
        }
        if (text.endsWith(File.separator) || text.endsWith("/")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public String getWebLocation() {
        String text = this.webText.getText();
        if (text.startsWith(File.separator) || text.startsWith("/")) {
            text = text.substring(1);
        }
        if (text.endsWith(File.separator) || text.endsWith("/")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    protected boolean validatePage() {
        if (this.getPluginLocation().equals("") || this.getFeaturesLocation().equals("")) {
            return false;
        }
        return !this.createSite || !this.getWebLocation().equals("");
    }
}

