/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.feature;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.site.WorkspaceSiteBuildModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.feature.SiteData;
import org.eclipse.pde.internal.ui.feature.SiteHTMLPage;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewSiteProjectWizard
extends NewWizard
implements IExecutableExtension {
    public static final String KEY_WTITLE = "NewSiteWizard.wtitle";
    public static final String MAIN_PAGE_TITLE = "NewSiteWizard.MainPage.title";
    public static final String CREATING_PROJECT = "NewSiteWizard.creatingProject";
    public static final String CREATING_FOLDERS = "NewSiteWizard.creatingFolders";
    public static final String CREATING_MANIFEST = "NewSiteWizard.creatingManifest";
    public static final String MAIN_PAGE_DESC = "NewSiteWizard.MainPage.desc";
    public static final String OVERWRITE_SITE = "NewFeatureWizard.overwriteSite";
    private WizardNewProjectCreationPage mainPage;
    private SiteHTMLPage htmlPage;
    private IConfigurationElement config;
    private boolean createdProject = false;

    public NewSiteProjectWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWSITEPRJ_WIZ);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
    }

    public void addPages() {
        this.mainPage = new WizardNewProjectCreationPage("main");
        this.mainPage.setTitle(PDEPlugin.getResourceString(MAIN_PAGE_TITLE));
        this.mainPage.setDescription(PDEPlugin.getResourceString(MAIN_PAGE_DESC));
        this.addPage((IWizardPage)this.mainPage);
        this.htmlPage = new SiteHTMLPage(this.mainPage);
        this.addPage((IWizardPage)this.htmlPage);
    }

    private IFile createSiteManifest(IProject project, SiteData data) throws CoreException {
        IFile file = project.getFile("site.xml");
        if (file.exists()) {
            return file;
        }
        WorkspaceSiteModel model = new WorkspaceSiteModel();
        model.setFile(file);
        ISite site = model.getSite();
        String name = project.getName();
        site.setLabel(name);
        site.setType(data.type);
        site.setURL(data.url);
        model.save();
        model.dispose();
        WorkspaceSiteBuildModel buildModel = new WorkspaceSiteBuildModel();
        IFile buildFile = project.getFile(".sitebuild/sitebuild.xml");
        buildModel.setFile(buildFile);
        ISiteBuild siteBuild = buildModel.getSiteBuild();
        siteBuild.setAutobuild(false);
        siteBuild.setPluginLocation((IPath)new Path(this.htmlPage.getPluginLocation()));
        siteBuild.setFeatureLocation((IPath)new Path(this.htmlPage.getFeaturesLocation()));
        siteBuild.setShowConsole(true);
        buildModel.save();
        buildModel.dispose();
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.pde.ui.siteEditor");
        return file;
    }

    private void createHTMLFile(IProject project) {
        try {
            IFile file = project.getFile("index.html");
            StringWriter swrite = new StringWriter();
            PrintWriter writer = new PrintWriter(swrite);
            writer.println("<html>");
            writer.println("<head>");
            writer.println("<title>" + project.getName() + "</title>");
            writer.println("<style>@import url(\"" + this.htmlPage.getWebLocation() + "/site.css\");</style>");
            writer.println("<script type=\"text/javascript\">");
            writer.println("\tvar returnval = 0;");
            writer.println("\tvar stylesheet, xmlFile, cache, doc;");
            writer.println("\tfunction init(){");
            writer.println("\t\t// NSCP 7.1+ / Mozilla 1.4.1+");
            writer.println("\t\t// Use the standard DOM Level 2 technique, if it is supported");
            writer.println("\t\tif (document.implementation && document.implementation.createDocument) {");
            writer.println("\t\t\txmlFile = document.implementation.createDocument(\"\", \"\", null);");
            writer.println("\t\t\tstylesheet = document.implementation.createDocument(\"\", \"\", null);");
            writer.println("\t\t\txmlFile.load(\"site.xml\");");
            writer.println("\t\t\tstylesheet.load(\"" + this.htmlPage.getWebLocation() + "/site.xsl\");");
            writer.println("\t\t\txmlFile.addEventListener(\"load\", transform, false);");
            writer.println("\t\t\tstylesheet.addEventListener(\"load\", transform, false);");
            writer.println("\t\t}");
            writer.println("\t\t//IE 6.0+ solution");
            writer.println("\t\telse if (window.ActiveXObject) {");
            writer.println("\t\t\txmlFile = new ActiveXObject(\"msxml2.DOMDocument.3.0\");");
            writer.println("\t\t\txmlFile.async = false;");
            writer.println("\t\t\txmlFile.load(\"site.xml\");");
            writer.println("\t\t\tstylesheet = new ActiveXObject(\"msxml2.FreeThreadedDOMDocument.3.0\");");
            writer.println("\t\t\tstylesheet.async = false;");
            writer.println("\t\t\tstylesheet.load(\"" + this.htmlPage.getWebLocation() + "/site.xsl\");");
            writer.println("\t\t\tcache = new ActiveXObject(\"msxml2.XSLTemplate.3.0\");");
            writer.println("\t\t\tcache.stylesheet = stylesheet;");
            writer.println("\t\t\ttransformData();");
            writer.println("\t\t}");
            writer.println("\t}");
            writer.println("\t// separate transformation function for IE 6.0+");
            writer.println("\tfunction transformData(){");
            writer.println("\t\tvar processor = cache.createProcessor();");
            writer.println("\t\tprocessor.input = xmlFile;");
            writer.println("\t\tprocessor.transform();");
            writer.println("\t\tdata.innerHTML = processor.output;");
            writer.println("\t}");
            writer.println("\t// separate transformation function for NSCP 7.1+ and Mozilla 1.4.1+ ");
            writer.println("\tfunction transform(){");
            writer.println("\t\treturnval+=1;");
            writer.println("\t\tif (returnval==2){");
            writer.println("\t\t\tvar processor = new XSLTProcessor();");
            writer.println("\t\t\tprocessor.importStylesheet(stylesheet); ");
            writer.println("\t\t\tdoc = processor.transformToDocument(xmlFile);");
            writer.println("\t\t\tdocument.getElementById(\"data\").innerHTML = doc.documentElement.innerHTML;");
            writer.println("\t\t}");
            writer.println("\t}");
            writer.println("</script>");
            writer.println("</head>");
            writer.println("<body onload=\"init();\">");
            writer.println("<!--[insert static HTML here]-->");
            writer.println("<div id=\"data\"><!-- this is where the transformed data goes --></div>");
            writer.println("</body>");
            writer.println("</html>");
            writer.flush();
            swrite.close();
            ByteArrayInputStream stream = new ByteArrayInputStream(swrite.toString().getBytes("UTF8"));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, false, null);
            } else {
                file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (Exception e) {
            PDEPlugin.logException(e);
        }
    }

    private void createCSSFile(IProject project) {
        try {
            IFile file = project.getFile(String.valueOf(this.htmlPage.getWebLocation()) + "/site.css");
            StringWriter swrite = new StringWriter();
            PrintWriter writer = new PrintWriter(swrite);
            writer.println("<STYLE type=\"text/css\">");
            writer.println("td.spacer {padding-bottom: 10px; padding-top: 10px;}");
            writer.println(".title { font-family: sans-serif; color: #99AACC;}");
            writer.println(".bodyText { font-family: sans-serif; font-size: 9pt; color:#000000;  }");
            writer.println(".sub-header { font-family: sans-serif; font-style: normal; font-weight: bold; font-size: 9pt; color: white;}");
            writer.println(".log-text {font-family: sans-serif; font-style: normal; font-weight: lighter; font-size: 8pt; color:black;}");
            writer.println(".big-header { font-family: sans-serif; font-style: normal; font-weight: bold; font-size: 9pt; color: white; border-top:10px solid white;}");
            writer.println(".light-row {background:#FFFFFF}");
            writer.println(".dark-row {background:#EEEEFF}");
            writer.println(".header {background:#99AADD}");
            writer.println("#indent {word-wrap : break-word;width :300px;text-indent:10px;}");
            writer.println("</STYLE>");
            writer.flush();
            swrite.close();
            ByteArrayInputStream stream = new ByteArrayInputStream(swrite.toString().getBytes("UTF8"));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, false, null);
            } else {
                file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (Exception e) {
            PDEPlugin.logException(e);
        }
    }

    private void createXSLFile(IProject project) {
        try {
            IFile file = project.getFile(String.valueOf(this.htmlPage.getWebLocation()) + "/site.xsl");
            StringWriter swrite = new StringWriter();
            PrintWriter writer = new PrintWriter(swrite);
            writer.println("<xsl:stylesheet version = '1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:msxsl=\"urn:schemas-microsoft-com:xslt\">");
            writer.println("<xsl:output method=\"html\" encoding=\"ISO-8859-1\"/>");
            writer.println("<xsl:key name=\"cat\" match=\"category\" use=\"@name\"/>");
            writer.println("<xsl:template match=\"/\">");
            writer.println("<xsl:for-each select=\"site\">");
            writer.println("\t<html>");
            writer.println("\t<head>");
            writer.println("\t<title>" + project.getName() + "</title>");
            writer.println("\t<style>@import url(\"" + this.htmlPage.getWebLocation() + "/site.css\");</style>");
            writer.println("\t</head>");
            writer.println("\t<body>");
            writer.println("\t<h1 class=\"title\">" + project.getName() + "</h1>");
            writer.println("\t<p class=\"bodyText\"><xsl:value-of select=\"description\"/></p>");
            writer.println("\t<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\">");
            writer.println("\t<xsl:for-each select=\"category-def\">");
            writer.println("\t\t<xsl:sort select=\"@label\" order=\"ascending\" case-order=\"upper-first\"/>");
            writer.println("\t\t<xsl:sort select=\"@name\" order=\"ascending\" case-order=\"upper-first\"/>");
            writer.println("\t<xsl:if test=\"count(key('cat',@name)) != 0\">");
            writer.println("\t\t\t<tr class=\"header\">");
            writer.println("\t\t\t\t<td class=\"sub-header\" width=\"30%\">");
            writer.println("\t\t\t\t\t<xsl:value-of select=\"@name\"/>");
            writer.println("\t\t\t\t</td>");
            writer.println("\t\t\t\t<td class=\"sub-header\" width=\"70%\">");
            writer.println("\t\t\t\t\t<xsl:value-of select=\"description\"/>");
            writer.println("\t\t\t\t</td>");
            writer.println("\t\t\t</tr>");
            writer.println("\t\t\t<xsl:for-each select=\"key('cat',@name)\">");
            writer.println("\t\t\t<xsl:sort select=\"ancestor::feature//@version\" order=\"ascending\"/>");
            writer.println("\t\t\t<xsl:sort select=\"ancestor::feature//@id\" order=\"ascending\" case-order=\"upper-first\"/>");
            writer.println("\t\t\t<tr>");
            writer.println("\t\t\t\t<xsl:choose>");
            writer.println("\t\t\t\t<xsl:when test=\"(position() mod 2 = 1)\">");
            writer.println("\t\t\t\t\t<xsl:attribute name=\"class\">dark-row</xsl:attribute>");
            writer.println("\t\t\t\t</xsl:when>");
            writer.println("\t\t\t\t<xsl:otherwise>");
            writer.println("\t\t\t\t\t<xsl:attribute name=\"class\">light-row</xsl:attribute>");
            writer.println("\t\t\t\t</xsl:otherwise>");
            writer.println("\t\t\t\t</xsl:choose>");
            writer.println("\t\t\t\t<td class=\"log-text\" id=\"indent\">");
            writer.println("\t\t\t\t\t\t<xsl:choose>");
            writer.println("\t\t\t\t\t\t<xsl:when test=\"ancestor::feature//@label\">");
            writer.println("\t\t\t\t\t\t\t<a href=\"{ancestor::feature//@url}\"><xsl:value-of select=\"ancestor::feature//@label\"/></a>");
            writer.println("\t\t\t\t\t\t\t<br/>");
            writer.println("\t\t\t\t\t\t\t<div id=\"indent\">");
            writer.println("\t\t\t\t\t\t\t(<xsl:value-of select=\"ancestor::feature//@id\"/> - <xsl:value-of select=\"ancestor::feature//@version\"/>)");
            writer.println("\t\t\t\t\t\t\t</div>");
            writer.println("\t\t\t\t\t\t</xsl:when>");
            writer.println("\t\t\t\t\t\t<xsl:otherwise>");
            writer.println("\t\t\t\t\t\t<a href=\"{ancestor::feature//@url}\"><xsl:value-of select=\"ancestor::feature//@id\"/> - <xsl:value-of select=\"ancestor::feature//@version\"/></a>");
            writer.println("\t\t\t\t\t\t</xsl:otherwise>");
            writer.println("\t\t\t\t\t\t</xsl:choose>");
            writer.println("\t\t\t\t\t\t<br />");
            writer.println("\t\t\t\t</td>");
            writer.println("\t\t\t\t<td>");
            writer.println("\t\t\t\t\t<table>");
            writer.println("\t\t\t\t\t\t<xsl:if test=\"ancestor::feature//@os\">");
            writer.println("\t\t\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Operating Systems:</td>");
            writer.println("\t\t\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"ancestor::feature//@os\"/></td>");
            writer.println("\t\t\t\t\t\t\t</tr>");
            writer.println("\t\t\t\t\t\t</xsl:if>");
            writer.println("\t\t\t\t\t\t<xsl:if test=\"ancestor::feature//@ws\">");
            writer.println("\t\t\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Windows Systems:</td>");
            writer.println("\t\t\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"ancestor::feature//@ws\"/></td>");
            writer.println("\t\t\t\t\t\t\t</tr>");
            writer.println("\t\t\t\t\t\t</xsl:if>");
            writer.println("\t\t\t\t\t\t<xsl:if test=\"ancestor::feature//@nl\">");
            writer.println("\t\t\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Languages:</td>");
            writer.println("\t\t\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"ancestor::feature//@nl\"/></td>");
            writer.println("\t\t\t\t\t\t\t</tr>");
            writer.println("\t\t\t\t\t\t</xsl:if>");
            writer.println("\t\t\t\t\t\t<xsl:if test=\"ancestor::feature//@arch\">");
            writer.println("\t\t\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Architecture:</td>");
            writer.println("\t\t\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"ancestor::feature//@arch\"/></td>");
            writer.println("\t\t\t\t\t\t\t</tr>");
            writer.println("\t\t\t\t\t\t</xsl:if>");
            writer.println("\t\t\t\t\t</table>");
            writer.println("\t\t\t\t</td>");
            writer.println("\t\t\t</tr>");
            writer.println("\t\t\t</xsl:for-each>");
            writer.println("\t\t\t<tr><td class=\"spacer\"><br/></td><td class=\"spacer\"><br/></td></tr>");
            writer.println("\t\t</xsl:if>");
            writer.println("\t</xsl:for-each>");
            writer.println("\t<xsl:if test=\"count(feature)  &gt; count(feature/category)\">");
            writer.println("\t<tr class=\"header\">");
            writer.println("\t\t<td class=\"sub-header\" colspan=\"2\">");
            writer.println("\t\tUncategorized");
            writer.println("\t\t</td>");
            writer.println("\t</tr>");
            writer.println("\t</xsl:if>");
            writer.println("\t<xsl:choose>");
            writer.println("\t<xsl:when test=\"function-available('msxsl:node-set')\">");
            writer.println("\t   <xsl:variable name=\"rtf-nodes\">");
            writer.println("\t\t<xsl:for-each select=\"feature[not(category)]\">");
            writer.println("\t\t\t<xsl:sort select=\"@id\" order=\"ascending\" case-order=\"upper-first\"/>");
            writer.println("\t\t\t<xsl:sort select=\"@version\" order=\"ascending\" />");
            writer.println("\t\t\t<xsl:value-of select=\".\"/>");
            writer.println("\t\t\t<xsl:copy-of select=\".\" />");
            writer.println("\t\t</xsl:for-each>");
            writer.println("\t   </xsl:variable>");
            writer.println("\t   <xsl:variable name=\"myNodeSet\" select=\"msxsl:node-set($rtf-nodes)/*\"/>");
            writer.println("\t<xsl:for-each select=\"$myNodeSet\">");
            writer.println("\t<tr>");
            writer.println("\t\t<xsl:choose>");
            writer.println("\t\t<xsl:when test=\"position() mod 2 = 1\">");
            writer.println("\t\t<xsl:attribute name=\"class\">dark-row</xsl:attribute>");
            writer.println("\t\t</xsl:when>");
            writer.println("\t\t<xsl:otherwise>");
            writer.println("\t\t<xsl:attribute name=\"class\">light-row</xsl:attribute>");
            writer.println("\t\t</xsl:otherwise>");
            writer.println("\t\t</xsl:choose>");
            writer.println("\t\t<td class=\"log-text\" id=\"indent\">");
            writer.println("\t\t\t<xsl:choose>");
            writer.println("\t\t\t<xsl:when test=\"@label\">");
            writer.println("\t\t\t\t<a href=\"{@url}\"><xsl:value-of select=\"@label\"/></a>");
            writer.println("\t\t\t\t<br />");
            writer.println("\t\t\t\t<div id=\"indent\">");
            writer.println("\t\t\t\t(<xsl:value-of select=\"@id\"/> - <xsl:value-of select=\"@version\"/>)");
            writer.println("\t\t\t\t</div>");
            writer.println("\t\t\t</xsl:when>");
            writer.println("\t\t\t<xsl:otherwise>");
            writer.println("\t\t\t\t<a href=\"{@url}\"><xsl:value-of select=\"@id\"/> - <xsl:value-of select=\"@version\"/></a>");
            writer.println("\t\t\t</xsl:otherwise>");
            writer.println("\t\t\t</xsl:choose>");
            writer.println("\t\t\t<br /><br />");
            writer.println("\t\t</td>");
            writer.println("\t\t<td>");
            writer.println("\t\t\t<table>");
            writer.println("\t\t\t\t<xsl:if test=\"@os\">");
            writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Operating Systems:</td>");
            writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@os\"/></td>");
            writer.println("\t\t\t\t\t</tr>");
            writer.println("\t\t\t\t</xsl:if>");
            writer.println("\t\t\t\t<xsl:if test=\"@ws\">");
            writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Windows Systems:</td>");
            writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@ws\"/></td>");
            writer.println("\t\t\t\t\t</tr>");
            writer.println("\t\t\t\t</xsl:if>");
            writer.println("\t\t\t\t<xsl:if test=\"@nl\">");
            writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Languages:</td>");
            writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@nl\"/></td>");
            writer.println("\t\t\t\t\t</tr>");
            writer.println("\t\t\t\t</xsl:if>");
            writer.println("\t\t\t\t<xsl:if test=\"@arch\">");
            writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Architecture:</td>");
            writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@arch\"/></td>");
            writer.println("\t\t\t\t\t</tr>");
            writer.println("\t\t\t\t</xsl:if>");
            writer.println("\t\t\t</table>");
            writer.println("\t\t</td>");
            writer.println("\t</tr>");
            writer.println("\t</xsl:for-each>");
            writer.println("\t</xsl:when>");
            writer.println("\t<xsl:otherwise>");
            writer.println("\t<xsl:for-each select=\"feature[not(category)]\">");
            writer.println("\t<xsl:sort select=\"@id\" order=\"ascending\" case-order=\"upper-first\"/>");
            writer.println("\t<xsl:sort select=\"@version\" order=\"ascending\" />");
            writer.println("\t<tr>");
            writer.println("\t\t<xsl:choose>");
            writer.println("\t\t<xsl:when test=\"count(preceding-sibling::feature[not(category)]) mod 2 = 1\">");
            writer.println("\t\t<xsl:attribute name=\"class\">dark-row</xsl:attribute>");
            writer.println("\t\t</xsl:when>");
            writer.println("\t\t<xsl:otherwise>");
            writer.println("\t\t<xsl:attribute name=\"class\">light-row</xsl:attribute>");
            writer.println("\t\t</xsl:otherwise>");
            writer.println("\t\t</xsl:choose>");
            writer.println("\t\t<td class=\"log-text\" id=\"indent\">");
            writer.println("\t\t\t<xsl:choose>");
            writer.println("\t\t\t<xsl:when test=\"@label\">");
            writer.println("\t\t\t\t<a href=\"{@url}\"><xsl:value-of select=\"@label\"/></a>");
            writer.println("\t\t\t\t<br />");
            writer.println("\t\t\t\t<div id=\"indent\">");
            writer.println("\t\t\t\t(<xsl:value-of select=\"@id\"/> - <xsl:value-of select=\"@version\"/>)");
            writer.println("\t\t\t\t</div>");
            writer.println("\t\t\t</xsl:when>");
            writer.println("\t\t\t<xsl:otherwise>");
            writer.println("\t\t\t\t<a href=\"{@url}\"><xsl:value-of select=\"@id\"/> - <xsl:value-of select=\"@version\"/></a>");
            writer.println("\t\t\t</xsl:otherwise>");
            writer.println("\t\t\t</xsl:choose>");
            writer.println("\t\t\t<br /><br />");
            writer.println("\t\t</td>");
            writer.println("\t\t<td>");
            writer.println("\t\t\t<table>");
            writer.println("\t\t\t\t<xsl:if test=\"@os\">");
            writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Operating Systems:</td>");
            writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@os\"/></td>");
            writer.println("\t\t\t\t\t</tr>");
            writer.println("\t\t\t\t</xsl:if>");
            writer.println("\t\t\t\t<xsl:if test=\"@ws\">");
            writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Windows Systems:</td>");
            writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@ws\"/></td>");
            writer.println("\t\t\t\t\t</tr>");
            writer.println("\t\t\t\t</xsl:if>");
            writer.println("\t\t\t\t<xsl:if test=\"@nl\">");
            writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Languages:</td>");
            writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@nl\"/></td>");
            writer.println("\t\t\t\t\t</tr>");
            writer.println("\t\t\t\t</xsl:if>");
            writer.println("\t\t\t\t<xsl:if test=\"@arch\">");
            writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Architecture:</td>");
            writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@arch\"/></td>");
            writer.println("\t\t\t\t\t</tr>");
            writer.println("\t\t\t\t</xsl:if>");
            writer.println("\t\t\t</table>");
            writer.println("\t\t</td>");
            writer.println("\t</tr>");
            writer.println("\t</xsl:for-each>");
            writer.println("\t</xsl:otherwise>");
            writer.println("\t</xsl:choose>");
            writer.println("\t</table>");
            writer.println("\t</body>");
            writer.println("\t</html>");
            writer.println("</xsl:for-each>");
            writer.println("</xsl:template>");
            writer.println("</xsl:stylesheet>");
            writer.flush();
            swrite.close();
            ByteArrayInputStream stream = new ByteArrayInputStream(swrite.toString().getBytes("UTF8"));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, false, null);
            } else {
                file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (Exception e) {
            PDEPlugin.logException(e);
        }
    }

    private boolean createSiteProject(IProject project, IPath location, SiteData data, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(CREATING_PROJECT), 4);
        if (!location.append(project.getName()).toFile().exists()) {
            CoreUtility.createProject((IProject)project, (IPath)location, (IProgressMonitor)monitor);
            project.open(monitor);
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.UpdateSiteNature", (IProgressMonitor)monitor);
        }
        this.createFolders(project, monitor);
        if (!this.createdProject) {
            monitor.worked(2);
            monitor.subTask(PDEPlugin.getResourceString(CREATING_MANIFEST));
            IFile file = this.createSiteManifest(project, data);
            this.createdProject = true;
            monitor.worked(1);
            this.openSiteManifest(file);
            monitor.worked(1);
        } else {
            IFile siteFile;
            if (!project.isOpen()) {
                project.open(monitor);
            }
            if ((siteFile = project.getFile("site.xml")).exists()) {
                this.openSiteManifest(siteFile);
            }
            monitor.worked(4);
        }
        if (this.htmlPage.isCreateUpdateSiteHTML()) {
            this.createXSLFile(project);
            this.createCSSFile(project);
            this.createHTMLFile(project);
        }
        return true;
    }

    private void createFolders(IProject project, IProgressMonitor monitor) throws CoreException {
        String[] names = new String[]{this.htmlPage.getWebLocation(), this.htmlPage.getFeaturesLocation(), this.htmlPage.getPluginLocation()};
        int i = 0;
        while (i < names.length) {
            IFolder folder;
            IPath path;
            if (names[i].length() != 0 && (this.htmlPage.isCreateUpdateSiteHTML() || i != 0) && (path = (folder = project.getFolder(names[i])).getProjectRelativePath()).segmentCount() > 0) {
                int j = 1;
                while (j <= path.segmentCount()) {
                    folder = project.getFolder(path.uptoSegment(j).toOSString());
                    if (!folder.exists()) {
                        this.createFolder(project, path.uptoSegment(j).toOSString(), monitor);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.createFolder(project, ".sitebuild", monitor);
    }

    private void createFolder(IProject project, String name, IProgressMonitor monitor) throws CoreException {
        IFolder plugins = project.getFolder(name);
        if (!plugins.exists()) {
            plugins.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        } else {
            monitor.worked(1);
        }
    }

    private void openSiteManifest(IFile manifestFile) {
        IWorkbenchPage page = PDEPlugin.getActivePage();
        StructuredSelection selection = new StructuredSelection((Object)manifestFile);
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$selection);
                }
            });
        }
        FileEditorInput input = new FileEditorInput(manifestFile);
        String id = "org.eclipse.pde.ui.siteEditor";
        try {
            page.openEditor((IEditorInput)input, id);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    public boolean performFinish() {
        final IProject project = this.mainPage.getProjectHandle();
        final IPath location = this.mainPage.getLocationPath();
        final SiteData data = new SiteData();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        NewSiteProjectWizard.this.createSiteProject(project, location, data, monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String property, Object data) throws CoreException {
        this.config = config;
    }
}

