/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.feature.FeatureData;
import org.eclipse.pde.internal.ui.feature.FeatureSpecPage;
import org.eclipse.pde.internal.ui.feature.PluginListPage;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewFeatureProjectWizard
extends NewWizard
implements IExecutableExtension {
    public static final String KEY_WTITLE = "NewFeatureWizard.wtitle";
    public static final String MAIN_PAGE_TITLE = "NewFeatureWizard.MainPage.title";
    public static final String CREATING_PROJECT = "NewFeatureWizard.creatingProject";
    public static final String CREATING_FOLDERS = "NewFeatureWizard.creatingFolders";
    public static final String CREATING_MANIFEST = "NewFeatureWizard.creatingManifest";
    public static final String MAIN_PAGE_DESC = "NewFeatureWizard.MainPage.desc";
    public static final String OVERWRITE_FEATURE = "NewFeatureWizard.overwriteFeature";
    private WizardNewProjectCreationPage mainPage;
    private FeatureSpecPage specPage;
    private PluginListPage pluginListPage;
    private IConfigurationElement config;

    public NewFeatureProjectWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWFTRPRJ_WIZ);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
    }

    public void addPages() {
        this.mainPage = new WizardNewProjectCreationPage("main");
        this.mainPage.setTitle(PDEPlugin.getResourceString(MAIN_PAGE_TITLE));
        this.mainPage.setDescription(PDEPlugin.getResourceString(MAIN_PAGE_DESC));
        this.addPage((IWizardPage)this.mainPage);
        this.specPage = new FeatureSpecPage(this.mainPage);
        this.addPage((IWizardPage)this.specPage);
        if (this.hasInterestingProjects()) {
            this.pluginListPage = new PluginListPage();
            this.addPage((IWizardPage)this.pluginListPage);
        }
    }

    private void createBuildProperties(IProject project) throws CoreException {
        String fileName = "build.properties";
        IPath path = project.getFullPath().append(fileName);
        IFile file = project.getWorkspace().getRoot().getFile(path);
        if (!file.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(file);
            IBuildEntry entry = model.getFactory().createEntry("bin.includes");
            entry.addToken("feature.xml");
            model.getBuild().add(entry);
            model.save();
        }
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.pde.ui.buildEditor");
    }

    private IFile createFeatureManifest(IProject project, FeatureData data, IPluginBase[] plugins) throws CoreException {
        IFile file = project.getFile("feature.xml");
        WorkspaceFeatureModel model = new WorkspaceFeatureModel();
        model.setFile(file);
        IFeature feature = model.getFeature();
        String name = data.name;
        feature.setLabel(name);
        feature.setId(data.id);
        feature.setVersion(data.version);
        feature.setProviderName(data.provider);
        IFeaturePlugin[] added = new IFeaturePlugin[plugins.length];
        int i = 0;
        while (i < plugins.length) {
            IPluginBase plugin = plugins[i];
            FeaturePlugin fplugin = (FeaturePlugin)model.getFactory().createPlugin();
            fplugin.loadFrom(plugin);
            added[i] = fplugin;
            ++i;
        }
        feature.addPlugins(added);
        feature.computeImports();
        model.save();
        model.dispose();
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.pde.ui.featureEditor");
        return file;
    }

    private void createFeatureProject(IProject project, IPath location, FeatureData data, IPluginBase[] plugins, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(CREATING_PROJECT), 3);
        boolean overwrite = true;
        if (location.append(project.getName()).toFile().exists()) {
            overwrite = MessageDialog.openQuestion((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)this.getWindowTitle(), (String)PDEPlugin.getResourceString(OVERWRITE_FEATURE));
        }
        if (overwrite) {
            CoreUtility.createProject((IProject)project, (IPath)location, (IProgressMonitor)monitor);
            project.open(monitor);
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", (IProgressMonitor)monitor);
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.FeatureNature", (IProgressMonitor)monitor);
            JavaCore.create((IProject)project).setRawClasspath(new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER)), JavaCore.newSourceEntry((IPath)new Path(project.getFullPath().toOSString()))}, monitor);
            monitor.subTask(PDEPlugin.getResourceString(CREATING_MANIFEST));
            monitor.worked(1);
            this.createBuildProperties(project);
            monitor.worked(1);
            IFile file = this.createFeatureManifest(project, data, plugins);
            monitor.worked(1);
            this.openFeatureManifest(file);
        } else {
            project.create(monitor);
            project.open(monitor);
            IFile featureFile = project.getFile("feature.xml");
            if (featureFile.exists()) {
                this.openFeatureManifest(featureFile);
            }
            monitor.worked(3);
        }
    }

    private boolean hasInterestingProjects() {
        IWorkspace workspace = PDEPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (WorkspaceModelManager.isPluginProject((IProject)project)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void openFeatureManifest(IFile manifestFile) {
        IWorkbenchPage page = PDEPlugin.getActivePage();
        StructuredSelection selection = new StructuredSelection((Object)manifestFile);
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$selection);
                }
            });
        }
        FileEditorInput input = new FileEditorInput(manifestFile);
        String id = "org.eclipse.pde.ui.featureEditor";
        try {
            page.openEditor((IEditorInput)input, id);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    public boolean performFinish() {
        final IProject project = this.mainPage.getProjectHandle();
        final IPath location = this.mainPage.getLocationPath();
        final FeatureData data = this.specPage.getFeatureData();
        final IPluginBase[] plugins = this.pluginListPage != null ? this.pluginListPage.getSelectedPlugins() : new IPluginBase[]{};
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        NewFeatureProjectWizard.this.createFeatureProject(project, location, data, plugins, monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String property, Object data) throws CoreException {
        this.config = config;
    }
}

