/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.feature;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.feature.FeatureData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class FeatureSpecPage
extends WizardPage {
    public static final String PAGE_TITLE = "NewFeatureWizard.SpecPage.title";
    public static final String PAGE_ID = "NewFeatureWizard.SpecPage.id";
    public static final String PAGE_NAME = "NewFeatureWizard.SpecPage.name";
    public static final String PAGE_VERSION = "NewFeatureWizard.SpecPage.version";
    public static final String PAGE_PROVIDER = "NewFeatureWizard.SpecPage.provider";
    public static final String PAGE_DESC = "NewFeatureWizard.SpecPage.desc";
    public static final String KEY_VERSION_FORMAT = "NewFeatureWizard.SpecPage.versionFormat";
    public static final String KEY_MISSING = "NewFeatureWizard.SpecPage.missing";
    public static final String KEY_INVALID_ID = "NewFeatureWizard.SpecPage.invalidId";
    private WizardNewProjectCreationPage mainPage;
    private Text idText;
    private Text nameText;
    private Text versionText;
    private Text providerText;

    protected FeatureSpecPage(WizardNewProjectCreationPage mainPage) {
        super("specPage");
        this.setTitle(PDEPlugin.getResourceString(PAGE_TITLE));
        this.setDescription(PDEPlugin.getResourceString(PAGE_DESC));
        this.mainPage = mainPage;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 9;
        container.setLayout((Layout)layout);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FeatureSpecPage.this.verifyComplete();
            }
        };
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(PAGE_ID));
        this.idText = new Text(container, 2048);
        GridData gd = new GridData(768);
        this.idText.setLayoutData((Object)gd);
        this.idText.addModifyListener(listener);
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(PAGE_NAME));
        this.nameText = new Text(container, 2048);
        gd = new GridData(768);
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(listener);
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(PAGE_VERSION));
        this.versionText = new Text(container, 2048);
        gd = new GridData(768);
        this.versionText.setLayoutData((Object)gd);
        this.versionText.addModifyListener(listener);
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(PAGE_PROVIDER));
        this.providerText = new Text(container, 2048);
        gd = new GridData(768);
        this.providerText.setLayoutData((Object)gd);
        this.providerText.addModifyListener(listener);
        this.verifyComplete();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.new_feature_data");
    }

    private void initialize() {
        String projectName = this.mainPage.getProjectName();
        this.idText.setText(this.setInitialId(projectName));
        this.nameText.setText(projectName);
        this.versionText.setText("1.0.0");
    }

    private String setInitialId(String projectName) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(projectName, ".");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            int i = 0;
            while (i < token.length()) {
                if (Character.isLetterOrDigit(token.charAt(i))) {
                    buffer.append(token.charAt(i));
                }
                ++i;
            }
            if (!stok.hasMoreTokens() || buffer.charAt(buffer.length() - 1) == '.') continue;
            buffer.append(".");
        }
        return buffer.toString();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
            this.idText.setFocus();
        }
    }

    public boolean finish() {
        return true;
    }

    public FeatureData getFeatureData() {
        FeatureData data = new FeatureData();
        data.id = this.idText.getText();
        try {
            PluginVersionIdentifier pvi = new PluginVersionIdentifier(this.versionText.getText());
            data.version = pvi.toString();
        }
        catch (NumberFormatException numberFormatException) {
            data.version = this.versionText.getText();
        }
        data.provider = this.providerText.getText();
        data.name = this.nameText.getText();
        return data;
    }

    private void verifyComplete() {
        boolean complete = this.idText.getText().length() > 0;
        this.setPageComplete(complete);
        if (complete) {
            String message = this.verifyIdRules();
            if (message != null) {
                this.setPageComplete(false);
                this.setErrorMessage(message);
            } else {
                this.setErrorMessage(null);
                this.verifyVersion();
            }
        } else {
            this.setErrorMessage(PDEPlugin.getResourceString(KEY_MISSING));
        }
    }

    private boolean verifyVersion() {
        String value = this.versionText.getText();
        boolean result = true;
        if (value.length() == 0) {
            result = false;
        }
        try {
            new PluginVersionIdentifier(value);
        }
        catch (Throwable throwable) {
            result = false;
        }
        if (!result) {
            this.setPageComplete(false);
            this.setErrorMessage(PDEPlugin.getResourceString(KEY_VERSION_FORMAT));
        }
        return result;
    }

    private String verifyIdRules() {
        String problemText = PDEPlugin.getResourceString(KEY_INVALID_ID);
        String name = this.idText.getText();
        StringTokenizer stok = new StringTokenizer(name, ".");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            int i = 0;
            while (i < token.length()) {
                if (!Character.isLetterOrDigit(token.charAt(i))) {
                    return problemText;
                }
                ++i;
            }
        }
        return null;
    }
}

