/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.feature;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.feature.BaseBuildAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class BuildSiteAction
implements IObjectActionDelegate,
IPreferenceConstants {
    private ISiteBuildModel fBuildModel;
    private IFile fSiteXML;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IAction action) {
        if (this.fBuildModel == null) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                IWorkspaceRunnable wop = new IWorkspaceRunnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor monitor) throws CoreException {
                        ISiteBuildFeature[] sbFeatures = BuildSiteAction.access$0(1.access$0(this.this$1)).getSiteBuild().getFeatures();
                        monitor.beginTask("", sbFeatures.length);
                        BuildSiteAction.access$1(1.access$0(this.this$1));
                        int i = 0;
                        while (i < sbFeatures.length) {
                            Object var4_4;
                            try {
                                try {
                                    monitor.setTaskName(String.valueOf(PDEPlugin.getResourceString("SiteBuild.feature")) + " " + sbFeatures[i].getId());
                                    BuildSiteAction.access$3(1.access$0(this.this$1), sbFeatures[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                                catch (InvocationTargetException invocationTargetException) {}
                            }
                            catch (Throwable throwable) {
                                var4_4 = null;
                                BuildSiteAction.access$2(1.access$0(this.this$1), sbFeatures[i].getReferencedFeature().getModel());
                                throw throwable;
                            }
                            {
                                var4_4 = null;
                            }
                            BuildSiteAction.access$2(1.access$0(this.this$1), sbFeatures[i].getReferencedFeature().getModel());
                            ++i;
                        }
                        return;
                    }
                };
                try {
                    PDEPlugin.getWorkspace().run(wop, monitor);
                }
                catch (CoreException coreException) {
                    MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("SiteBuild.errorDialog"), (String)PDEPlugin.getResourceString("SiteBuild.errorMessage"));
                }
            }

            static /* synthetic */ BuildSiteAction access$0(1 var0) {
                return var0.BuildSiteAction.this;
            }
        };
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(PDEPlugin.getActiveWorkbenchShell());
        try {
            try {
                pmd.run(false, false, op);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.postBuildCleanup();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.postBuildCleanup();
            return;
        }
    }

    private void doBuildFeature(ISiteBuildFeature sbFeature, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        monitor.beginTask("", 10);
        IFeatureModel model = sbFeature.getReferencedFeature().getModel();
        IFile file = (IFile)model.getUnderlyingResource();
        if (file == null) {
            monitor.done();
            return;
        }
        if (!BaseBuildAction.ensureValid(file, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
            monitor.done();
            return;
        }
        IFile scriptFile = this.makeScript(model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.runScript(scriptFile, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
    }

    private IFile makeScript(IFeatureModel featureModel, IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        FeatureBuildScriptGenerator generator = new FeatureBuildScriptGenerator();
        IProject project = featureModel.getUnderlyingResource().getProject();
        generator.setFeatureRootLocation(project.getLocation().toOSString());
        generator.setGenerateIncludedFeatures(true);
        generator.setAnalyseChildren(true);
        generator.setWorkingDirectory(project.getLocation().toOSString());
        generator.setDevEntries(new String[]{"bin"});
        ArrayList<URL> paths = new ArrayList<URL>();
        IFeatureModel[] models = PDECore.getDefault().getWorkspaceModelManager().getFeatureModels();
        int i = 0;
        while (i < models.length) {
            try {
                paths.add(new URL("file:" + models[i].getInstallLocation() + '/' + "feature.xml"));
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        URL[] plugins = TargetPlatform.createPluginPath();
        URL[] features = paths.toArray(new URL[paths.size()]);
        URL[] all = new URL[plugins.length + paths.size()];
        System.arraycopy(plugins, 0, all, 0, plugins.length);
        System.arraycopy(features, 0, all, plugins.length, features.length);
        generator.setPluginPath(all);
        this.setConfigInfo(featureModel.getFeature());
        generator.setFeature(featureModel.getFeature().getId());
        generator.generate();
        monitor.done();
        return project.getFile("build.xml");
    }

    private void runScript(IFile scriptFile, IProgressMonitor monitor) throws CoreException {
        AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(scriptFile.getLocation().toOSString());
        runner.addUserProperties(this.createProperties());
        runner.setExecutionTargets(new String[]{"build.update.jar", "refresh"});
        runner.run(monitor);
        monitor.done();
    }

    private Map createProperties() throws CoreException {
        IPath path;
        HashMap<String, String> map = new HashMap<String, String>(13);
        IProject project = this.fBuildModel.getUnderlyingResource().getProject();
        IFolder folder = project.getFolder(path = new Path(".sitebuild").append("temp.folder"));
        if (!folder.exists()) {
            CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, null);
        }
        map.put("build.result.folder", folder.getLocation().toOSString());
        ISiteBuild siteBuild = this.fBuildModel.getSiteBuild();
        map.put("plugin.destination", project.getLocation().append(siteBuild.getPluginLocation()).toOSString());
        map.put("feature.destination", project.getLocation().append(siteBuild.getFeatureLocation()).toOSString());
        map.put("baseos", TargetPlatform.getOS());
        map.put("basews", TargetPlatform.getWS());
        map.put("basearch", TargetPlatform.getOSArch());
        map.put("basenl", TargetPlatform.getNL());
        map.put("eclipse.running", "true");
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        map.put("javacFailOnError", "true");
        map.put("javacDebugInfo", store.getBoolean("javacDebugInfo") ? "on" : "off");
        map.put("javacVerbose", store.getString("javacVerbose"));
        map.put("javacSource", store.getString("javacSource"));
        map.put("javacTarget", store.getString("javacTarget"));
        return map;
    }

    private void setConfigInfo(IFeature feature) throws CoreException {
        String os = feature.getOS() == null ? "*" : feature.getOS();
        String ws = feature.getWS() == null ? "*" : feature.getWS();
        String arch = feature.getArch() == null ? "*" : feature.getArch();
        FeatureBuildScriptGenerator.setConfigInfo((String)(String.valueOf(os) + "," + ws + "," + arch));
    }

    private void postBuildCleanup() {
        IProject siteProject = this.fBuildModel.getUnderlyingResource().getProject();
        IFolder tempFolder = siteProject.getFolder(".sitebuild/temp.folder");
        try {
            if (this.fSiteXML != null) {
                this.fSiteXML.touch(null);
            }
            if (tempFolder.exists()) {
                tempFolder.delete(true, false, null);
            }
            siteProject.refreshLocal(2, null);
        }
        catch (CoreException coreException) {}
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        this.fBuildModel = null;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IFile) {
            this.fSiteXML = (IFile)obj;
            IProject project = this.fSiteXML.getProject();
            IWorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
            IResource buildFile = project.findMember(new Path(".sitebuild").append("sitebuild.xml"));
            if (buildFile != null && buildFile instanceof IFile) {
                manager.connect((Object)buildFile, (Object)this);
                this.fBuildModel = (ISiteBuildModel)manager.getModel((Object)buildFile, (Object)this);
                try {
                    this.fBuildModel.load();
                }
                catch (CoreException coreException) {}
                manager.disconnect((Object)buildFile, (Object)this);
            }
        }
    }

    private void deleteBuildFiles(IFeatureModel model) throws CoreException {
        this.deleteBuildFile((IModel)model);
        IFeaturePlugin[] plugins = model.getFeature().getPlugins();
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        int i = 0;
        while (i < plugins.length) {
            ModelEntry entry = manager.findEntry(plugins[i].getId(), plugins[i].getVersion());
            if (entry != null) {
                this.deleteBuildFile((IModel)entry.getActiveModel());
            }
            ++i;
        }
    }

    public void deleteBuildFile(IModel model) throws CoreException {
        IFolder folder;
        IResource resource = model.getUnderlyingResource();
        if (resource == null && this.isCustomBuild(model)) {
            return;
        }
        IProject project = resource.getProject();
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException coreException) {}
        resource = project.getFile("build.xml");
        if (resource.exists()) {
            resource.delete(true, null);
        }
        if ((folder = project.getFolder("temp.folder")).exists()) {
            IResource[] files = folder.members();
            int i = 0;
            while (i < files.length) {
                if (files[i] instanceof IFile) {
                    files[i].move(this.getLogDestination().getFullPath().append(files[i].getName()), true, null);
                }
                ++i;
            }
            folder.delete(true, null);
        }
    }

    protected boolean isCustomBuild(IModel model) throws CoreException {
        IBuild build;
        IBuildEntry entry;
        WorkspaceBuildModel buildModel = null;
        IFile buildFile = model.getUnderlyingResource().getProject().getFile("build.properties");
        if (buildFile.exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        if (buildModel != null && (entry = (build = buildModel.getBuild()).getEntry("custom")) != null) {
            String[] tokens = entry.getTokens();
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i].equals("true")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void deleteLogDestination() {
        IFolder folder = this.fSiteXML.getProject().getFolder("logs");
        if (folder.exists()) {
            try {
                folder.delete(true, null);
            }
            catch (CoreException coreException) {}
        }
    }

    private IFolder getLogDestination() {
        IFolder folder = this.fSiteXML.getProject().getFolder("logs");
        if (!folder.exists()) {
            try {
                CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, null);
            }
            catch (CoreException coreException) {}
        }
        return folder;
    }

    static /* synthetic */ ISiteBuildModel access$0(BuildSiteAction buildSiteAction) {
        return buildSiteAction.fBuildModel;
    }

    static /* synthetic */ void access$1(BuildSiteAction buildSiteAction) {
        buildSiteAction.deleteLogDestination();
    }

    static /* synthetic */ void access$2(BuildSiteAction buildSiteAction, IFeatureModel iFeatureModel) {
        buildSiteAction.deleteBuildFiles(iFeatureModel);
    }

    static /* synthetic */ void access$3(BuildSiteAction buildSiteAction, ISiteBuildFeature iSiteBuildFeature, IProgressMonitor iProgressMonitor) {
        buildSiteAction.doBuildFeature(iSiteBuildFeature, iProgressMonitor);
    }
}

