/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.IWorkspaceModelManager;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.builder.FragmentBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.PluginBuildScriptGenerator;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.feature.BaseBuildAction;

public class BuildPluginAction
extends BaseBuildAction {
    protected void makeScripts(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        Object generator = this.file.getName().toLowerCase().equals("fragment.xml") ? new FragmentBuildScriptGenerator() : new PluginBuildScriptGenerator();
        IProject project = this.file.getProject();
        generator.setWorkingDirectory(project.getLocation().toOSString());
        generator.setDevEntries(new String[]{"bin"});
        generator.setPluginPath(TargetPlatform.createPluginPath());
        try {
            IWorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
            IPluginModelBase model = (IPluginModelBase)manager.getWorkspaceModel(project);
            generator.setModelId(model.getPluginBase().getId());
            generator.generate();
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }
}

