/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.feature;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.feature.BaseBuildAction;

public class BuildFeatureAction
extends BaseBuildAction {
    private IFeatureModel model;

    protected void makeScripts(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        FeatureBuildScriptGenerator generator = new FeatureBuildScriptGenerator();
        String location = this.file.getProject().getLocation().toOSString();
        generator.setWorkingDirectory(location);
        generator.setFeatureRootLocation(location);
        generator.setGenerateIncludedFeatures(true);
        generator.setDevEntries(new String[]{"bin"});
        ArrayList<URL> paths = new ArrayList<URL>();
        IFeatureModel[] models = PDECore.getDefault().getWorkspaceModelManager().getFeatureModels();
        int i = 0;
        while (i < models.length) {
            try {
                paths.add(new URL("file:" + models[i].getInstallLocation() + '/' + "feature.xml"));
            }
            catch (MalformedURLException malformedURLException) {}
            if (models[i].getUnderlyingResource().equals((Object)this.file)) {
                this.model = models[i];
            }
            ++i;
        }
        URL[] plugins = TargetPlatform.createPluginPath();
        URL[] features = paths.toArray(new URL[paths.size()]);
        URL[] all = new URL[plugins.length + paths.size()];
        System.arraycopy(plugins, 0, all, 0, plugins.length);
        System.arraycopy(features, 0, all, plugins.length, features.length);
        generator.setPluginPath(all);
        this.setConfigInfo(this.model.getFeature());
        try {
            generator.setFeature(this.model.getFeature().getId());
            generator.generate();
        }
        catch (Exception e) {
            PDEPlugin.logException(e);
        }
    }

    private void setConfigInfo(IFeature feature) throws CoreException {
        String os = feature.getOS() == null ? "*" : feature.getOS();
        String ws = feature.getWS() == null ? "*" : feature.getWS();
        String arch = feature.getArch() == null ? "*" : feature.getArch();
        FeatureBuildScriptGenerator.setConfigInfo((String)(String.valueOf(os) + "," + ws + "," + arch));
    }

    private void refreshLocal(IFeature feature, IProgressMonitor monitor) throws CoreException {
        IFeaturePlugin[] references = feature.getPlugins();
        int i = 0;
        while (i < references.length) {
            IPluginModelBase refmodel = feature.getReferencedModel(references[i]);
            if (refmodel != null) {
                refmodel.getUnderlyingResource().getProject().refreshLocal(1, monitor);
            }
            ++i;
        }
    }

    protected void refreshLocal(IProgressMonitor monitor) throws CoreException {
        super.refreshLocal(monitor);
        this.refreshLocal(this.model.getFeature(), monitor);
    }
}

