/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.feature;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchShortcut;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class BaseBuildAction
implements IObjectActionDelegate,
IPreferenceConstants {
    protected IFile file;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (!this.file.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                IWorkspaceRunnable wop = new IWorkspaceRunnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            BaseBuildAction.access$0(1.access$0(this.this$1), monitor);
                        }
                        catch (InvocationTargetException e) {
                            PDEPlugin.logException(e);
                        }
                    }
                };
                try {
                    PDEPlugin.getWorkspace().run(wop, monitor);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            static /* synthetic */ BaseBuildAction access$0(1 var0) {
                return var0.BaseBuildAction.this;
            }
        };
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(PDEPlugin.getActiveWorkbenchShell());
        try {
            pmd.run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IFile) {
            this.file = (IFile)obj;
        }
    }

    private void doBuild(IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        monitor.beginTask(PDEPlugin.getResourceString("BuildAction.Validate"), 4);
        if (!BaseBuildAction.ensureValid(this.file, monitor)) {
            monitor.done();
            return;
        }
        monitor.worked(1);
        monitor.setTaskName(PDEPlugin.getResourceString("BuildAction.Generate"));
        this.makeScripts(monitor);
        monitor.worked(1);
        monitor.setTaskName(PDEPlugin.getResourceString("BuildAction.Update"));
        this.refreshLocal(monitor);
        IFile buildFile = this.file.getProject().getFile("build.xml");
        if (buildFile.exists()) {
            buildFile.setDerived(true);
        }
        monitor.worked(1);
        this.setDefaultValues();
        monitor.worked(1);
    }

    protected abstract void makeScripts(IProgressMonitor var1) throws InvocationTargetException, CoreException;

    public static boolean ensureValid(IFile file, IProgressMonitor monitor) throws CoreException {
        IProject project = file.getProject();
        if (!project.getWorkspace().isAutoBuilding()) {
            project.build(10, monitor);
        }
        if (BaseBuildAction.hasErrors(file)) {
            MessageDialog.openError(null, (String)PDEPlugin.getResourceString("BuildAction.ErrorDialog.Title"), (String)PDEPlugin.getResourceString("BuildAction.ErrorDialog.Message"));
            return false;
        }
        return true;
    }

    public static boolean hasErrors(IFile file) throws CoreException {
        IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        int i = 0;
        while (i < markers.length) {
            Object att = markers[i].getAttribute("severity");
            if (att != null && att instanceof Integer && (Integer)att == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void refreshLocal(IProgressMonitor monitor) throws CoreException {
        this.file.getProject().refreshLocal(1, monitor);
    }

    private void setDefaultValues() {
        IProject project = this.file.getProject();
        IFile generatedFile = (IFile)project.findMember("build.xml");
        if (generatedFile == null) {
            return;
        }
        try {
            ILaunchConfigurationWorkingCopy launchCopy;
            List configs = AntLaunchShortcut.findExistingLaunchConfigurations((IFile)generatedFile);
            if (configs.size() == 0) {
                ILaunchConfiguration config = AntLaunchShortcut.createDefaultLaunchConfiguration((IFile)generatedFile);
                launchCopy = config.getWorkingCopy();
            } else {
                launchCopy = ((ILaunchConfiguration)configs.get(0)).getWorkingCopy();
            }
            if (launchCopy == null) {
                return;
            }
            Map<String, String> properties = new HashMap();
            properties = launchCopy.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
            properties.put("basews", TargetPlatform.getWS());
            properties.put("baseos", TargetPlatform.getOS());
            properties.put("basearch", TargetPlatform.getOSArch());
            properties.put("basenl", TargetPlatform.getNL());
            properties.put("eclipse.running", "true");
            IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
            properties.put("javacFailOnError", store.getString("javacFailOnError"));
            properties.put("javacDebugInfo", store.getBoolean("javacDebugInfo") ? "on" : "off");
            properties.put("javacVerbose", store.getString("javacVerbose"));
            properties.put("javacSource", store.getString("javacSource"));
            properties.put("javacTarget", store.getString("javacTarget"));
            launchCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
            launchCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
            launchCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
            launchCopy.doSave();
        }
        catch (CoreException coreException) {}
    }

    static /* synthetic */ void access$0(BaseBuildAction baseBuildAction, IProgressMonitor iProgressMonitor) {
        baseBuildAction.doBuild(iProgressMonitor);
    }
}

