/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.editor.site.ArchiveSection;
import org.eclipse.pde.internal.ui.editor.site.DescriptionSection;
import org.eclipse.pde.internal.ui.editor.site.FeatureSection;
import org.eclipse.pde.internal.ui.editor.site.SitePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.ScrollableSectionForm;

public class SiteForm
extends ScrollableSectionForm {
    private SitePage page;
    private DescriptionSection descriptionSection;
    private FeatureSection featureSection;
    private ArchiveSection archiveSection;

    public SiteForm(SitePage page) {
        this.page = page;
        this.setVerticalFit(true);
    }

    protected void createFormClient(Composite parent) {
        FormWidgetFactory factory = this.getFactory();
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        layout.verticalSpacing = 15;
        this.descriptionSection = new DescriptionSection(this.page);
        Control control = this.descriptionSection.createControl(parent, factory);
        control.setLayoutData((Object)new GridData(768));
        this.featureSection = new FeatureSection(this.page);
        control = this.featureSection.createControl(parent, factory);
        control.setLayoutData((Object)new GridData(1808));
        this.archiveSection = new ArchiveSection(this.page);
        control = this.archiveSection.createControl(parent, factory);
        control.setLayoutData((Object)new GridData(768));
        this.registerSection(this.descriptionSection);
        this.registerSection(this.featureSection);
        this.registerSection(this.archiveSection);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.pde.doc.user.manifest_site_overview");
    }

    public void dispose() {
        this.unregisterSection(this.descriptionSection);
        this.unregisterSection(this.featureSection);
        super.dispose();
    }

    public void expandTo(Object object) {
    }

    public void initialize(Object modelObject) {
        ISiteModel model = (ISiteModel)modelObject;
        super.initialize((Object)model);
        IEditorInput input = this.page.getEditor().getEditorInput();
        String name = input.getName();
        this.setHeadingText(model.getResourceString(name));
        ((Composite)this.getControl()).layout(true);
    }

    public void setFocus() {
        this.descriptionSection.setFocus();
    }
}

