/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.site.BaseNewDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewArchiveDialog
extends BaseNewDialog {
    private Text pathText;
    private Text urlText;

    public NewArchiveDialog(Shell shell, ISiteModel siteModel, ISiteArchive archive) {
        super(shell, siteModel, (ISiteObject)archive);
    }

    protected void createEntries(Composite container) {
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("SiteEditor.NewArchiveDialog.path"));
        this.pathText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.pathText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(PDEPlugin.getResourceString("SiteEditor.NewArchiveDialog.url")));
        this.urlText = new Text(container, 2052);
        gd = new GridData(768);
        this.urlText.setLayoutData((Object)gd);
        ISiteArchive archive = (ISiteArchive)this.getSiteObject();
        if (archive != null) {
            this.setIfDefined(this.urlText, archive.getURL());
            this.setIfDefined(this.pathText, archive.getPath());
        }
    }

    protected String getDialogTitle() {
        return PDEPlugin.getResourceString(PDEPlugin.getResourceString("SiteEditor.NewArchiveDialog.title"));
    }

    protected String getHelpId() {
        return "org.eclipse.pde.doc.user.new_archive_dialog";
    }

    protected String getEmptyErrorMessage() {
        return PDEPlugin.getResourceString(PDEPlugin.getResourceString("SiteEditor.NewArchiveDialog.error"));
    }

    protected void hookListeners(ModifyListener modifyListener) {
        this.pathText.addModifyListener(modifyListener);
        this.urlText.addModifyListener(modifyListener);
    }

    protected void dialogChanged() {
        IStatus status = null;
        if (this.urlText.getText().length() == 0 || this.pathText.getText().length() == 0) {
            status = this.getEmptyErrorStatus();
        } else if (this.hasPath(this.pathText.getText())) {
            status = this.createErrorStatus(PDEPlugin.getResourceString("NewArchiveDialog.alreadyExists"));
        }
        if (status == null) {
            status = this.getOKStatus();
        }
        this.updateStatus(status);
    }

    private boolean hasPath(String path) {
        ISiteModel model = this.getSiteModel();
        ISiteArchive[] archives = model.getSite().getArchives();
        int i = 0;
        while (i < archives.length) {
            ISiteArchive archive = archives[i];
            String apath = archive.getPath();
            if (apath != null && apath.equals(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ISiteArchive getArchive() {
        return (ISiteArchive)this.getSiteObject();
    }

    protected void execute() {
        boolean add;
        ISiteModel siteModel = this.getSiteModel();
        ISiteArchive archive = this.getArchive();
        boolean bl = add = archive == null;
        if (archive == null) {
            archive = siteModel.getFactory().createArchive();
        }
        try {
            archive.setURL(this.urlText.getText());
            archive.setPath(this.pathText.getText());
            if (add) {
                siteModel.getSite().addArchives(new ISiteArchive[]{archive});
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }
}

