/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEEditorContributor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.site.BuiltFeaturesWizard;
import org.eclipse.pde.internal.ui.editor.site.NewCategoryDefinitionDialog;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.CheckboxTablePart;
import org.eclipse.pde.internal.ui.parts.TablePart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.update.ui.forms.internal.FormEntry;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormTextListener;

public class FeatureSection
extends PDEFormSection {
    private Composite fContainer;
    private TableViewer fFeaturesViewer;
    private boolean fUpdateNeeded;
    private ISiteModel fModel;
    private ISiteBuildModel fBuildModel;
    private Button fExposeButton;
    private Button fPatchButton;
    private FormEntry fURLEntry;
    private FormEntry fTypeEntry;
    private FormEntry fIdEntry;
    private FormEntry fVersionEntry;
    private FormEntry fLabelEntry;
    private FormEntry fOsEntry;
    private FormEntry fWsEntry;
    private FormEntry fArchEntry;
    private FormEntry fNlEntry;
    private TablePart fFeaturesTablePart;
    private CheckboxTablePart fCategoryTablePart;
    private CheckboxTableViewer fCategoryViewer;

    public FeatureSection(PDEFormPage formPage) {
        super(formPage);
        this.setHeaderText(PDEPlugin.getResourceString("SiteEditor.FeatureSection.header"));
        this.setDescription(PDEPlugin.getResourceString("SiteEditor.FeatureSection.desc"));
        this.fModel = (ISiteModel)this.getFormPage().getModel();
        this.fModel.addModelChangedListener((IModelChangedListener)this);
        this.fBuildModel = this.fModel.getBuildModel();
        this.fBuildModel.addModelChangedListener((IModelChangedListener)this);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void dispose() {
        super.dispose();
        this.fModel.removeModelChangedListener((IModelChangedListener)this);
        this.fBuildModel.removeModelChangedListener((IModelChangedListener)this);
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createLeftContainer(container, factory);
        this.createRightContainer(container, factory);
        this.handleFeatureSelectionChanged();
        factory.paintBordersFor(container);
        return container;
    }

    private void createRightContainer(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1810));
        this.fExposeButton = factory.createButton(container, PDEPlugin.getResourceString("SiteEditor.FeatureSection.expose"), 32);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 1;
        this.fExposeButton.setLayoutData((Object)gd);
        this.fExposeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureSection.this.handleExpose(FeatureSection.this.fExposeButton.getSelection());
            }
        });
        this.createPropertiesSection(container, factory);
        factory.paintBordersFor(container);
    }

    private void handleExpose(boolean expose) {
        try {
            this.fContainer.setVisible(this.fExposeButton.getSelection());
            IStructuredSelection ssel = (IStructuredSelection)this.fFeaturesViewer.getSelection();
            ISiteBuildFeature sbFeature = (ISiteBuildFeature)ssel.getFirstElement();
            if (expose) {
                ISiteFeature feature = this.createSiteFeature(sbFeature);
                this.fModel.getSite().addFeatures(new ISiteFeature[]{feature});
                this.resetProperties(feature);
            } else {
                ISiteFeature feature = this.findMatchingSiteFeature(sbFeature);
                if (feature != null) {
                    this.fModel.getSite().removeFeatures(new ISiteFeature[]{feature});
                }
            }
            this.forceDirty();
        }
        catch (CoreException coreException) {}
    }

    private ISiteFeature getSelectedFeatureRef() {
        IStructuredSelection ssel = (IStructuredSelection)this.fFeaturesViewer.getSelection();
        return this.findMatchingSiteFeature((ISiteBuildFeature)ssel.getFirstElement());
    }

    private void createLeftContainer(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.fFeaturesTablePart = new TablePart(new String[]{PDEPlugin.getResourceString("SiteEditor.add"), PDEPlugin.getResourceString("SiteEditor.remove")}){

            protected void buttonSelected(Button button, int index) {
                switch (index) {
                    case 0: {
                        FeatureSection.this.handleNewFeature();
                        break;
                    }
                    case 1: {
                        FeatureSection.this.handleRemoveFeature();
                    }
                }
            }

            protected void selectionChanged(IStructuredSelection selection) {
                FeatureSection.this.handleFeatureSelectionChanged(selection);
            }
        };
        this.fFeaturesTablePart.createControl(container, 2, 2, factory);
        this.createContextMenu(this.fFeaturesTablePart.getControl());
        this.fFeaturesViewer = this.fFeaturesTablePart.getTableViewer();
        this.fFeaturesViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        this.fFeaturesViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fFeaturesViewer.setInput((Object)this.fBuildModel);
        factory.paintBordersFor(container);
    }

    private void createPropertiesSection(Composite parent, FormWidgetFactory factory) {
        this.fContainer = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 1;
        layout.marginHeight = 2;
        layout.verticalSpacing = 8;
        this.fContainer.setLayout((Layout)layout);
        this.fContainer.setLayoutData((Object)new GridData(1808));
        this.createCategorySection(factory);
        this.fPatchButton = factory.createButton(this.fContainer, PDEPlugin.getResourceString("SiteEditor.FeatureSection.patch"), 32);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        this.fPatchButton.setLayoutData((Object)gd);
        this.fPatchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    FeatureSection.this.getSelectedFeatureRef().setIsPatch(FeatureSection.this.fPatchButton.getSelection());
                    FeatureSection.this.forceDirty();
                }
                catch (CoreException coreException) {}
            }
        });
        this.fURLEntry = new FormEntry(this.createText(this.fContainer, PDEPlugin.getResourceString("SiteEditor.FeatureSection.url"), factory, 2));
        this.fURLEntry.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    FeatureSection.this.getSelectedFeatureRef().setURL(text.getValue());
                }
                catch (CoreException coreException) {}
            }

            public void textDirty(FormEntry text) {
                FeatureSection.this.forceDirty();
            }
        });
        this.fLabelEntry = new FormEntry(this.createText(this.fContainer, PDEPlugin.getResourceString("SiteEditor.FeatureSection.label"), factory, 2));
        this.fLabelEntry.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    FeatureSection.this.getSelectedFeatureRef().setLabel(text.getValue());
                }
                catch (CoreException coreException) {}
            }

            public void textDirty(FormEntry text) {
                FeatureSection.this.forceDirty();
            }
        });
        this.fIdEntry = new FormEntry(this.createText(this.fContainer, PDEPlugin.getResourceString("SiteEditor.FeatureSection.id"), factory, 2));
        this.fIdEntry.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    FeatureSection.this.getSelectedFeatureRef().setId(text.getValue());
                }
                catch (CoreException coreException) {}
            }

            public void textDirty(FormEntry text) {
                FeatureSection.this.forceDirty();
            }
        });
        this.fVersionEntry = new FormEntry(this.createText(this.fContainer, PDEPlugin.getResourceString("SiteEditor.FeatureSection.version"), factory, 2));
        this.fVersionEntry.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    FeatureSection.this.getSelectedFeatureRef().setVersion(text.getValue());
                }
                catch (CoreException coreException) {}
            }

            public void textDirty(FormEntry text) {
                FeatureSection.this.forceDirty();
            }
        });
        this.fTypeEntry = new FormEntry(this.createText(this.fContainer, PDEPlugin.getResourceString("SiteEditor.FeatureSection.type"), factory, 2));
        this.fTypeEntry.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    FeatureSection.this.getSelectedFeatureRef().setType(text.getValue());
                }
                catch (CoreException coreException) {}
            }

            public void textDirty(FormEntry text) {
                FeatureSection.this.forceDirty();
            }
        });
        this.fOsEntry = new FormEntry(this.createText(this.fContainer, PDEPlugin.getResourceString("SiteEditor.FeatureSection.os"), factory, 2));
        this.fOsEntry.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    FeatureSection.this.getSelectedFeatureRef().setOS(text.getValue());
                }
                catch (CoreException coreException) {}
            }

            public void textDirty(FormEntry text) {
                FeatureSection.this.forceDirty();
            }
        });
        this.fWsEntry = new FormEntry(this.createText(this.fContainer, PDEPlugin.getResourceString("SiteEditor.FeatureSection.ws"), factory, 2));
        this.fWsEntry.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    FeatureSection.this.getSelectedFeatureRef().setWS(text.getValue());
                }
                catch (CoreException coreException) {}
            }

            public void textDirty(FormEntry text) {
                FeatureSection.this.forceDirty();
            }
        });
        this.fNlEntry = new FormEntry(this.createText(this.fContainer, PDEPlugin.getResourceString("SiteEditor.FeatureSection.nl"), factory, 2));
        this.fNlEntry.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    FeatureSection.this.getSelectedFeatureRef().setNL(text.getValue());
                }
                catch (CoreException coreException) {}
            }

            public void textDirty(FormEntry text) {
                FeatureSection.this.forceDirty();
            }
        });
        this.fArchEntry = new FormEntry(this.createText(this.fContainer, PDEPlugin.getResourceString("SiteEditor.FeatureSection.arch"), factory, 2));
        this.fArchEntry.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    FeatureSection.this.getSelectedFeatureRef().setArch(text.getValue());
                }
                catch (CoreException coreException) {}
            }

            public void textDirty(FormEntry text) {
                FeatureSection.this.forceDirty();
            }
        });
        factory.paintBordersFor(this.fContainer);
    }

    private void createCategorySection(FormWidgetFactory factory) {
        Label label = factory.createLabel(this.fContainer, PDEPlugin.getResourceString("SiteEditor.FeatureSection.category"));
        label.setLayoutData((Object)new GridData(2));
        this.fCategoryTablePart = new CheckboxTablePart(new String[]{PDEPlugin.getResourceString("SiteEditor.add"), PDEPlugin.getResourceString("SiteEditor.edit"), PDEPlugin.getResourceString("SiteEditor.remove")}){

            protected void buttonSelected(Button button, int index) {
                switch (index) {
                    case 0: {
                        FeatureSection.this.handleAddCategoryDefinition();
                        break;
                    }
                    case 1: {
                        FeatureSection.this.handleEditCategoryDefinition();
                        break;
                    }
                    case 2: {
                        FeatureSection.this.handleRemoveCategoryDefinition();
                    }
                }
            }

            protected void elementChecked(Object element, boolean checked) {
                FeatureSection.this.handleCheckStateChanged((ISiteCategoryDefinition)element, checked);
            }

            protected void selectionChanged(IStructuredSelection ssel) {
                this.setButtonEnabled(1, ssel != null && ssel.size() == 1);
                this.setButtonEnabled(2, ssel != null && ssel.size() > 0);
            }
        };
        this.fCategoryTablePart.createControl(this.fContainer, 2, 2, factory);
        this.createContextMenu(this.fCategoryTablePart.getControl());
        this.fCategoryTablePart.setButtonEnabled(1, false);
        this.fCategoryTablePart.setButtonEnabled(2, false);
        this.fCategoryViewer = this.fCategoryTablePart.getTableViewer();
        this.fCategoryViewer.setContentProvider((IContentProvider)new CategoryContentProvider());
        this.fCategoryViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fCategoryViewer.setInput((Object)this.fModel.getSite());
    }

    private void createContextMenu(Control control) {
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                mng.add((IAction)new Action(this, PDEPlugin.getResourceString("SiteEditor.remove")){
                    final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        14.access$0(this.this$1).doGlobalAction(ActionFactory.DELETE.getId());
                    }
                });
                mng.add((IContributionItem)new Separator());
                PDEEditorContributor contributor = FeatureSection.this.getFormPage().getEditor().getContributor();
                contributor.contextMenuAboutToShow(mng);
            }

            static /* synthetic */ FeatureSection access$0(14 var0) {
                return var0.FeatureSection.this;
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        control.setMenu(popupMenuManager.createContextMenu(control));
    }

    private void handleCheckStateChanged(ISiteCategoryDefinition def, boolean checked) {
        try {
            ISiteFeature feature = this.getSelectedFeatureRef();
            ISiteCategory[] cats = feature.getCategories();
            if (!checked) {
                int i = 0;
                while (i < cats.length) {
                    if (cats[i].getName().equals(def.getName())) {
                        feature.removeCategories(new ISiteCategory[]{cats[i]});
                        break;
                    }
                    ++i;
                }
            } else {
                ISiteCategory cat = this.fModel.getFactory().createCategory(feature);
                cat.setName(def.getName());
                feature.addCategories(new ISiteCategory[]{cat});
            }
            this.forceDirty();
        }
        catch (CoreException coreException) {}
    }

    private void handleEditCategoryDefinition() {
        IStructuredSelection ssel = (IStructuredSelection)this.fCategoryViewer.getSelection();
        if (ssel != null && ssel.size() == 1) {
            this.showCategoryDialog((ISiteCategoryDefinition)ssel.getFirstElement());
        }
    }

    private void handleAddCategoryDefinition() {
        this.showCategoryDialog(null);
    }

    public void handleNewFeature() {
        Table control = this.fFeaturesViewer.getTable();
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable((Control)control){
            private final /* synthetic */ Control val$control;
            {
                this.val$control = control;
            }

            public void run() {
                BuiltFeaturesWizard wizard = new BuiltFeaturesWizard(FeatureSection.this.fBuildModel);
                WizardDialog dialog = new WizardDialog(this.val$control.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    FeatureSection.this.forceDirty();
                    FeatureSection.this.fFeaturesViewer.getTable().setSelection(FeatureSection.this.fFeaturesViewer.getTable().getItemCount() - 1);
                    FeatureSection.this.handleFeatureSelectionChanged();
                }
            }
        });
    }

    private void handleFeatureSelectionChanged() {
        this.handleFeatureSelectionChanged((IStructuredSelection)this.fFeaturesViewer.getSelection());
    }

    private void handleFeatureSelectionChanged(IStructuredSelection ssel) {
        if (ssel != null) {
            this.fExposeButton.setVisible(ssel.size() == 1);
            this.fContainer.setVisible(this.fExposeButton.getSelection() && ssel.size() == 1);
            if (ssel.size() == 1) {
                ISiteBuildFeature sbFeature = (ISiteBuildFeature)ssel.getFirstElement();
                this.resetProperties(this.findMatchingSiteFeature(sbFeature));
            }
        }
        this.fFeaturesTablePart.setButtonEnabled(1, ssel != null && ssel.size() > 0);
    }

    private void forceDirty() {
        this.setDirty(true);
        ((IEditable)this.fModel).setDirty(true);
        this.getFormPage().getEditor().fireSaveNeeded();
    }

    public void update() {
        if (this.fUpdateNeeded) {
            this.fFeaturesViewer.setInput((Object)this.fBuildModel);
            this.fCategoryViewer.setInput((Object)this.fModel.getSite());
            this.handleFeatureSelectionChanged();
            this.fUpdateNeeded = false;
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        this.fUpdateNeeded = true;
        this.update();
    }

    public void initialize(Object input) {
        this.update();
    }

    public void commitChanges(boolean onSave) {
        if (onSave && this.fBuildModel instanceof WorkspaceSiteBuildModel && ((WorkspaceSiteBuildModel)this.fBuildModel).isDirty()) {
            ((WorkspaceSiteBuildModel)this.fBuildModel).save();
        }
    }

    private ISiteFeature createSiteFeature(ISiteBuildFeature sbfeature) throws CoreException {
        ISiteFeature sfeature = this.fModel.getFactory().createFeature();
        sfeature.setId(sbfeature.getId());
        sfeature.setVersion(sbfeature.getVersion());
        sfeature.setURL(sbfeature.getTargetURL());
        IFeature refFeature = sbfeature.getReferencedFeature();
        sfeature.setOS(refFeature.getOS());
        sfeature.setWS(refFeature.getWS());
        sfeature.setArch(refFeature.getArch());
        sfeature.setNL(refFeature.getNL());
        return sfeature;
    }

    private ISiteFeature findMatchingSiteFeature(ISiteBuildFeature sbfeature) {
        ISiteFeature[] sfeatures = this.fModel.getSite().getFeatures();
        return this.findMatchingSiteFeature(sbfeature, sfeatures);
    }

    private ISiteFeature findMatchingSiteFeature(ISiteBuildFeature sbfeature, ISiteFeature[] sfeatures) {
        int j = 0;
        while (j < sfeatures.length) {
            ISiteFeature sfeature = sfeatures[j];
            if (this.matches(sfeature, sbfeature)) {
                return sfeature;
            }
            ++j;
        }
        return null;
    }

    private boolean matches(ISiteFeature sfeature, ISiteBuildFeature sbfeature) {
        String targetURL = sbfeature.getTargetURL();
        String url = sfeature.getURL();
        return url != null && targetURL != null && url.equalsIgnoreCase(targetURL);
    }

    private void resetProperties(ISiteFeature feature) {
        if (feature == null) {
            this.fExposeButton.setSelection(false);
            this.fContainer.setVisible(false);
        } else {
            this.fExposeButton.setSelection(true);
            this.fPatchButton.setSelection(feature.isPatch());
            ISiteCategory[] cats = feature.getCategories();
            ArrayList<ISiteCategoryDefinition> defs = new ArrayList<ISiteCategoryDefinition>();
            int i = 0;
            while (i < cats.length) {
                defs.add(cats[i].getDefinition());
                ++i;
            }
            this.fCategoryViewer.setCheckedElements(defs.toArray());
            this.fContainer.setVisible(true);
            this.fLabelEntry.setValue(feature.getLabel(), true);
            this.fURLEntry.setValue(feature.getURL(), true);
            this.fIdEntry.setValue(feature.getId(), true);
            this.fVersionEntry.setValue(feature.getVersion(), true);
            this.fTypeEntry.setValue(feature.getType(), true);
            this.fOsEntry.setValue(feature.getOS(), true);
            this.fWsEntry.setValue(feature.getWS(), true);
            this.fArchEntry.setValue(feature.getArch(), true);
            this.fNlEntry.setValue(feature.getNL(), true);
        }
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            if (this.fFeaturesTablePart.getControl().isFocusControl()) {
                return this.handleRemoveFeature();
            }
            if (this.fCategoryTablePart.getControl().isFocusControl()) {
                return this.handleRemoveCategoryDefinition();
            }
        }
        return false;
    }

    private boolean handleRemoveCategoryDefinition() {
        try {
            IStructuredSelection ssel = (IStructuredSelection)this.fCategoryViewer.getSelection();
            if (ssel != null && ssel.size() > 0) {
                ISiteCategoryDefinition[] defs = ssel.toList().toArray(new ISiteCategoryDefinition[ssel.size()]);
                this.fModel.getSite().removeCategoryDefinitions(defs);
                this.fCategoryViewer.refresh();
                this.forceDirty();
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean handleRemoveFeature() {
        try {
            IStructuredSelection ssel = (IStructuredSelection)this.fFeaturesViewer.getSelection();
            if (ssel != null && ssel.size() > 0) {
                ISiteBuildFeature[] sbFeatures = ssel.toList().toArray(new ISiteBuildFeature[ssel.size()]);
                int i = 0;
                while (i < sbFeatures.length) {
                    ISiteFeature feature = this.findMatchingSiteFeature(sbFeatures[i]);
                    if (feature != null) {
                        this.fModel.getSite().removeFeatures(new ISiteFeature[]{feature});
                    }
                    ++i;
                }
                this.fBuildModel.getSiteBuild().removeFeatures(sbFeatures);
                this.forceDirty();
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private void showCategoryDialog(final ISiteCategoryDefinition def) {
        BusyIndicator.showWhile((Display)this.fCategoryViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                NewCategoryDefinitionDialog dialog = new NewCategoryDefinitionDialog(FeatureSection.this.fCategoryViewer.getControl().getShell(), FeatureSection.this.fModel, def);
                dialog.create();
                if (dialog.open() == 0) {
                    FeatureSection.this.forceDirty();
                    FeatureSection.this.fCategoryViewer.refresh();
                }
            }
        });
    }

    class FeatureContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        FeatureContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ISiteBuildModel model = (ISiteBuildModel)inputElement;
            return model.getSiteBuild().getFeatures();
        }
    }

    class CategoryContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        CategoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ISite model = (ISite)inputElement;
            return model.getCategoryDefinitions();
        }
    }
}

